/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.configuration;

import com.google.common.collect.ObjectArrays;
import java.util.HashMap;
import ome.model.enums.UnitsElectricPotential;
import ome.model.enums.UnitsFrequency;
import ome.model.enums.UnitsLength;
import ome.model.enums.UnitsPower;
import ome.model.enums.UnitsTime;
import ome.model.units.ElectricPotential;
import ome.model.units.Frequency;
import ome.model.units.Length;
import ome.model.units.Power;
import ome.model.units.Pressure;
import ome.model.units.Temperature;
import ome.model.units.Time;
import ome.model.units.Unit;
import ome.model.units.UnitEnum;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.Pulse;
import ome.xml.model.enums.UnitsPressure;
import ome.xml.model.enums.UnitsTemperature;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;

public class TagNames {
    public static final String PREFIX_SETTINGS = "User::";
    public static final String OME_ROOT = "OME-Model";
    public static final String OME_ELEM_DETECTOR = "OME:Detector";
    public static final String OME_ELEM_IMAGE = "OME:Image";
    public static final String OME_ELEM_EXPERIMENT = "OME:Experiment";
    public static final String OME_ELEM_PLANE = "OME:Plane";
    public static final String OME_ELEM_OBJECTIVE = "OME:Objective";
    public static final String OME_ELEM_CHANNEL = "OME:Channel";
    public static final String OME_ELEM_IMGENV = "OME:ImagingEnvironment";
    public static final String OME_ELEM_LIGHTSOURCE = "OME:LightSource";
    public static final String OME_ELEM_LASER = "OME:Laser";
    public static final String OME_ELEM_LED = "OME:LightEmittingDiode";
    public static final String OME_ELEM_ARC = "OME:Arc";
    public static final String OME_ELEM_FILAMENT = "OME:Filament";
    public static final String OME_ELEM_GENERICEXCITATIONSOURCE = "OME:Generic_Excitation_Src";
    public static final String OME_ELEM_LIGHTPATH = "OME:LightPath";
    public static final String OME_ELEM_FILTER = "OME:Filter";
    public static final String OME_ELEM_DICHROIC = "OME:Dichroic";
    public static final String OME_ELEM_LIGHTPATH_EM = "OME:EmissionFilter";
    public static final String OME_ELEM_LIGHTPATH_EX = "OME:ExcitationFilter";
    public static final String OME_ELEM_LIGHTPATH_FS = "OME:FilterSet";
    public static final String ELEM_SAMPLE = "Sample";
    public static final String ELEM_EXPERIMENT = "Experiment";
    public static final String[] BOOLEAN_COMBO = new String[]{"true", "false"};
    public static final String ID = "ID";
    public static final String MODEL = "Model";
    public static final String MANUFAC = "Manufacturer";
    public static final String DESC = "Description";
    public static final String NOMMAGN = "Nominal Magnification";
    public static final String CALMAGN = "Calibration Magnification";
    public static final String LENSNA = "Lens NA";
    public static final String IMMERSION = "Immersion";
    public static final String CORRECTION = "Correction";
    public static final String IRIS = "Iris";
    public static final String WORKDIST = "Working Distance";
    public static final UnitsLength WORKDIST_UNIT = UnitsLength.MICROMETER;
    public static final String CORCOLLAR = "User::Correction Collar";
    public static final String OBJ_MEDIUM = "User::Medium";
    public static final String REFINDEX = "User::Refraction Index";
    public static final String CH_NAME = "Name";
    public static final String COLOR = "Color";
    public static final String FLUOROPHORE = "Fluorophore";
    public static final String ILLUMTYPE = "Illumination Type";
    public static final String EXPOSURETIME = "Exposure Time";
    public static final String EXCITWAVELENGTH = "Excitation Wavelength";
    public static final String EMISSIONWAVELENGTH = "Emission Wavelength";
    public static final String IMAGINGMODE = "Imaging Mode";
    public static final String ILLUMINATIONMODE = "Illumination Mode";
    public static final String CONTRASTMETHOD = "Contrast Method";
    public static final String NDFILTER = "ND Filter";
    public static final String PINHOLESIZE = "Pinhole Size";
    public static final UnitsLength PINHOLESIZE_UNIT = UnitsLength.MICROMETER;
    public static final UnitsLength EXCITATIONWL_UNIT = UnitsLength.NANOMETER;
    public static final UnitsLength EMISSIONWL_UNIT = UnitsLength.NANOMETER;
    public static final UnitsTime EXPOSURETIME_UNIT = UnitsTime.SECOND;
    public static final String D_TYPE = "DetectorType";
    public static final String ZOOM = "Zoom";
    public static final String AMPLGAIN = "AmplificationGain";
    public static final String GAIN = "User::Gain";
    public static final String VOLTAGE = "User::Voltage";
    public static final String OFFSET = "User::Offset";
    public static final String CONFZOOM = "User::Confocal Zoom";
    public static final String BINNING = "User::Binning";
    public static final String SUBARRAY = "User::Subarray";
    public static final UnitsElectricPotential VOLTAGE_UNIT = UnitsElectricPotential.VOLT;
    public static final String E_TYPE = "ExperimentType";
    public static final String EXPNAME = "Experimenter Name";
    public static final String PROJECTNAME = "Project Name";
    public static final String GROUP = "Group";
    public static final String PROJECTPARTNER = "Project Partner";
    public static final String IMG_NAME = "Name";
    public static final String IMG_DESC = "Description";
    public static final String ACQTIME = "Acquisition Time";
    public static final String DIMXY = "Dim X x Y";
    public static final String PIXELTYPE = "Pixel Depth";
    public static final String PIXELSIZE = "Pixel Size (XY)";
    public static final String DIMZTC = "Dim Z x T x C";
    public static final String STAGELABEL = "Stage Label (XY)";
    public static final String STAGEPOS = "Stage Position (XY)";
    public static final String STEPSIZE = "Step Size";
    public static final String TIMEINC = "Time Increment";
    public static final String WELLNR = "Well #";
    public static final UnitsLength STAGEPOS_UNIT = UnitsLength.REFERENCEFRAME;
    public static final UnitsLength PIXELSIZE_UNIT = UnitsLength.MICROMETER;
    public static final UnitsTime TIMEINC_UNIT = UnitsTime.SECOND;
    public static final String TEMP = "Temperature";
    public static final String AIRPRESS = "Air Pressure";
    public static final String HUMIDITY = "Humidity %";
    public static final String CO2 = "CO2 Percent %";
    public static final ome.model.enums.UnitsTemperature TEMPERATURE_UNIT = ome.model.enums.UnitsTemperature.CELSIUS;
    public static final ome.model.enums.UnitsPressure PRESSURE_UNIT = ome.model.enums.UnitsPressure.MEGABAR;
    public static final String L_TYPE = "L_Type";
    public static final String A_TYPE = "A_Type";
    public static final String F_TYPE = "F_Type";
    public static final String POWER = "Power";
    public static final String MEDIUM = "Laser Medium";
    public static final String FREQMUL = "Frequency Multiplication";
    public static final String TUNABLE = "Tunable";
    public static final String PULSE = "Pulse";
    public static final String POCKELCELL = "Pockel Cell";
    public static final String REPRATE = "Repititation Rate";
    public static final String PUMP = "Pump";
    public static final String WAVELENGTH = "Wavelength";
    public static final String MAP = "Map";
    public static final UnitsFrequency REPRATE_UNIT_HZ = UnitsFrequency.HERTZ;
    public static final UnitsFrequency REPRATE_UNIT_MHZ = UnitsFrequency.MEGAHERTZ;
    public static final UnitsLength WAVELENGTH_UNIT = UnitsLength.NANOMETER;
    public static final UnitsPower POWER_UNIT = UnitsPower.MILLIWATT;
    public static final String SET_WAVELENGTH = "User::Wavelength";
    public static final String ATTENUATION = "User::Attenuation";
    public static final String PREPDATE = "Prep Date";
    public static final String PREPDESC = "Prep Description";
    public static final String RAWCODE = "Code";
    public static final String RAWDESC = "Description";
    public static final String GRIDBOXNR = "Gridbox Nr";
    public static final String GRIDBOXTYPE = "Gridbox Type";
    public static final String EXPGRID = "Grid (XY)";
    public static final String EXPOBJNR = "Observed Object Nr";
    public static final String EXPOBJTYPE = "Observed Object Type";
    public static final String FILTER = "Filter";
    public static final String FILTER_CLASS = "Class";
    public static final String FILTER_CLASS_EM = "Emission Filter";
    public static final String FILTER_CLASS_EX = "Exitation Filter";
    public static final String FILTER_CLASS_D = "Dichroic";
    public static final String LP_TYPE = "FilterType";
    public static final String FILTERWHEEL = "Filterwheel";
    public static final String TRANSRANGE_IN = "CutIn";
    public static final String TRANSRANGE_OUT = "CutOut";
    public static final UnitsLength TRANSRANGE_UNIT = UnitsLength.NANOMETER;
    public static final String DELTA_T = "Delta T";
    public static final String STAGE_POS_X = "Stage Pos X";
    public static final String STAGE_POS_Y = "Stage Pos Y";
    public static final String STAGE_POS_Z = "Stage Pos Z";
    public static final UnitsTime DELTA_T_UNIT = UnitsTime.SECOND;
    public static final UnitsLength STAGE_POS_X_UNIT = UnitsLength.REFERENCEFRAME;
    public static final UnitsLength STAGE_POS_Y_UNIT = UnitsLength.REFERENCEFRAME;
    public static final UnitsLength STAGE_POS_Z_UNIT = UnitsLength.REFERENCEFRAME;
    public static final HashMap<String, UnitEnum> omeUnitEnumsDef = new HashMap<String, UnitEnum>(){
        {
            this.put("OME:Detector::User::Voltage", VOLTAGE_UNIT);
            this.put("OME:Objective::Working Distance", WORKDIST_UNIT);
            this.put("OME:Channel::Pinhole Size", PINHOLESIZE_UNIT);
            this.put("OME:Channel::Excitation Wavelength", EXCITATIONWL_UNIT);
            this.put("OME:Channel::Emission Wavelength", EMISSIONWL_UNIT);
            this.put("OME:Channel::Exposure Time", EXPOSURETIME_UNIT);
            this.put("OME:Plane::Stage Pos X", STAGEPOS_UNIT);
            this.put("OME:Plane::Stage Pos Y", STAGEPOS_UNIT);
            this.put("OME:Plane::Stage Pos Z", STAGEPOS_UNIT);
            this.put("OME:Image::Stage Position (XY)", STAGEPOS_UNIT);
            this.put("OME:Image::Stage Label (XY)", STAGEPOS_UNIT);
            this.put("OME:Image::Pixel Size (XY)", PIXELSIZE_UNIT);
            this.put("OME:Image::Time Increment", TIMEINC_UNIT);
            this.put("OME:ImagingEnvironment::Temperature", TEMPERATURE_UNIT);
            this.put("OME:ImagingEnvironment::Air Pressure", PRESSURE_UNIT);
            this.put("OME:Laser::Repititation Rate", REPRATE_UNIT_MHZ);
            this.put("OME:Laser::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:Laser::User::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:LightEmittingDiode::User::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:Arc::User::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:Filament::User::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:Generic_Excitation_Src::User::Wavelength", WAVELENGTH_UNIT);
            this.put("OME:Laser::Power", POWER_UNIT);
            this.put("OME:Filament::Power", POWER_UNIT);
            this.put("OME:Generic_Excitation_Src::Power", POWER_UNIT);
            this.put("OME:Filter::CutIn", TRANSRANGE_UNIT);
            this.put("OME:Filter::CutOut", TRANSRANGE_UNIT);
            this.put("OME:Plane::Delta T", DELTA_T_UNIT);
        }
    };

    public static String[] getParents(String type) {
        switch (type) {
            case "OME:Image": {
                return new String[]{OME_ROOT};
            }
            case "OME:ImagingEnvironment": {
                return new String[]{OME_ELEM_IMAGE};
            }
            case "OME:Channel": {
                return new String[]{OME_ELEM_IMAGE};
            }
            case "OME:Objective": {
                return new String[]{OME_ELEM_IMAGE};
            }
            case "OME:Detector": {
                return new String[]{OME_ELEM_CHANNEL};
            }
            case "OME:Filter": {
                return new String[]{OME_ELEM_LIGHTPATH_EM, OME_ELEM_LIGHTPATH_EX};
            }
            case "OME:LightSource": {
                return new String[]{OME_ELEM_CHANNEL};
            }
            case "OME:Laser": {
                return new String[]{OME_ELEM_LIGHTSOURCE};
            }
            case "OME:Arc": {
                return new String[]{OME_ELEM_LIGHTSOURCE};
            }
            case "OME:Filament": {
                return new String[]{OME_ELEM_LIGHTSOURCE};
            }
            case "OME:LightEmittingDiode": {
                return new String[]{OME_ELEM_LIGHTSOURCE};
            }
            case "OME:Generic_Excitation_Src": {
                return new String[]{OME_ELEM_LIGHTSOURCE};
            }
            case "OME:Dichroic": {
                return new String[]{OME_ELEM_LIGHTPATH_EM, OME_ELEM_LIGHTPATH_EX};
            }
            case "OME:LightPath": {
                return new String[]{OME_ELEM_CHANNEL};
            }
            case "OME:EmissionFilter": {
                return new String[]{OME_ELEM_LIGHTPATH};
            }
            case "OME:ExcitationFilter": {
                return new String[]{OME_ELEM_LIGHTPATH};
            }
            case "OME:Experiment": {
                return new String[]{OME_ROOT};
            }
        }
        return null;
    }

    public static String[] getAvailableUnitClasses() {
        return null;
    }

    public static String[] getUnits(String name) {
        String[] units = null;
        switch (name) {
            case "Air Pressure": {
                units = OMEValueConverter.getNames(UnitsPressure.class);
                break;
            }
            case "Temperature": {
                units = OMEValueConverter.getNames(UnitsTemperature.class);
                break;
            }
            case "Repititation Rate": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsFrequency.class);
                break;
            }
            case "Power": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsPower.class);
                break;
            }
            case "Wavelength": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsLength.class);
                break;
            }
            case "User::Wavelength": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsLength.class);
                break;
            }
            case "Working Distance": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsLength.class);
                break;
            }
            case "User::Voltage": {
                units = OMEValueConverter.getNames(ome.xml.model.enums.UnitsElectricPotential.class);
            }
        }
        return units;
    }

    public static Object[] getUnitList(String name) {
        Object[] units = null;
        switch (name) {
            case "Air Pressure": {
                units = UnitsPressure.values();
                break;
            }
            case "Temperature": {
                units = UnitsTemperature.values();
                break;
            }
            case "Repititation Rate": {
                units = ome.xml.model.enums.UnitsFrequency.values();
                break;
            }
            case "Power": {
                units = ome.xml.model.enums.UnitsPower.values();
                break;
            }
            case "Wavelength": {
                units = ome.xml.model.enums.UnitsLength.values();
                break;
            }
            case "User::Wavelength": {
                units = ome.xml.model.enums.UnitsLength.values();
                break;
            }
            case "Working Distance": {
                units = ome.xml.model.enums.UnitsLength.values();
                break;
            }
            case "User::Voltage": {
                units = ome.xml.model.enums.UnitsElectricPotential.values();
            }
        }
        return units;
    }

    public static String[] getEnumerationVal(String name) {
        Object[] values = null;
        switch (name) {
            case "Immersion": {
                values = OMEValueConverter.getNames(Immersion.class);
                break;
            }
            case "Correction": {
                values = OMEValueConverter.getNames(Correction.class);
                break;
            }
            case "User::Medium": {
                values = OMEValueConverter.getNames(Medium.class);
                break;
            }
            case "ExperimentType": {
                values = OMEValueConverter.getNames(ExperimentType.class);
                break;
            }
            case "DetectorType": {
                values = OMEValueConverter.getNames(DetectorType.class);
                break;
            }
            case "FilterType": {
                values = OMEValueConverter.getNames(FilterType.class);
                break;
            }
            case "User::Binning": {
                values = OMEValueConverter.getNames(Binning.class);
                break;
            }
            case "L_Type": {
                values = OMEValueConverter.getNames(LaserType.class);
                break;
            }
            case "A_Type": {
                values = OMEValueConverter.getNames(ArcType.class);
                break;
            }
            case "F_Type": {
                values = OMEValueConverter.getNames(FilamentType.class);
                break;
            }
            case "Laser Medium": {
                values = OMEValueConverter.getNames(LaserMedium.class);
                break;
            }
            case "Tunable": {
                values = BOOLEAN_COMBO;
                break;
            }
            case "Pulse": {
                values = OMEValueConverter.getNames(Pulse.class);
                break;
            }
            case "Pockel Cell": {
                values = BOOLEAN_COMBO;
                break;
            }
        }
        if (values != null) {
            values = (String[])ObjectArrays.concat((Object[])new String[]{""}, (Object[])values, String.class);
        }
        return values;
    }

    public static Unit getUnit(String unitSymbol) {
        if (unitSymbol == null || unitSymbol.equals("")) {
            return null;
        }
        if (UnitsElectricPotential.bySymbol((String)unitSymbol) != null) {
            return new ElectricPotential(0.0, UnitsElectricPotential.bySymbol((String)unitSymbol));
        }
        if (UnitsPower.bySymbol((String)unitSymbol) != null) {
            return new Power(0.0, UnitsPower.bySymbol((String)unitSymbol));
        }
        if (UnitsFrequency.bySymbol((String)unitSymbol) != null) {
            return new Frequency(0.0, UnitsFrequency.bySymbol((String)unitSymbol));
        }
        if (ome.model.enums.UnitsPressure.bySymbol((String)unitSymbol) != null) {
            return new Pressure(0.0, ome.model.enums.UnitsPressure.bySymbol((String)unitSymbol));
        }
        if (UnitsLength.bySymbol((String)unitSymbol) != null) {
            return new Length(0.0, UnitsLength.bySymbol((String)unitSymbol));
        }
        if (ome.model.enums.UnitsTemperature.bySymbol((String)unitSymbol) != null) {
            return new Temperature(0.0, ome.model.enums.UnitsTemperature.bySymbol((String)unitSymbol));
        }
        if (UnitsTime.bySymbol((String)unitSymbol) != null) {
            return new Time(0.0, UnitsTime.bySymbol((String)unitSymbol));
        }
        return null;
    }

    public static Class getUnitClassFromSymbol(String unitSymbol) {
        Unit unit = TagNames.getUnit(unitSymbol);
        if (unit == null) {
            return null;
        }
        return unit.getClass();
    }

    public static Class getUnitClass(String className) {
        if (className.equals(ElectricPotential.class.getName())) {
            return ElectricPotential.class;
        }
        if (className.equals(Power.class.getName())) {
            return Power.class;
        }
        if (className.equals(Frequency.class.getName())) {
            return Frequency.class;
        }
        if (className.equals(Pressure.class.getName())) {
            return Pressure.class;
        }
        if (className.equals(Length.class.getName())) {
            return Length.class;
        }
        if (className.equals(Temperature.class.getName())) {
            return Temperature.class;
        }
        if (className.equals(Time.class.getName())) {
            return Time.class;
        }
        return null;
    }

    public static UnitEnum getUnitEnum(String className, String symbol) {
        if (className.equals(ElectricPotential.class.getName())) {
            return UnitsElectricPotential.bySymbol((String)symbol);
        }
        if (className.equals(Power.class.getName())) {
            return UnitsPower.bySymbol((String)symbol);
        }
        if (className.equals(Frequency.class.getName())) {
            return UnitsFrequency.bySymbol((String)symbol);
        }
        if (className.equals(Pressure.class.getName())) {
            return ome.model.enums.UnitsPressure.bySymbol((String)symbol);
        }
        if (className.equals(Length.class.getName())) {
            return UnitsLength.bySymbol((String)symbol);
        }
        if (className.equals(Temperature.class.getName())) {
            return ome.model.enums.UnitsTemperature.bySymbol((String)symbol);
        }
        if (className.equals(Time.class.getName())) {
            return UnitsTime.bySymbol((String)symbol);
        }
        return null;
    }

    public static String[] getUnitsList(String className) {
        if (className.equals(ElectricPotential.class.getName())) {
            return OMEValueConverter.getUnitSymbols(UnitsElectricPotential.class);
        }
        if (className.equals(Power.class.getName())) {
            return OMEValueConverter.getUnitSymbols(UnitsPower.class);
        }
        if (className.equals(Frequency.class.getName())) {
            return OMEValueConverter.getUnitSymbols(UnitsFrequency.class);
        }
        if (className.equals(Pressure.class.getName())) {
            return OMEValueConverter.getUnitSymbols(ome.model.enums.UnitsPressure.class);
        }
        if (className.equals(Length.class.getName())) {
            return OMEValueConverter.getUnitSymbols(UnitsLength.class);
        }
        if (className.equals(Temperature.class.getName())) {
            return OMEValueConverter.getUnitSymbols(ome.model.enums.UnitsTemperature.class);
        }
        if (className.equals(Time.class.getName())) {
            return OMEValueConverter.getUnitSymbols(UnitsTime.class);
        }
        return null;
    }
}

