/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class FloatEntry
extends Entry {
    private Float value;

    FloatEntry() {
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        String cfgVal = null;
        try {
            cfgVal = node.getFirstChild().getNodeValue();
            this.value = new Float(cfgVal);
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse float entry, name: " + this.getName() + ".", dex);
        }
        catch (NumberFormatException nfe) {
            this.rethrow(cfgVal + " is not a valid float, entry name: " + this.getName() + ".", nfe);
        }
    }

    @Override
    Object getValue() {
        return this.value;
    }
}

