/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.math.geom2D;

import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

public class Line {
    public final PlanePoint origin;
    public final PlanePoint direction;

    public Line(PlanePoint o, PlanePoint p) {
        if (o == null) {
            throw new NullPointerException("No origin.");
        }
        if (p == null) {
            throw new NullPointerException("No point p.");
        }
        if (o.equals(p)) {
            throw new IllegalArgumentException("Need two different points.");
        }
        this.origin = o;
        this.direction = this.origin.vec(p).normalize();
    }

    public Line(PlanePoint p, PlanePoint q, PlanePoint o) {
        if (p == null) {
            throw new NullPointerException("No point p.");
        }
        if (q == null) {
            throw new NullPointerException("No point q.");
        }
        if (o == null) {
            throw new NullPointerException("No origin.");
        }
        if (p.equals(q)) {
            throw new IllegalArgumentException("Need two different points.");
        }
        this.origin = o;
        this.direction = p.vec(q).normalize();
    }

    public PlanePoint getPoint(double k) {
        return new PlanePoint(this.origin.x1 + k * this.direction.x1, this.origin.x2 + k * this.direction.x2);
    }

    public boolean lies(PlanePoint p) {
        if (p == null) {
            throw new NullPointerException("No point.");
        }
        if (this.direction.x1 == 0.0) {
            return p.x1 == this.origin.x1;
        }
        if (this.direction.x2 == 0.0) {
            return p.x2 == this.origin.x2;
        }
        double k1 = (p.x1 - this.origin.x1) / this.direction.x1;
        double k2 = (p.x2 - this.origin.x2) / this.direction.x2;
        return Math.abs(k1 - k2) < 1.0E-5;
    }

    public boolean lies(PlanePoint p, boolean positiveOrientation) {
        if (!this.lies(p)) {
            return false;
        }
        double k = this.direction.x1 != 0.0 ? (p.x1 - this.origin.x1) / this.direction.x1 : (p.x2 - this.origin.x2) / this.direction.x2;
        if (positiveOrientation) {
            return 0.0 <= k;
        }
        return k < 0.0;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof Line) {
            Line other = (Line)o;
            isEqual = this.origin == other.origin && this.direction == other.direction;
        }
        return isEqual;
    }

    public int hashCode() {
        return this.origin.hashCode();
    }
}

