/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.util.ui.GridModel;
import org.openmicroscopy.shoola.util.ui.PlateGridObject;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.WellGridElement;

public class PlateGrid
extends JTable {
    public static final int ASCENDING_LETTER = 0;
    public static final int ASCENDING_NUMBER = 1;
    public static final int DEFAULT_ROWS = 16;
    public static final int DEFAULT_COLUMNS = 24;
    public static final String WELL_FIELDS_PROPERTY = "wellFields";
    public static final Color BACKGROUND_COLOR = Color.WHITE;
    public static final Color GRID_COLOR = new Color(180, 213, 255);
    public static final Color SELECTED_COLOR = new Color(255, 206, 206);
    public static final Color FOCUS_COLOR = new Color(255, 135, 135);
    private static final Dimension CELL_SIZE = new Dimension(10, 10);
    private int typeRow;
    private int typeColumn;
    private List<WellGridElement> validValues;
    private List<Point> selectedCells;

    private boolean isCellInRange(int row, int column) {
        return row >= 0 && row < this.getModel().getRowCount() && column >= 0 && column < this.getModel().getColumnCount();
    }

    private void initialize(int rows, int columns) {
        this.selectedCells = new ArrayList<Point>();
        this.setTableHeader(null);
        this.setModel(new GridModel(rows, columns));
        int width = PlateGrid.CELL_SIZE.width;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setCellSelectionEnabled(true);
        this.setRowHeight(PlateGrid.CELL_SIZE.height);
        this.setDefaultRenderer(Object.class, new GridRenderer(this));
        this.setAutoResizeMode(0);
        this.setGridColor(GRID_COLOR);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point selected;
                boolean b;
                Point p = e.getPoint();
                int row = PlateGrid.this.rowAtPoint(p);
                int column = PlateGrid.this.columnAtPoint(p);
                if (row < 0 || column < 0) {
                    return;
                }
                boolean bl = b = e.isShiftDown() || e.isControlDown();
                if (UIUtilities.isMacOS()) {
                    boolean bl2 = b = e.isShiftDown() || e.isMetaDown();
                }
                if ((selected = PlateGrid.this.findSelectedPoint(row, column)) != null && PlateGrid.this.selectedCells.size() == 1) {
                    return;
                }
                PlateGrid.this.firePropertyChange(PlateGrid.WELL_FIELDS_PROPERTY, null, new PlateGridObject(row, column, b));
            }
        });
    }

    private Point findSelectedPoint(int row, int column) {
        if (!this.isCellInRange(row, column)) {
            return null;
        }
        for (Point p : this.selectedCells) {
            if (p.x != row || p.y != column) continue;
            return p;
        }
        return null;
    }

    public PlateGrid(int typeRow, int typeColumn, List<WellGridElement> values, int rows, int columns) {
        this.typeColumn = typeColumn;
        this.typeRow = typeRow;
        this.validValues = values;
        this.initialize(16, 24);
    }

    public PlateGrid(int typeRow, int typeColumn, List<WellGridElement> values) {
        this(typeRow, typeColumn, values, 16, 24);
    }

    public PlateGrid(int columns) {
        this.validValues = new ArrayList<WellGridElement>();
        for (int i = 0; i < columns; ++i) {
            this.validValues.add(new WellGridElement(0, i));
        }
        this.initialize(1, columns);
    }

    public void selectCell(int row, int column) {
        this.selectCells(Arrays.asList(new Point(row, column)));
    }

    public void selectCells(List<Point> cells) {
        this.selectedCells.clear();
        if (cells == null) {
            return;
        }
        for (Point p : cells) {
            if (!this.isCellInRange(p.x, p.y) || !this.isCellValid(p.x, p.y) || this.isSelectedCell(p.x, p.y)) continue;
            this.selectedCells.add(p);
        }
        this.repaint();
    }

    boolean isCellValid(int row, int column) {
        if (this.validValues == null) {
            return false;
        }
        for (WellGridElement well : this.validValues) {
            if (well.getRow() != row || well.getColumn() != column) continue;
            return well.isValid();
        }
        return false;
    }

    boolean isSelectedCell(int row, int column) {
        if (!this.isCellInRange(row, column)) {
            return false;
        }
        for (Point p : this.selectedCells) {
            if (p.x != row || p.y != column) continue;
            return true;
        }
        return false;
    }

    String getCellToolTip(int row, int column) {
        Object r = "";
        Object c = "";
        r = this.typeRow == 0 ? UIUtilities.LETTERS.get(row) : "" + ++row;
        c = this.typeColumn == 0 ? UIUtilities.LETTERS.get(row) : "" + ++column;
        return (String)r + "-" + (String)c;
    }

    class GridRenderer
    extends DefaultTableCellRenderer {
        private PlateGrid model;

        GridRenderer(PlateGrid model) {
            this.model = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setToolTipText(this.model.getCellToolTip(row, column));
            if (this.model.isCellValid(row, column)) {
                if (this.model.isSelectedCell(row, column)) {
                    this.setBackground(FOCUS_COLOR);
                } else {
                    this.setBackground(SELECTED_COLOR);
                }
            } else {
                this.setBackground(BACKGROUND_COLOR);
            }
            return this;
        }
    }
}

