/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.app.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.jhotdraw.app.Application;

public abstract class AbstractApplicationAction
extends AbstractAction {
    private Application app;
    private PropertyChangeListener applicationListener;

    public AbstractApplicationAction(Application app) {
        this.app = app;
        this.installApplicationListeners(app);
        this.updateApplicationEnabled();
    }

    protected void installApplicationListeners(Application app) {
        if (this.applicationListener == null) {
            this.applicationListener = this.createApplicationListener();
        }
        app.addPropertyChangeListener(this.applicationListener);
    }

    protected void uninstallApplicationListeners(Application app) {
        app.removePropertyChangeListener(this.applicationListener);
    }

    private PropertyChangeListener createApplicationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "enabled") {
                    AbstractApplicationAction.this.updateApplicationEnabled();
                }
            }
        };
    }

    public Application getApplication() {
        return this.app;
    }

    protected void updateApplicationEnabled() {
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public boolean isEnabled() {
        return this.app.isEnabled() && this.enabled;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue = this.enabled;
        this.enabled = newValue;
        this.firePropertyChange("enabled", oldValue && this.app.isEnabled(), newValue && this.app.isEnabled());
    }
}

