/*
 * Decompiled with CFR 0.152.
 */
package ome.services.db;

import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseIdentity {
    private static final Logger log = LoggerFactory.getLogger(DatabaseIdentity.class);
    private final String authority;
    private final String uuid;
    private final String format;

    private static String uuid(SqlAction sql) {
        return sql.dbUuid();
    }

    public DatabaseIdentity(String authority, SqlAction sql) {
        this(authority, DatabaseIdentity.uuid(sql));
    }

    public DatabaseIdentity(String authority, String uuid) {
        this.authority = authority;
        this.uuid = uuid;
        this.format = String.format("urn:lsid:%s:%%s:%s_%%s%%s", authority, uuid);
        log.info("Using LSID format: " + this.format);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean valid(String lsid) {
        return false;
    }

    public boolean own(String lsid) {
        return false;
    }

    public String lsid(Class k, long id) {
        return String.format(this.format, this.parse(k), id, "");
    }

    public String lsid(Class k, long id, long version) {
        return String.format(this.format, this.parse(k), id, ":" + version);
    }

    public String lsid(String ns, String id) {
        return String.format(this.format, ns, id, "");
    }

    public String lsid(String ns, String id, String version) {
        return String.format(this.format, ns, id, version);
    }

    private String parse(Class k) {
        int last;
        String name = k.getSimpleName();
        if (name.substring(last = name.length() - 1).equals("I")) {
            return name.substring(0, last);
        }
        return name;
    }
}

