/*
 * Decompiled with CFR 0.152.
 */
package ome.services.eventlogs;

import ome.api.ITypes;
import ome.conditions.InternalException;
import ome.model.meta.EventLog;
import ome.services.eventlogs.EventLogLoader;
import ome.util.SqlAction;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;

public abstract class PersistentEventLogLoader
extends EventLogLoader {
    protected String key;
    protected ITypes types;
    protected SqlAction sql;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setTypes(ITypes types) {
        this.types = types;
    }

    public void setSqlAction(SqlAction sql) {
        this.sql = sql;
    }

    @Override
    protected EventLog query() {
        long current_id = this.getCurrentId();
        EventLog el = this.nextEventLog(current_id);
        if (el != null) {
            this.setCurrentId(el.getId());
        }
        return el;
    }

    public abstract void initialize();

    public long getCurrentId() {
        long current_id;
        try {
            current_id = this.sql.selectCurrentEventLog(this.key);
        }
        catch (EmptyResultDataAccessException erdae) {
            current_id = -1L;
            this.setCurrentId(-1L);
            this.initialize();
        }
        catch (DataAccessException dae) {
            throw new InternalException("The configuration table seems to be missing \nfrom your database. Please check your server installation instructions \nfor possible reasons.");
        }
        return current_id;
    }

    public void setCurrentId(long id) {
        this.sql.setCurrentEventLog(id, this.key);
    }

    public void deleteCurrentId() {
        this.sql.delCurrentEventLog(this.key);
    }

    @Override
    public long more() {
        long diff = this.lastEventLog().getEntityId() - this.getCurrentId();
        return diff < 0L ? 0L : diff;
    }
}

