/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.xml.model.Dichroic;
import ome.xml.model.enums.FilterType;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class DichroicConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        labelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPane.add(label);
        IconManager icons = IconManager.getInstance();
        JButton applyBtn = new JButton(icons.getIcon(73));
        applyBtn.setToolTipText("Apply table selection");
        applyBtn.setAlignmentX(1.0f);
        labelPane.add(applyBtn);
        return labelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Dichroic d) {
        this.tagMap = new LinkedHashMap();
        if (d != null) {
            try {
                this.tagMap.put("ID", this.convertID(d.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(d.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(d.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Dichroic", "ID", value, prop, "TextField");
    }

    private TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Dichroic", "Model", value, prop, "TextField");
    }

    private TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Dichroic", "Manufacturer", value, prop, "TextField");
    }

    private TagData convertType(FilterType value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Dichroic", "FilterType", val, prop, "ComboBox", OMEValueConverter.getNames(FilterType.class));
    }

    private TagData convertFilterwheel(String value, boolean prop) {
        return new TagData("OME:Dichroic", "Filterwheel", value, prop, "TextField");
    }
}

