/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser.OntologyParser;

public class BioPortal_Parser
extends OntologyParser {
    private String api_key = "c6ae1b27-9f86-4e3c-9dcf-087e1156eabe";

    public BioPortal_Parser(String ontology_restapi_url, String api_key) {
        this(ontology_restapi_url, api_key, "");
    }

    public BioPortal_Parser(String ontology_restapi_url, String api_key, String acronym) {
        super(ontology_restapi_url, acronym);
        if (api_key != null && !api_key.isEmpty()) {
            this.api_key = api_key;
        }
    }

    @Override
    protected String formatURL(String ontology_acronym, String termID_href) {
        String id_utf8 = null;
        try {
            id_utf8 = URLEncoder.encode(termID_href, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ImporterAgent.getRegistry().getLogger().warn((Object)this, "[MDE] Encoding error for ID_href");
            return null;
        }
        return this.REST_URL + "/ontologies/" + ontology_acronym + "/classes/" + id_utf8 + "/children";
    }

    @Override
    protected List<String> getSubClassLabelsWithParents(JsonNode ontology_node, String parentLabel) throws Exception {
        if (ontology_node == null) {
            return null;
        }
        ArrayList<String> labels = new ArrayList<String>();
        String nextPage = ontology_node.get("links").get("nextPage").asText();
        while (nextPage.length() != 0) {
            for (JsonNode cls : ontology_node.get("collection")) {
                if (!cls.get("prefLabel").isNull()) {
                    labels.add(parentLabel + cls.get("prefLabel").asText());
                }
                if (cls.get("links").get("children").isNull()) continue;
                labels.addAll(this.getSubClassLabelsWithParents(this.getNode(cls.get("links").get("children").asText()), parentLabel + cls.get("prefLabel").asText() + ":"));
            }
            if (ontology_node.get("totalCount").asLong() > 0L && !ontology_node.get("links").get("nextPage").isNull()) {
                nextPage = ontology_node.get("links").get("nextPage").asText();
                ontology_node = this.getNode(nextPage);
                continue;
            }
            nextPage = "";
        }
        return labels;
    }

    @Override
    protected List<OntologyElement> getSubClassLabels(JsonNode ontology_node) throws Exception {
        if (ontology_node == null) {
            return null;
        }
        ArrayList<OntologyElement> labels = new ArrayList<OntologyElement>();
        try {
            String nextPage = ontology_node.get("links").get("nextPage").asText();
            while (nextPage.length() != 0) {
                for (JsonNode cls : ontology_node.get("collection")) {
                    List<OntologyElement> subNodes_label = null;
                    if (!cls.get("links").get("children").isNull()) {
                        subNodes_label = this.getSubClassLabels(this.getNode(cls.get("links").get("children").asText()));
                    }
                    if (subNodes_label == null || subNodes_label.isEmpty()) {
                        try {
                            String[] id_term = this.splitOntologyURI(cls.get("@id").asText());
                            OntologyElement oElem = new OntologyElement(cls.get("prefLabel").asText(), id_term[1], id_term[0]);
                            labels.add(oElem);
                            continue;
                        }
                        catch (Exception e) {
                            throw new UnsupportedEncodingException("Error while parsing from Bioportal: " + cls.get("label").asText());
                        }
                    }
                    labels.addAll((Collection<OntologyElement>)subNodes_label);
                }
                if (ontology_node.get("totalCount").asLong() > 0L && !ontology_node.get("links").get("nextPage").isNull()) {
                    nextPage = ontology_node.get("links").get("nextPage").asText();
                    ontology_node = this.getNode(nextPage);
                    continue;
                }
                nextPage = "";
            }
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(String.format("Exception while parsing from %s: %s", this.REST_URL, this.acronym));
        }
        return labels;
    }

    private String[] splitOntologyURI(String id_term) throws UnsupportedEncodingException {
        String uri = "";
        String id = "";
        try {
            if (id_term == null) {
                throw new IllegalArgumentException("Bioportal reader: The term @id is not valid for given ontology element");
            }
            if (id_term.startsWith("http://") || id_term.startsWith("https://")) {
                int brkIdx = -1;
                if (id_term.startsWith("http://purl.obolibrary.org/obo/")) {
                    brkIdx = id_term.lastIndexOf(47);
                }
                if (brkIdx == -1) {
                    brkIdx = id_term.lastIndexOf(35);
                }
                if (brkIdx == -1) {
                    brkIdx = id_term.lastIndexOf(47);
                }
                if (brkIdx != -1) {
                    uri = id_term.substring(0, brkIdx + 1);
                    id = id_term.substring(brkIdx + 1, id_term.length());
                }
            }
        }
        catch (Exception ex) {
            throw new UnsupportedEncodingException("Error while trying parse bioontology term  " + id_term);
        }
        return new String[]{uri, id};
    }

    @Override
    protected HttpURLConnection initURLConnection(URL url) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Authorization", "apikey token=" + this.api_key);
        conn.setRequestProperty("Accept", "application/json");
        return conn;
    }
}

