/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.measurement.view;

import java.awt.Color;
import java.awt.FontMetrics;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openmicroscopy.shoola.agents.measurement.util.ui.ROIAssistantCellRenderer;
import org.openmicroscopy.shoola.agents.measurement.view.ROIAssistantModel;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

class ROIAssistantTable
extends JTable {
    private static final int COLUMNWIDTH = 32;
    private static final Color GRIDCOLOUR = new Color(180, 213, 255);
    private int columnWidth;

    ROIAssistantTable(ROIAssistantModel model) {
        this.setModel(model);
        this.setAutoResizeMode(0);
        this.columnWidth = 0;
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int w = metrics.stringWidth(model.getColumnName(i));
            this.columnWidth = Math.max(w, 32);
            this.columnWidth = Math.max(this.columnWidth, metrics.stringWidth("" + i));
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumnModel().getColumn(i);
            int width = this.columnWidth;
            col.setMinWidth(width);
            col.setMaxWidth(width);
            col.setPreferredWidth(width);
            col.setResizable(false);
        }
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(this.columnWidth);
        this.setGridColor(GRIDCOLOUR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(true);
    }

    int getColumnWidth() {
        return this.columnWidth;
    }

    ROIShape getShapeAt(int row, int col) {
        return ((ROIAssistantModel)this.getModel()).getShapeAt(row, col);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new ROIAssistantCellRenderer();
    }
}

