/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import java.util.ArrayList;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.agents.events.metadata.ChannelSavedEvent;
import org.openmicroscopy.shoola.agents.metadata.EditorLoader;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.EventBus;

public class ChannelDataSaver
extends EditorLoader {
    private List<ChannelData> channels;
    private DataObject parent;
    private CallHandle handle;

    public ChannelDataSaver(Editor viewer, SecurityContext ctx, List<ChannelData> channels, DataObject parent) {
        super(viewer, ctx);
        if (CollectionUtils.isEmpty(channels)) {
            throw new IllegalArgumentException("No Channels specified.");
        }
        this.channels = channels;
        this.parent = parent;
    }

    @Override
    public void load() {
        ArrayList<DataObject> list = new ArrayList<DataObject>();
        if (this.parent != null) {
            list.add(this.parent);
        }
        this.handle = this.dmView.saveChannelData(this.ctx, this.channels, list, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        EventBus bus = MetadataViewerAgent.getRegistry().getEventBus();
        bus.post(new ChannelSavedEvent(this.ctx, this.channels, (List)result));
    }
}

