/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;

public class ExperimenterDataLoader
extends DataBrowserLoader {
    public static final int PROJECT = 0;
    public static final int DATASET = 1;
    public static final int IMAGE = 2;
    public static final int TAG = 3;
    public static final int TAG_SET = 4;
    public static final int FILE = 5;
    public static final int ALL = 6;
    public static final int FILE_DATA = 7;
    private boolean withImages;
    private Class rootNodeType;
    private TreeImageSet parent;
    private TreeImageSet expNode;
    private CallHandle handle;
    private int type;

    private Class getClassType(int type) {
        this.type = type;
        switch (type) {
            case 0: {
                return ProjectData.class;
            }
            case 1: {
                return DatasetData.class;
            }
            case 3: {
                return TagAnnotationData.class;
            }
            case 4: {
                return TagAnnotationData.class;
            }
            case 5: {
                return FileAnnotationData.class;
            }
            case 6: {
                return null;
            }
        }
        return null;
    }

    public ExperimenterDataLoader(Browser viewer, SecurityContext ctx, int containerType, TreeImageSet expNode) {
        this(viewer, ctx, containerType, expNode, null);
    }

    public ExperimenterDataLoader(Browser viewer, SecurityContext ctx, int containerType, TreeImageSet expNode, TreeImageSet parent) {
        super(viewer, ctx);
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        this.parent = parent;
        this.expNode = expNode;
        this.rootNodeType = this.getClassType(containerType);
        if (parent != null) {
            this.withImages = true;
        }
        if (this.type == 4) {
            this.withImages = false;
        }
    }

    @Override
    public void load() {
        long expID = -1L;
        if (this.expNode.getUserObject() instanceof ExperimenterData) {
            expID = ((ExperimenterData)this.expNode.getUserObject()).getId();
        }
        if (TagAnnotationData.class.equals((Object)this.rootNodeType)) {
            long id = -1L;
            if (this.parent != null) {
                id = this.parent.getUserObjectId();
            }
            boolean top = this.type == 4;
            this.handle = this.dmView.loadTags(this.ctx, id, this.withImages, top, expID, this.ctx.getGroupID(), this);
        } else if (FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            this.handle = this.mhView.loadExistingAnnotations(this.ctx, this.rootNodeType, expID, (AgentEventListener)this);
        } else if (this.viewer.getBrowserType() != 4) {
            this.handle = this.parent == null ? this.dmView.loadContainerHierarchy(this.ctx, this.rootNodeType, null, this.withImages, expID, this) : this.dmView.loadContainerHierarchy(this.ctx, this.rootNodeType, Arrays.asList(this.parent.getUserObjectId()), this.withImages, expID, this);
        }
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (this.viewer.getBrowserType() == 4) {
            this.viewer.setRepositories(this.expNode, (FSFileSystemView)result);
            return;
        }
        if (FileAnnotationData.class.equals((Object)this.rootNodeType)) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
            return;
        }
        if (this.parent == null) {
            this.viewer.setExperimenterData(this.expNode, (Collection)result);
        } else {
            Collection nodes = (Collection)result;
            if (nodes.isEmpty()) {
                this.viewer.setLeaves(null, this.parent, this.expNode);
                return;
            }
            Iterator i = nodes.iterator();
            Class<?> klass = this.parent.getUserObject().getClass();
            long id = this.parent.getUserObjectId();
            if (TagAnnotationData.class.equals(klass)) {
                this.viewer.setLeaves((Collection)result, this.parent, this.expNode);
            } else {
                while (i.hasNext()) {
                    DataObject object = (DataObject)i.next();
                    if (!object.getClass().equals(klass) || object.getId() != id || !(object instanceof DatasetData)) continue;
                    this.viewer.setLeaves(((DatasetData)object).getImages(), this.parent, this.expNode);
                }
            }
        }
    }
}

