/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.browser;

import com.google.common.collect.Sets;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.WellSampleData;
import omero.log.LogMessage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.openmicroscopy.shoola.agents.events.treeviewer.ExperimenterLoadedDataEvent;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.RefreshExperimenterDef;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.EditVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ExperimenterVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ParentVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.RefreshVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.UpdateVisitor;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.ContainerFinder;
import org.openmicroscopy.shoola.agents.util.browser.NodeSelectionVisitor;
import org.openmicroscopy.shoola.agents.util.browser.NodesFinder;
import org.openmicroscopy.shoola.agents.util.browser.PartialNameVisitor;
import org.openmicroscopy.shoola.agents.util.browser.SimilarNodesVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeViewerTranslator;
import org.openmicroscopy.shoola.agents.util.dnd.DnDTree;
import org.openmicroscopy.shoola.env.data.FSAccessException;
import org.openmicroscopy.shoola.env.data.FSFileSystemView;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserUI view;
    private BrowserControl controller;
    private TreeImageDisplay toSelectAfterSave;

    private void refreshExperimenterData(List<Long> ids) {
        RefreshVisitor v = new RefreshVisitor(this);
        TreeImageDisplay root = this.view.getTreeRoot();
        int n = root.getChildCount();
        HashMap<SecurityContext, RefreshExperimenterDef> m = new HashMap<SecurityContext, RefreshExperimenterDef>(n);
        int type = this.model.getBrowserType();
        if (this.model.isSingleGroup()) {
            long gid = this.model.getUserDetails().getDefaultGroup().getId();
            for (int i = 0; i < n; ++i) {
                TreeImageSet expNode = (TreeImageSet)root.getChildAt(i);
                if (!ids.contains(expNode.getUserObjectId())) continue;
                expNode.accept(v, 1);
                List<Object> foundNodes = v.getFoundNodes();
                Map<Class<?>, List<Long>> topNodes = v.getExpandedTopNodes();
                if (type == 5) {
                    this.countExperimenterImages(expNode);
                }
                RefreshExperimenterDef def = new RefreshExperimenterDef(expNode, v.getFoundNodes(), v.getExpandedTopNodes());
                SecurityContext ctx = new SecurityContext(gid);
                if (this.model.getDisplayMode() == 1) {
                    ctx.setExperimenter((ExperimenterData)expNode.getUserObject());
                }
                m.put(ctx, def);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                TreeImageSet groupNode = (TreeImageSet)root.getChildAt(i);
                if (!groupNode.isExpanded()) continue;
                long gid = groupNode.getUserObjectId();
                List children = groupNode.getChildrenDisplay();
                for (TreeImageSet expNode : children) {
                    if (!ids.contains(expNode.getUserObjectId())) continue;
                    expNode.accept(v, 1);
                    List<Object> foundNodes = v.getFoundNodes();
                    Map<Class<?>, List<Long>> topNodes = v.getExpandedTopNodes();
                    if (type == 5) {
                        this.countExperimenterImages(expNode);
                    }
                    RefreshExperimenterDef def = new RefreshExperimenterDef(expNode, v.getFoundNodes(), v.getExpandedTopNodes());
                    SecurityContext ctx = new SecurityContext(gid);
                    ctx.setExperimenter((ExperimenterData)expNode.getUserObject());
                    m.put(ctx, def);
                }
            }
        }
        if (!MapUtils.isEmpty(m)) {
            this.model.loadRefreshExperimenterData(m, null, -1L, null, null);
            this.fireStateChange();
        }
    }

    private void removeNodes(List nodes) {
        TreeImageDisplay parentDisplay = this.getLastSelectedDisplay() == null ? this.view.getTreeRoot() : this.getLastSelectedDisplay().getParentDisplay();
        if (parentDisplay == null) {
            parentDisplay = this.view.getTreeRoot();
        }
        this.setSelectedDisplay(parentDisplay);
        this.view.removeNodes(nodes, parentDisplay);
    }

    private void createNodes(List nodes, TreeImageDisplay display, TreeImageDisplay parentDisplay) {
        this.setSelectedDisplay(display);
        Object ho = display.getUserObject();
        if (ho instanceof ProjectData || ho instanceof ScreenData) {
            display.setChildrenLoaded(true);
        } else if (ho instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)ho;
            if ("openmicroscopy.org/omero/insight/tagset".equals(tag.getNameSpace())) {
                display.setChildrenLoaded(true);
            } else {
                display.setChildrenLoaded(false);
            }
        } else {
            display.setChildrenLoaded(false);
        }
        this.view.createNodes(nodes, display, parentDisplay);
        this.countItems(null, display);
    }

    private void handleNodeDisplay(TreeImageDisplay node) {
        this.view.selectFoundNode(node);
    }

    private boolean hasDataToSave(TreeImageDisplay node) {
        if (this.model.getParentModel().hasDataToSave()) {
            this.model.getParentModel().saveMetadata();
            return false;
        }
        return false;
    }

    private void countExperimenterDataInFolders() {
        ContainerFinder finder = new ContainerFinder(ExperimenterData.class);
        this.accept(finder, 1);
        Set<TreeImageSet> nodes = finder.getContainerNodes();
        for (TreeImageSet node : nodes) {
            if (!(node.getUserObject() instanceof ExperimenterData) || !node.isExpanded()) continue;
            this.countExperimenterImages(node);
        }
    }

    private void countItems(List<Class> rootType, TreeImageDisplay node) {
        if (rootType == null) {
            int type = this.model.getBrowserType();
            if (type == 0) {
                rootType = new ArrayList<Class>();
                rootType.add(DatasetData.class);
            } else if (type == 2) {
                rootType = new ArrayList<Class>();
                rootType.add(TagAnnotationData.class);
            } else if (type == 6) {
                rootType = new ArrayList<Class>();
                rootType.add(GroupData.class);
            }
        }
        if (rootType == null) {
            this.countExperimenterDataInFolders();
            return;
        }
        ContainerFinder finder = new ContainerFinder(rootType);
        if (node != null) {
            node.accept(finder, 1);
            Set<DataObject> items = finder.getContainers();
            Set<TreeImageSet> nodes = finder.getContainerNodes();
            if (items.size() == 0 && nodes.size() == 0) {
                return;
            }
            this.model.fireContainerCountLoading(items, nodes, node);
        } else {
            TreeImageDisplay root = this.view.getTreeRoot();
            List l = root.getChildrenDisplay();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.countItems(rootType, (TreeImageDisplay)i.next());
            }
        }
    }

    private void countItemsInAnnotation(TreeImageSet node) {
        if (node == null) {
            return;
        }
        Object ho = node.getUserObject();
        ArrayList<Class> types = new ArrayList<Class>();
        if (ho instanceof TagAnnotationData) {
            types.add(DatasetData.class);
        }
        if (types.size() == 0) {
            return;
        }
        ContainerFinder finder = new ContainerFinder(types);
        node.accept(finder, 1);
        Set<DataObject> items = finder.getContainers();
        Set<TreeImageSet> nodes = finder.getContainerNodes();
        if (items.size() == 0 && nodes.size() == 0) {
            return;
        }
        this.model.fireContainerCountLoading(items, nodes, node);
    }

    private void setSelectedDisplay(TreeImageDisplay display, boolean single) {
        switch (this.model.getState()) {
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
            }
        }
        this.hasDataToSave(display);
        TreeImageDisplay oldDisplay = this.model.getLastSelectedDisplay();
        TreeImageDisplay exp = null;
        Object ho = null;
        if (display != null && (ho = display.getUserObject()) instanceof ExperimenterData && this.getBrowserType() != 6) {
            exp = display;
            display = null;
        }
        if (exp != null) {
            this.model.setSelectedDisplay(exp, single);
        } else {
            this.model.setSelectedDisplay(display, single);
        }
        if (oldDisplay != null && oldDisplay.equals(display)) {
            ho = oldDisplay.getUserObject();
            if (ho instanceof PlateData || ho instanceof PlateAcquisitionData) {
                this.firePropertyChange("selectedTreeNodeDisplay", null, display);
            }
        } else {
            this.firePropertyChange("selectedTreeNodeDisplay", oldDisplay, display);
        }
    }

    BrowserComponent(BrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new BrowserControl(this);
        this.view = new BrowserUI();
    }

    void initialize(ExperimenterData exp) {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model, exp);
    }

    BrowserModel getModel() {
        return this.model;
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void activate() {
        int state = this.model.getState();
        block0 : switch (state) {
            case 10: {
                TreeImageDisplay p;
                if (this.model.getBrowserType() == 6) {
                    this.model.fireExperimenterDataLoading(null);
                    return;
                }
                switch (this.model.getDisplayMode()) {
                    case 0: {
                        TreeImageDisplay node = this.getDefaultGroupNode();
                        if (node == null) break block0;
                        this.view.expandNode(node, true);
                        break block0;
                    }
                }
                TreeImageDisplay node = this.getLoggedExperimenterNode();
                if (node == null) break;
                if (!this.model.isSingleGroup() && (p = node.getParentDisplay()) != null) {
                    p.setExpanded(true);
                }
                this.view.expandNode(node, true);
                break;
            }
            case 15: {
                this.refreshBrowser();
                break;
            }
            case 16: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    @Override
    public void discard() {
        if (this.model.getState() != 16) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    @Override
    public JComponent getUI() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view;
    }

    @Override
    public int getBrowserType() {
        return this.model.getBrowserType();
    }

    @Override
    public void cancel() {
        int state = this.model.getState();
        if (state == 11 || state == 12) {
            this.model.cancel();
            this.view.cancel(this.model.getLastSelectedDisplay());
            this.fireStateChange();
        }
    }

    public void loadFilteredImagesForHierarchy() {
        int state = this.model.getState();
        if (state == 16 || state == 12) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
        }
        if (this.model.getBrowserType() != 5) {
            throw new IllegalArgumentException("Method should only be invoked by the Images Explorer.");
        }
        this.view.loadAction(this.view.getTreeRoot());
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setLeaves(Collection leaves, TreeImageSet parent, TreeImageSet expNode) {
        if (this.model.getState() != 12) {
            return;
        }
        if (leaves == null || leaves.isEmpty()) {
            this.view.setLeavesViews(Collections.EMPTY_SET, parent);
            this.model.setState(15);
            this.fireStateChange();
            return;
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid");
        }
        if (this.model.getBrowserType() == 4) {
            this.model.getParentModel().setLeaves(parent, leaves);
            this.model.setState(15);
            this.fireStateChange();
            return;
        }
        Set<TreeImageDisplay> visLeaves = TreeViewerTranslator.transformHierarchy(leaves);
        this.view.setLeavesViews(visLeaves, parent);
        this.model.setState(15);
        if (parent != null && parent.getUserObject() instanceof TagAnnotationData) {
            this.countItemsInAnnotation(parent);
        }
        if (this.model.getBrowserType() == 2 && parent instanceof TreeFileSet) {
            ArrayList<Class> types = new ArrayList<Class>();
            types.add(TagAnnotationData.class);
            this.countItems(types, expNode);
        }
        Object p = null;
        if (parent != null && parent.getUserObject() instanceof PlateData) {
            p = parent.getUserObject();
        }
        if (!(p instanceof PlateData)) {
            this.model.getParentModel().setLeaves(parent, leaves);
        }
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public void setSelectedDisplay(TreeImageDisplay display) {
        this.setSelectedDisplay(display, true);
    }

    @Override
    public void showPopupMenu(int index) {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                return;
            }
        }
        switch (index) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Menu not supported: " + index);
            }
        }
        this.firePropertyChange("popupMenu", -1, index);
    }

    @Override
    public Point getClickPoint() {
        return this.model.getClickPoint();
    }

    @Override
    public TreeImageDisplay getLastSelectedDisplay() {
        return this.model.getLastSelectedDisplay();
    }

    @Override
    public void close() {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                throw new IllegalStateException("This method can only be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        this.firePropertyChange("close", null, this);
    }

    @Override
    public void collapse(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        this.view.collapsePath(node);
    }

    @Override
    public void expand(TreeImageDisplay node) {
        if (node == null) {
            return;
        }
        this.view.expandNode(node);
    }

    @Override
    public void accept(TreeImageDisplayVisitor visitor) {
        this.accept(visitor, 2);
    }

    @Override
    public void accept(TreeImageDisplayVisitor visitor, int algoType) {
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.getTreeRoot().accept(visitor, algoType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        if (visitor instanceof UpdateVisitor) {
            UpdateVisitor us = (UpdateVisitor)visitor;
            Collection<TreeImageDisplay> updated = us.getUpdated();
            if (CollectionUtils.isEmpty(updated)) {
                return;
            }
            Iterator<TreeImageDisplay> i = updated.iterator();
            TreeModel tm = this.view.getTreeDisplay().getModel();
            while (i.hasNext()) {
                TreeImageDisplay n = i.next();
                tm.valueForPathChanged(new TreePath(n.getPath()), n.getUserObject());
            }
        }
    }

    @Override
    public String getTitle() {
        return this.view.getBrowserTitle();
    }

    @Override
    public Icon getIcon() {
        IconManager im = IconManager.getInstance();
        switch (this.model.getBrowserType()) {
            case 0: {
                return im.getIcon(4);
            }
            case 2: {
                return im.getIcon(69);
            }
            case 5: {
                return im.getIcon(62);
            }
            case 1: {
                return im.getIcon(75);
            }
            case 3: {
                return im.getIcon(80);
            }
            case 4: {
                return im.getIcon(104);
            }
            case 6: {
                return im.getIcon(118);
            }
        }
        return null;
    }

    @Override
    public void sortTreeNodes(int sortType) {
        switch (this.model.getState()) {
            case 11: 
            case 12: 
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA,  LOADING_LEAVES or DISCARDED state.");
            }
        }
        switch (sortType) {
            case 300: 
            case 301: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SortType not supported.");
            }
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.sortNodes(sortType);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void setContainerCountValue(long containerID, long value, Set<TreeImageSet> nodes) {
        int state = this.model.getState();
        if (state == 16) {
            return;
        }
        boolean b = this.model.setContainerCountValue(this.view.getTreeDisplay(), containerID, value, nodes);
        if (b) {
            this.view.getTreeDisplay().repaint();
        }
        this.model.getParentModel().setStatus(false, "", true);
    }

    @Override
    public void setFoundInBrowser(Set nodes) {
        if (nodes == null || nodes.size() == 0) {
            this.model.setFoundNodes(null);
            this.model.setFoundNodeIndex(-1);
            this.view.getTreeDisplay().repaint();
            return;
        }
        ArrayList list = new ArrayList(nodes.size());
        Iterator i = nodes.iterator();
        final JTree tree = this.view.getTreeDisplay();
        while (i.hasNext()) {
            list.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                TreeImageDisplay node1 = (TreeImageDisplay)o1;
                TreeImageDisplay node2 = (TreeImageDisplay)o2;
                int i1 = tree.getRowForPath(new TreePath(node1.getPath()));
                int i2 = tree.getRowForPath(new TreePath(node2.getPath()));
                return i1 - i2;
            }
        };
        Collections.sort(list, c);
        this.model.setFoundNodes(list);
        this.model.setFoundNodeIndex(0);
        this.handleNodeDisplay((TreeImageDisplay)list.get(0));
        tree.repaint();
    }

    @Override
    public void findNext() {
        int n;
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index < (n = l.size() - 1)) {
            ++index;
        } else if (index == n) {
            index = 0;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    @Override
    public void findPrevious() {
        List l = this.model.getFoundNodes();
        if (l == null || l.size() == 0) {
            return;
        }
        int index = this.model.getFoundNodeIndex();
        if (index > 0) {
            --index;
        } else if (index == 0) {
            index = l.size() - 1;
        }
        this.model.setFoundNodeIndex(index);
        this.handleNodeDisplay((TreeImageDisplay)l.get(index));
    }

    @Override
    public void setSelected(boolean b) {
        switch (this.model.getState()) {
            case 16: {
                throw new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        boolean old = this.model.isSelected();
        if (old == b) {
            return;
        }
        this.model.setSelected(b);
    }

    @Override
    public void refreshEdition(DataObject object, DataObject parent, int op) {
        EditVisitor visitor;
        switch (this.model.getState()) {
            case 10: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalStateException("This method can only be invoked in the NEW or READY state.");
            }
        }
        Object o = object;
        List<TreeImageDisplay> nodes = null;
        TreeImageDisplay parentDisplay = null;
        TreeImageDisplay loggedUser = this.getLoggedExperimenterNode();
        if (op == 300) {
            TreeImageDisplay node = this.getLastSelectedDisplay();
            if (object instanceof ProjectData || object instanceof ScreenData || object instanceof DatasetData && parent == null || object instanceof TagAnnotationData && parent == null) {
                nodes = new ArrayList<TreeImageDisplay>(1);
                nodes.add(loggedUser);
                parentDisplay = loggedUser;
            } else if (parent != null) {
                o = node.getUserObject();
            }
        }
        if (nodes == null && parent == null) {
            visitor = new EditVisitor(this, o, null);
            loggedUser.accept(visitor, 2);
            nodes = visitor.getFoundNodes();
        }
        if (parent != null) {
            visitor = new EditVisitor(this, null, parent);
            loggedUser.accept(visitor, 2);
            nodes = visitor.getParentNodes();
        }
        if (op == 301) {
            this.view.updateNodes(nodes, object);
        } else if (op == 302) {
            this.removeNodes(nodes);
        } else if (op == 300) {
            if (parentDisplay == null) {
                parentDisplay = this.getLastSelectedDisplay();
            }
            TreeImageDisplay newNode = TreeViewerTranslator.transformDataObject(object);
            this.createNodes(nodes, newNode, parentDisplay);
        }
        this.setSelectedNode();
    }

    @Override
    public void onOrphanDataObjectCreated(DataObject data) {
        int type = this.model.getBrowserType();
        if (data instanceof DatasetData ? type != 0 : data instanceof TagAnnotationData && type != 2) {
            return;
        }
        TreeImageDisplay loggedUser = this.getLoggedExperimenterNode();
        ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>(1);
        nodes.add(loggedUser);
        this.createNodes(nodes, TreeViewerTranslator.transformDataObject(data), loggedUser);
        this.setSelectedNode();
    }

    @Override
    public TreeImageDisplay[] getSelectedDisplays() {
        return this.model.getSelectedDisplays();
    }

    @Override
    public List getSelectedDataObjects() {
        TreeImageDisplay[] nodes = this.getSelectedDisplays();
        ArrayList<DataObject> objects = new ArrayList<DataObject>();
        if (nodes == null || nodes.length == 0) {
            return objects;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Object uo = nodes[i].getUserObject();
            if (!(uo instanceof DataObject)) continue;
            objects.add((DataObject)uo);
        }
        return objects;
    }

    @Override
    public void setSelectedDisplays(TreeImageDisplay[] nodes, boolean expandParent) {
        if (nodes.length == 0) {
            return;
        }
        TreeImageDisplay[] oldNodes = this.model.getSelectedDisplays();
        boolean b = true;
        if (oldNodes != null && oldNodes.length > 1) {
            b = false;
        }
        if (nodes.length == 1 && b) {
            this.setSelectedDisplay(nodes[0], true);
            if (expandParent) {
                TreeImageDisplay parent = nodes[0].getParentDisplay();
                if (parent.getUserObject() instanceof ExperimenterData) {
                    parent = nodes[0];
                }
                this.view.expandNode(parent);
                this.view.setFoundNode(nodes);
            }
            return;
        }
        boolean flush = false;
        if (oldNodes.length >= nodes.length) {
            flush = true;
        }
        int n = nodes.length;
        TreeImageDisplay parent = null;
        for (int i = 0; i < n; ++i) {
            if (nodes[i] == null) continue;
            parent = nodes[i].getParentDisplay();
            if (parent != null && parent.getUserObject() instanceof ExperimenterData) {
                parent = nodes[i];
            }
            if (i == 0) {
                this.model.setSelectedDisplay(nodes[i], flush);
                continue;
            }
            this.model.setSelectedDisplay(nodes[i], false);
        }
        if (parent != null && expandParent) {
            this.view.setFoundNode(nodes);
            this.view.expandNode(parent);
        }
        this.firePropertyChange("selectedTreeNodeDisplay", null, nodes[n - 1]);
    }

    @Override
    public void onComponentStateChange(boolean b) {
        this.view.onComponentStateChange(b);
    }

    @Override
    public boolean isDisplayed() {
        return this.model.isDisplayed();
    }

    @Override
    public void setDisplayed(boolean displayed) {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.setDisplayed(displayed);
    }

    @Override
    public void setRefreshedHierarchy(Map nodes, Map expandedTopNodes) {
        if (this.model.getState() != 11) {
            throw new IllegalStateException("This method cannot be invoked in the LOADING_DATA state.");
        }
        this.countItems(null, null);
        this.model.getParentModel().setStatus(false, "", true);
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        this.fireStateChange();
    }

    @Override
    public void displaysImagesName() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v);
        this.view.repaint();
    }

    @Override
    public void loadExperimenterData(TreeImageDisplay exp, TreeImageDisplay n) {
        if (exp == null) {
            return;
        }
        Object uo = exp.getUserObject();
        if (!(uo instanceof ExperimenterData) && !(uo instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        switch (this.model.getState()) {
            case 12: 
            case 16: {
                return;
            }
        }
        if (n == null) {
            this.model.fireExperimenterDataLoading((TreeImageSet)exp);
        } else {
            n.setToRefresh(false);
            if (this.model.getBrowserType() == 4) {
                uo = n.getUserObject();
                TreeImageDisplay expNode = BrowserFactory.getDataOwner(n);
                if (expNode == null) {
                    return;
                }
                Object ho = expNode.getUserObject();
                if (!(ho instanceof ExperimenterData)) {
                    return;
                }
                if (uo instanceof FileData) {
                    FileData dir = (FileData)uo;
                    if (dir.isDirectory()) {
                        ArrayList<DataObject> list = new ArrayList<DataObject>();
                        if (n.isChildrenLoaded()) {
                            List children = n.getChildrenDisplay();
                            for (TreeImageDisplay d : children) {
                                Object o = d.getUserObject();
                                if (!(o instanceof DataObject)) continue;
                                list.add((DataObject)o);
                            }
                        } else {
                            long expID = ((ExperimenterData)ho).getId();
                            DataObject[] files = this.model.getFilesData(expID, dir);
                            if (files != null) {
                                for (int i = 0; i < files.length; ++i) {
                                    list.add(files[i]);
                                }
                            }
                        }
                        if (list.size() > 0) {
                            this.model.setState(12);
                            this.setLeaves(list, (TreeImageSet)n, (TreeImageSet)exp);
                        }
                    }
                    return;
                }
            } else {
                this.model.fireLeavesLoading(exp, n);
            }
        }
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setExperimenterData(TreeImageDisplay expNode, Collection nodes) {
        int state = this.model.getState();
        if (state != 11) {
            return;
        }
        if (nodes == null) {
            throw new NullPointerException("No nodes.");
        }
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object uo = expNode.getUserObject();
        if (!(uo instanceof ExperimenterData) && !(uo instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Set<TreeImageDisplay> convertedNodes = TreeViewerTranslator.transformHierarchy(nodes);
        this.view.setExperimenterData(convertedNodes, expNode);
        this.model.setState(15);
        this.countItems(null, expNode);
        this.countExperimenterDataInFolders();
        this.model.getParentModel().setStatus(false, "", true);
        switch (this.model.getBrowserType()) {
            case 0: 
            case 1: {
                ParentVisitor visitor = new ParentVisitor();
                this.accept(visitor, 1);
                EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
                bus.post(new ExperimenterLoadedDataEvent(visitor.getData()));
            }
        }
        this.fireStateChange();
    }

    @Override
    public void addExperimenter(ExperimenterData experimenter, long groupID) {
        if (experimenter == null) {
            throw new IllegalArgumentException("Experimenter cannot be null.");
        }
        if (this.model.getBrowserType() == 6) {
            return;
        }
        TreeImageDisplay node = this.model.getLastSelectedDisplay();
        boolean reload = false;
        if (this.model.isSingleGroup()) {
            node = this.view.getTreeRoot();
            reload = node.getChildCount() == 0;
        } else {
            ExperimenterVisitor v = new ExperimenterVisitor(this, groupID);
            this.accept(v, 1);
            List<TreeImageDisplay> list = v.getNodes();
            if (list.size() == 0) {
                return;
            }
            node = list.get(0);
        }
        ArrayList<TreeImageDisplay> nodes = new ArrayList<TreeImageDisplay>(1);
        nodes.add(new TreeImageSet(experimenter));
        SimilarNodesVisitor visitor = new SimilarNodesVisitor(nodes);
        node.accept(visitor, 1);
        if (visitor.getFoundNodes().size() > 0) {
            return;
        }
        this.setSelectedDisplay(null);
        this.view.addExperimenter(experimenter, node);
        if (reload) {
            this.view.reloadNode(node);
        }
    }

    @Override
    public void removeExperimenter(ExperimenterData exp, long groupID) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter cannot be null.");
        }
        TreeImageDisplay node = null;
        if (groupID >= 0L) {
            ExperimenterVisitor v = new ExperimenterVisitor(this, groupID);
            this.accept(v);
            List<TreeImageDisplay> nodes = v.getNodes();
            if (nodes.size() == 1) {
                node = nodes.get(0);
            }
        }
        this.view.removeExperimenter(exp, node);
    }

    @Override
    public void refreshExperimenterData() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        RefreshVisitor v = new RefreshVisitor(this);
        if (this.model.getBrowserType() == 6) {
            TreeImageDisplay display = this.view.getTreeRoot();
            display.accept(v, 1);
            RefreshExperimenterDef def = new RefreshExperimenterDef((TreeImageSet)display, v.getFoundNodes(), v.getExpandedTopNodes());
            HashMap<SecurityContext, RefreshExperimenterDef> m = new HashMap<SecurityContext, RefreshExperimenterDef>(1);
            SecurityContext ctx = TreeViewerAgent.getAdminContext();
            if (ctx == null) {
                ctx = this.model.getSecurityContext(null);
            }
            m.put(ctx, def);
            this.model.loadRefreshExperimenterData(m, null, -1L, null, null);
            this.fireStateChange();
        } else {
            TreeImageDisplay display = this.model.getLastSelectedDisplay();
            if (display == null) {
                return;
            }
            Object ho = display.getUserObject();
            if (!(ho instanceof ExperimenterData)) {
                return;
            }
            this.refreshExperimenterData(Arrays.asList(display.getUserObjectId()));
        }
    }

    @Override
    public TreeImageDisplay getLoggedExperimenterNode() {
        SecurityContext ctx = this.model.getSecurityContext(null);
        long id = ctx.getGroupID();
        if (this.model.isSingleGroup()) {
            id = -1L;
        }
        ExperimenterVisitor visitor = new ExperimenterVisitor((Browser)this, this.model.getUserID(), id);
        this.accept(visitor, 1);
        List<TreeImageDisplay> nodes = visitor.getNodes();
        if (nodes.size() != 1) {
            return null;
        }
        return nodes.get(0);
    }

    @Override
    public void refreshLoggedExperimenterData() {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        TreeImageDisplay node = this.getLoggedExperimenterNode();
        if (node == null) {
            return;
        }
        Object ho = node.getUserObject();
        if (!(ho instanceof ExperimenterData)) {
            return;
        }
        this.refreshExperimenterData(Arrays.asList(node.getUserObjectId()));
        this.fireStateChange();
    }

    @Override
    public void refreshTree(Object refNode, DataObject toBrowse) {
        switch (this.model.getState()) {
            case 11: 
            case 12: {
                this.model.cancel();
                break;
            }
            case 16: {
                return;
            }
        }
        if (this.model.getBrowserType() == 4) {
            return;
        }
        if (this.model.getBrowserType() == 6) {
            this.refreshExperimenterData();
            return;
        }
        this.addComponent(null);
        TreeImageDisplay root = this.view.getTreeRoot();
        int n = root.getChildCount();
        HashMap<SecurityContext, RefreshExperimenterDef> m = new HashMap<SecurityContext, RefreshExperimenterDef>(n);
        int type = this.model.getBrowserType();
        switch (this.model.getDisplayMode()) {
            case 1: {
                int i;
                if (this.model.isSingleGroup()) {
                    long gid = this.model.getUserDetails().getDefaultGroup().getId();
                    for (i = 0; i < n; ++i) {
                        TreeImageSet expNode = (TreeImageSet)root.getChildAt(i);
                        if (expNode.isExpanded() && expNode.isChildrenLoaded()) {
                            RefreshVisitor v = new RefreshVisitor(this);
                            expNode.accept(v);
                            if (type == 5) {
                                this.countExperimenterImages(expNode);
                            }
                            RefreshExperimenterDef def = new RefreshExperimenterDef(expNode, v.getFoundNodes(), v.getExpandedTopNodes());
                            SecurityContext ctx = new SecurityContext(gid);
                            if (this.model.getDisplayMode() == 1) {
                                ctx.setExperimenter((ExperimenterData)expNode.getUserObject());
                            }
                            m.put(ctx, def);
                            continue;
                        }
                        expNode.setChildrenLoaded(Boolean.FALSE);
                    }
                } else {
                    for (i = 0; i < n; ++i) {
                        TreeImageSet groupNode = (TreeImageSet)root.getChildAt(i);
                        if (!groupNode.isExpanded()) continue;
                        RefreshVisitor v = new RefreshVisitor(this);
                        long gid = groupNode.getUserObjectId();
                        List children = groupNode.getChildrenDisplay();
                        for (TreeImageSet expNode : children) {
                            if (expNode.isChildrenLoaded() && expNode.isExpanded()) {
                                v = new RefreshVisitor(this);
                                expNode.accept(v);
                                if (type == 5) {
                                    this.countExperimenterImages(expNode);
                                }
                                RefreshExperimenterDef def = new RefreshExperimenterDef(expNode, v.getFoundNodes(), v.getExpandedTopNodes());
                                SecurityContext ctx = new SecurityContext(gid);
                                ctx.setExperimenter((ExperimenterData)expNode.getUserObject());
                                m.put(ctx, def);
                                continue;
                            }
                            expNode.setChildrenLoaded(Boolean.FALSE);
                        }
                    }
                }
                break;
            }
            case 0: {
                int i;
                for (i = 0; i < n; ++i) {
                    TreeImageSet groupNode = (TreeImageSet)root.getChildAt(i);
                    if (groupNode.isExpanded() && groupNode.isChildrenLoaded()) {
                        RefreshVisitor v = new RefreshVisitor(this);
                        groupNode.accept(v);
                        long gid = groupNode.getUserObjectId();
                        if (type == 5) {
                            this.countExperimenterImages(groupNode);
                        }
                        RefreshExperimenterDef def = new RefreshExperimenterDef(groupNode, v.getFoundNodes(), v.getExpandedTopNodes());
                        m.put(new SecurityContext(gid), def);
                        continue;
                    }
                    groupNode.setChildrenLoaded(Boolean.FALSE);
                }
                break;
            }
        }
        if (m.size() == 0) {
            TreeImageDisplay node = null;
            switch (this.model.getDisplayMode()) {
                case 0: {
                    node = this.getDefaultGroupNode();
                }
            }
            node = this.getLoggedExperimenterNode();
            if (node != null) {
                this.loadExperimenterData(node, null);
            }
            return;
        }
        this.model.loadRefreshExperimenterData(m, null, -1L, refNode, toBrowse);
        this.fireStateChange();
    }

    @Override
    public void setRefreshExperimenterData(Map<SecurityContext, RefreshExperimenterDef> nodes, Class type, long id) {
        NodesFinder finder;
        TreeImageSet expNode;
        RefreshExperimenterDef node;
        Map.Entry<SecurityContext, RefreshExperimenterDef> entry;
        if (nodes == null || nodes.size() == 0) {
            this.model.setSelectedDisplay(null, true);
            this.model.setState(15);
            this.countItems(null, null);
            if (this.model.getBrowserType() == 2) {
                this.countExperimenterDataInFolders();
            }
            this.model.getParentModel().setStatus(false, "", true);
            return;
        }
        Iterator<Map.Entry<SecurityContext, RefreshExperimenterDef>> i = nodes.entrySet().iterator();
        int browserType = this.model.getBrowserType();
        while (i.hasNext()) {
            entry = i.next();
            node = entry.getValue();
            expNode = node.getExperimenterNode();
            if (browserType == 5 || browserType == 3) {
                Map<Integer, Set> results = TreeViewerTranslator.refreshFolderHierarchy((Map)node.getResults());
                this.view.refreshFolder(expNode, results);
                continue;
            }
            Set convertedNodes = TreeViewerTranslator.refreshHierarchy((Map)node.getResults(), node.getExpandedTopNodes());
            this.view.setExperimenterData(convertedNodes, expNode);
        }
        i = nodes.entrySet().iterator();
        if (type == null) {
            while (i.hasNext()) {
                boolean b;
                entry = i.next();
                node = entry.getValue();
                expNode = node.getExperimenterNode();
                if (!expNode.isExpanded()) continue;
                Map m = node.getExpandedTopNodes();
                List expandedNodes = node.getExpandedNodes();
                boolean bl = b = expandedNodes.size() == 0;
                if (this.model.getBrowserType() == 2) {
                    boolean bl2 = b = expandedNodes.size() > 0;
                }
                if (m == null || m.size() <= 0 || !b) continue;
                for (Map.Entry e : m.entrySet()) {
                    finder = new NodesFinder((Class)e.getKey(), (List)e.getValue());
                    this.accept(finder);
                    Set<TreeImageDisplay> found = finder.getNodes();
                    if (found.size() <= 0) continue;
                    for (TreeImageDisplay n : found) {
                        List ll;
                        if (n.isExpanded()) {
                            this.view.expandNode(n);
                        }
                        if (!(n.getUserObject() instanceof ProjectData) || CollectionUtils.isEmpty((Collection)(ll = n.getChildrenDisplay()))) continue;
                        for (TreeImageDisplay c : ll) {
                            if (!c.isExpanded()) continue;
                            this.view.expandNode(c);
                        }
                    }
                }
            }
        }
        this.model.setSelectedDisplay(null, true);
        this.model.setState(15);
        switch (this.model.getBrowserType()) {
            case 2: {
                ArrayList<Class> types = new ArrayList<Class>();
                types.add(TagAnnotationData.class);
                types.add(DatasetData.class);
                this.countItems(types, null);
                this.countExperimenterDataInFolders();
                break;
            }
            case 6: {
                this.countItems(null, null);
                break;
            }
            default: {
                TreeImageDisplay root = this.view.getTreeRoot();
                for (int k = 0; k < root.getChildCount(); ++k) {
                    TreeImageSet groupNode = (TreeImageSet)root.getChildAt(k);
                    if (!groupNode.isExpanded()) continue;
                    this.countItems(null, groupNode);
                }
            }
        }
        this.model.getParentModel().setStatus(false, "", true);
        PartialNameVisitor v = new PartialNameVisitor(this.view.isPartialName());
        this.accept(v, 0);
        if (ProjectData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || ScreenData.class.equals((Object)type)) {
            finder = new NodesFinder(type, id);
            this.accept(finder);
            Set<TreeImageDisplay> found = finder.getNodes();
            if (found.size() > 0) {
                Iterator<TreeImageDisplay> n = found.iterator();
                if (DatasetData.class.equals((Object)type)) {
                    while (n.hasNext()) {
                        TreeImageDisplay display = n.next();
                        this.setSelectedDisplay(display);
                        this.view.expandNode(display, true);
                    }
                } else {
                    while (n.hasNext()) {
                        this.setSelectedDisplay(n.next());
                    }
                }
            }
        }
        switch (this.model.getBrowserType()) {
            case 0: 
            case 1: {
                ParentVisitor visitor = new ParentVisitor();
                this.accept(visitor, 1);
                EventBus bus = TreeViewerAgent.getRegistry().getEventBus();
                bus.post(new ExperimenterLoadedDataEvent(visitor.getData()));
            }
        }
        this.fireStateChange();
    }

    @Override
    public void countExperimenterImages(TreeImageDisplay expNode) {
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        switch (this.model.getState()) {
            case 12: 
            case 16: {
                throw new IllegalStateException("This method cannot be invoked in the DISCARDED orLOADING_LEAVES state.");
            }
        }
        int browserType = this.model.getBrowserType();
        if (browserType != 5 && browserType != 3 && browserType != 2) {
            return;
        }
        this.model.fireCountExperimenterImages((TreeImageSet)expNode);
        this.model.getParentModel().setStatus(true, "Loading Data...", false);
        this.fireStateChange();
    }

    @Override
    public void setExperimenterCount(TreeImageSet expNode, int index, Object v) {
        if (expNode == null) {
            throw new IllegalArgumentException("Node not valid.");
        }
        Object ho = expNode.getUserObject();
        if (!(ho instanceof ExperimenterData) && !(ho instanceof GroupData)) {
            throw new IllegalArgumentException("Node not valid.");
        }
        int browserType = this.model.getBrowserType();
        if (browserType != 5 && browserType != 3 && browserType != 2) {
            return;
        }
        boolean b = this.model.setExperimenterCount(expNode, index);
        if (index != -1 && v != null) {
            this.view.setCountValues(expNode, index, v);
        }
        if (b) {
            this.view.getTreeDisplay().repaint();
        }
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public ExperimenterData getNodeOwner(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        TreeImageDisplay n = BrowserFactory.getDataOwner(node);
        if (n == null) {
            return this.model.getUserDetails();
        }
        return (ExperimenterData)n.getUserObject();
    }

    @Override
    public GroupData getNodeGroup(TreeImageDisplay node) {
        if (node == null) {
            throw new IllegalArgumentException("No node specified.");
        }
        TreeImageDisplay n = EditorUtil.getDataGroup(node);
        if (n == null) {
            return this.model.getUserDetails().getDefaultGroup();
        }
        return (GroupData)n.getUserObject();
    }

    @Override
    public SecurityContext getSecurityContext(TreeImageDisplay node) {
        return this.model.getSecurityContext(node);
    }

    @Override
    public JComponent getClickComponent() {
        if (this.model.getState() == 16) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.view.getTreeDisplay();
    }

    @Override
    public void setSelectedNode() {
        if (this.toSelectAfterSave == null) {
            return;
        }
        this.setSelectedDisplay(this.toSelectAfterSave);
        this.toSelectAfterSave = null;
    }

    @Override
    public void refreshAdmin(Object data) {
        block9: {
            ExperimenterVisitor v;
            if (this.model.getState() == 16) {
                return;
            }
            if (this.model.getBrowserType() == 6 && this.model.isSelected()) {
                TreeImageDisplay node = this.model.getLastSelectedDisplay();
                this.refreshBrowser();
                this.setSelectedDisplay(node, true);
                return;
            }
            if (!(data instanceof ExperimenterData) && !(data instanceof GroupData)) break block9;
            GroupData g = null;
            if (data instanceof ExperimenterData) {
                ExperimenterData exp = (ExperimenterData)data;
                v = new ExperimenterVisitor((Browser)this, exp.getId(), -1L);
            } else {
                g = (GroupData)data;
                v = new ExperimenterVisitor(this, g.getId());
            }
            this.accept(v, 1);
            List l = v.getNodes();
            Iterator<TreeImageDisplay> i = l.iterator();
            if (data instanceof ExperimenterData) {
                while (i.hasNext()) {
                    TreeImageDisplay n = i.next();
                    n.setUserObject(this.model.getUserDetails());
                    this.view.reloadNode(n);
                }
            } else {
                while (i.hasNext()) {
                    TreeImageDisplay n = i.next();
                    n.setUserObject(g);
                    this.view.reloadNode(n);
                    l = n.getChildrenDisplay();
                    i = l.iterator();
                    while (i.hasNext()) {
                        n = i.next();
                        if (!n.isExpanded()) continue;
                        this.view.expandNode(n);
                    }
                }
            }
        }
    }

    @Override
    public void browse(TreeImageDisplay node, DataObject data, boolean withThumbnails) {
        this.model.getParentModel().browse(node, data, withThumbnails);
    }

    private boolean isWellSampleDataSelection(Object selected) {
        List l;
        if (selected == null) {
            return false;
        }
        if (selected instanceof WellSampleData) {
            return true;
        }
        return selected instanceof List && !(l = (List)selected).isEmpty() && l.iterator().next() instanceof WellSampleData;
    }

    @Override
    public void onSelectedNode(Object parent, Object selected, Boolean multiSelection) {
        if (this.isWellSampleDataSelection(selected)) {
            return;
        }
        if (selected instanceof DataObject) {
            NodeSelectionVisitor visitor = new NodeSelectionVisitor(parent, (DataObject)selected);
            this.accept(visitor);
            TreeImageDisplay foundNode = visitor.getSelectedNode();
            if (foundNode != null) {
                if (multiSelection.booleanValue()) {
                    this.model.addFoundNode(foundNode);
                } else {
                    this.model.setSelectedDisplay(foundNode, true);
                }
                this.view.setFoundNode(this.model.getSelectedDisplays());
            } else {
                this.view.setFoundNode(null);
            }
        } else if (selected instanceof TreeImageDisplay) {
            TreeImageDisplay foundNode = (TreeImageDisplay)selected;
            if (multiSelection.booleanValue()) {
                this.model.addFoundNode(foundNode);
            } else {
                this.model.setSelectedDisplay(foundNode, true);
            }
            this.view.setFoundNode(this.model.getSelectedDisplays());
        } else if (selected instanceof List) {
            NodeSelectionVisitor visitor = new NodeSelectionVisitor(parent, (List)selected);
            this.accept(visitor);
            List<TreeImageDisplay> nodes = visitor.getSelectedNodes();
            if (nodes.size() == 0) {
                this.view.setFoundNode(null);
            } else if (nodes.size() == 1) {
                this.model.setSelectedDisplay(nodes.get(0), true);
                this.view.setFoundNode(this.model.getSelectedDisplays());
            } else {
                this.model.setSelectedDisplay(null, true);
                Iterator<TreeImageDisplay> i = nodes.iterator();
                while (i.hasNext()) {
                    this.model.addFoundNode(i.next());
                }
                this.view.setFoundNode(this.model.getSelectedDisplays());
            }
        } else if (selected instanceof String) {
            this.model.setSelectedDisplay(null, true);
            this.view.setFoundNode(null);
        }
    }

    @Override
    public void onDeselectedNode(Object parent, Object selected, Boolean multiSelection) {
        if (selected instanceof DataObject) {
            NodeSelectionVisitor visitor = new NodeSelectionVisitor(parent, (DataObject)selected);
            this.accept(visitor);
            TreeImageDisplay foundNode = visitor.getSelectedNode();
            if (foundNode != null) {
                this.model.removeDisplay(foundNode);
                this.view.setFoundNode(this.model.getSelectedDisplays());
            } else {
                this.view.setFoundNode(null);
            }
        }
    }

    @Override
    public void setTimeIntervalImages(Set set, TreeImageTimeSet node) {
        this.model.getParentModel().browseTimeInterval(node, set);
    }

    @Override
    public void onImportFinished(List<TreeImageDisplay> nodes) {
        if (this.model.getState() == 16) {
            return;
        }
        if (nodes == null) {
            return;
        }
        switch (this.model.getBrowserType()) {
            case 0: {
                SimilarNodesVisitor v = new SimilarNodesVisitor(nodes);
                this.accept(v, 1);
                nodes = v.getFoundNodes();
                for (TreeImageDisplay n : nodes) {
                    Object ho = n.getUserObject();
                    if (!(ho instanceof DatasetData)) continue;
                    this.view.reloadContainer(n);
                }
                break;
            }
        }
    }

    @Override
    public void setImportedFile(ImageData image) {
        if (this.model.getState() == 16) {
            return;
        }
        if (image == null) {
            return;
        }
        this.model.addImportedImage(image);
    }

    @Override
    public boolean isFileImported(String path) {
        if (this.model.getState() == 16) {
            return false;
        }
        return this.model.isFileImported(path);
    }

    @Override
    public void deleteObjects(List nodes) {
        this.model.getParentModel().deleteObjects(nodes);
    }

    @Override
    public void showMenu(int index, Component invoker, Point loc) {
        this.model.getParentModel().showMenu(index, invoker, loc);
    }

    @Override
    public void refreshBrowser() {
        this.model.getParentModel().refreshTree();
    }

    @Override
    public void removeTreeNodes(Collection<TreeImageDisplay> nodes) {
        if (nodes == null) {
            return;
        }
        for (TreeImageDisplay node : nodes) {
            TreeImageDisplay parent = node.getParentDisplay();
            if (parent == null) continue;
            parent.removeChildDisplay(node);
            node.removeFromParent();
            this.view.reloadNode(parent);
        }
        HashSet oldSelected = Sets.newHashSet((Object[])this.getSelectedDisplays());
        HashSet newSelected = Sets.newHashSet((Iterable)oldSelected);
        newSelected.removeAll(nodes);
        if (!newSelected.equals(oldSelected)) {
            this.setSelectedDisplay(null);
            this.setSelectedDisplays(newSelected.toArray(new TreeImageDisplay[newSelected.size()]), false);
        }
    }

    @Override
    public void reActivate() {
        this.model.setSelectedDisplay(null, true);
        this.view.reActivate();
        if (this.model.isSelected() && this.model.getBrowserType() == 6) {
            this.model.setState(10);
            this.activate();
        }
    }

    @Override
    public void setRepositories(TreeImageDisplay expNode, FSFileSystemView systemView) {
        int state = this.model.getState();
        if (state != 11) {
            throw new IllegalStateException("This method can only be invoked in the LOADING_DATA state.");
        }
        if (this.model.getBrowserType() != 4) {
            return;
        }
        if (systemView == null) {
            throw new NullPointerException("No File System.");
        }
        if (expNode == null) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        Object uo = expNode.getUserObject();
        if (!(uo instanceof ExperimenterData)) {
            throw new IllegalArgumentException("Experimenter node not valid.");
        }
        this.model.setRepositories(systemView);
        this.view.loadFileSystem(expNode);
        this.countItems(null, expNode);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public void setGroups(Collection groups, List expanded) {
        int state = this.model.getState();
        if (state != 11) {
            return;
        }
        if (this.model.getBrowserType() != 6) {
            return;
        }
        Set nodes = TreeViewerTranslator.transformGroups(groups);
        this.view.setGroups(nodes, expanded);
        this.model.setState(15);
        this.countItems(null, null);
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public boolean register(DataObject file) {
        if (file == null) {
            throw new IllegalArgumentException("No file to register.");
        }
        if (this.model.getBrowserType() != 4) {
            return false;
        }
        if (!(file instanceof FileData) && !(file instanceof ImageData)) {
            return false;
        }
        if (file.getId() > 0L) {
            return false;
        }
        try {
            DataObject o;
            ImageData img;
            TreeImageDisplay d = this.model.getLastSelectedDisplay();
            TreeImageDisplay exp = BrowserFactory.getDataOwner(d);
            if (exp == null) {
                return false;
            }
            Object ho = exp.getUserObject();
            if (!(ho instanceof ExperimenterData)) {
                return false;
            }
            long id = ((ExperimenterData)ho).getId();
            if (file instanceof ImageData && (img = (ImageData)file).getIndex() >= 0) {
                TreeImageDisplay pd = d.getParentDisplay();
                if (pd == null) {
                    return false;
                }
                file = (DataObject)pd.getUserObject();
            }
            if ((o = this.model.getRepositories(id).register(file)) == null) {
                return false;
            }
        }
        catch (FSAccessException e) {
            LogMessage msg = new LogMessage();
            msg.print("Cannot register the object.");
            msg.print((Throwable)e);
            TreeViewerAgent.getRegistry().getLogger().error((Object)this, msg);
            return false;
        }
        this.view.repaint();
        return true;
    }

    @Override
    public void setExperimenters(TreeImageSet node, List result) {
        if (result.size() != 1) {
            return;
        }
        Object ho = result.get(0);
        node.setUserObject(ho);
        GroupData g = (GroupData)ho;
        Set nodes = TreeViewerTranslator.transformExperimenters(g.getExperimenters());
        this.view.setLeavesViews(nodes, node);
        this.model.setState(15);
        this.model.getParentModel().setLeaves(node, g.getExperimenters());
        this.model.getParentModel().setStatus(false, "", true);
        this.fireStateChange();
    }

    @Override
    public boolean canEdit(Object ho) {
        return this.model.getParentModel().canEdit(ho);
    }

    @Override
    public boolean canAnnotate(Object ho) {
        return this.model.getParentModel().canAnnotate(ho);
    }

    @Override
    public void expandUser() {
        if (this.model.getState() == 16) {
            return;
        }
        SecurityContext ctx = this.model.getSecurityContext(this.model.getLastSelectedDisplay());
        long id = this.model.getUserID();
        ExperimenterVisitor v = new ExperimenterVisitor((Browser)this, id, ctx.getGroupID());
        this.accept(v, 1);
        List<TreeImageDisplay> values = v.getNodes();
        if (values.size() != 1) {
            return;
        }
        TreeImageDisplay n = values.get(0);
        if (!n.isExpanded()) {
            this.view.expandNode(n);
        }
    }

    @Override
    public void resetPassword(String value) {
        if (this.model.getState() == 16) {
            return;
        }
        this.model.getParentModel().resetPassword(value);
    }

    @Override
    public void refreshBrowser(Class type, long id) {
        if (ProjectData.class.equals((Object)type) || DatasetData.class.equals((Object)type) || ScreenData.class.equals((Object)type)) {
            ExperimenterVisitor visitor = new ExperimenterVisitor((Browser)this, -1L, -1L);
            this.accept(visitor, 1);
            List<TreeImageDisplay> nodes = visitor.getNodes();
            if (nodes.size() == 0) {
                return;
            }
            Iterator<TreeImageDisplay> i = nodes.iterator();
            ArrayList<Long> ids = new ArrayList<Long>(nodes.size());
            while (i.hasNext()) {
                ids.add(i.next().getUserObjectId());
            }
            this.refreshExperimenterData(ids);
        }
    }

    @Override
    public void addComponent(JComponent component) {
        if (this.getBrowserType() != 1) {
            return;
        }
        this.view.addComponent(component);
    }

    @Override
    public void loadDirectory(TreeImageDisplay display) {
        if (display == null) {
            return;
        }
        Object ho = display.getUserObject();
        if (!(ho instanceof FileData)) {
            return;
        }
        FileData f = (FileData)ho;
        if (f.isDirectory() && !display.isChildrenLoaded()) {
            this.view.loadFile(display);
        }
    }

    @Override
    public List<TreeImageDisplay> getNodesForUser(long userID, TreeImageDisplay node) {
        if (this.model.getState() == 16) {
            return null;
        }
        if (userID < 0L) {
            return null;
        }
        SecurityContext context = this.model.getSecurityContext(node);
        ExperimenterVisitor v = new ExperimenterVisitor((Browser)this, userID, context.getGroupID());
        this.accept(v, 1);
        List<TreeImageDisplay> nodes = v.getNodes();
        if (nodes.size() != 1) {
            return new ArrayList<TreeImageDisplay>();
        }
        TreeImageDisplay n = nodes.get(0);
        return n.getChildrenDisplay();
    }

    @Override
    public void rejectTransfer() {
        JTree tree = this.view.getTreeDisplay();
        if (tree instanceof DnDTree) {
            ((DnDTree)tree).reset();
        }
    }

    @Override
    public void setUserGroup(GroupData group) {
        if (group == null) {
            throw new IllegalArgumentException("Group cannot be null.");
        }
        this.view.setUserGroup(Arrays.asList(group));
    }

    @Override
    public void removeGroup(GroupData group) {
        if (group == null) {
            return;
        }
        this.view.removeGroup(group);
    }

    @Override
    public boolean canLink(Object ho) {
        return this.model.getParentModel().canLink(ho);
    }

    @Override
    public List<DataObject> getDataToCopy() {
        return this.model.getParentModel().getDataToCopy();
    }

    @Override
    public void paste(TreeImageDisplay[] parents) {
        this.model.getParentModel().paste(parents);
    }

    @Override
    public void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        this.model.getParentModel().setNodesToCopy(nodes, index);
    }

    @Override
    public TreeImageDisplay getDefaultGroupNode() {
        SecurityContext ctx = this.model.getSecurityContext(null);
        long id = ctx.getGroupID();
        ExperimenterVisitor visitor = new ExperimenterVisitor(this, id);
        this.accept(visitor, 1);
        List<TreeImageDisplay> nodes = visitor.getNodes();
        if (nodes.size() != 1) {
            return null;
        }
        return nodes.get(0);
    }

    @Override
    public int getDisplayMode() {
        return this.model.getDisplayMode();
    }

    @Override
    public void changeDisplayMode() {
        if (this.model.getBrowserType() == 6) {
            return;
        }
        this.model.setSelectedDisplay(null, true);
        ExperimenterVisitor v = new ExperimenterVisitor(this, -1L);
        this.accept(v, 1);
        List<TreeImageDisplay> nodes = v.getNodes();
        this.view.clear();
        ArrayList<GroupData> groups = new ArrayList<GroupData>(nodes.size());
        Iterator<TreeImageDisplay> i = nodes.iterator();
        while (i.hasNext()) {
            groups.add((GroupData)i.next().getUserObject());
        }
        if (this.model.isSingleGroup()) {
            this.view.reActivate();
        } else {
            this.view.setUserGroup(groups);
        }
    }
}

