/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.GroupSelectionAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.RunScriptAction;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ExperimenterVisitor;
import org.openmicroscopy.shoola.agents.treeviewer.util.DataMenuItem;
import org.openmicroscopy.shoola.agents.treeviewer.util.GroupItem;
import org.openmicroscopy.shoola.agents.treeviewer.view.ManagePopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.SearchEvent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerWin;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.ui.ScriptMenuItem;
import org.openmicroscopy.shoola.env.data.model.ScriptObject;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.util.ui.FancyTextField;
import org.openmicroscopy.shoola.util.ui.ScrollablePopupMenu;
import org.openmicroscopy.shoola.util.ui.SelectableMenu;
import org.openmicroscopy.shoola.util.ui.SelectableMenuItem;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ToolBar
extends JPanel {
    private static final String IMPORTED_TEXT = " Imported";
    private static final String FAILED_TEXT = " Failed";
    private static final String IMPORT_TOOLTIP = "Indicates on-going imports";
    private static final Dimension HBOX = new Dimension(100, 16);
    private static final String GROUP_DISPLAY_TEXT = "Display Groups";
    private static final int SEARCHFIELD_WIDTH = 12;
    private static final String SEARCHFIELD_TEXT = "Search ...";
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private TreeViewerWin view;
    private JPopupMenu personalMenu;
    private JToggleButton fullScreen;
    private JPopupMenu scriptsMenu;
    private JButton scriptButton;
    private JXBusyLabel busyLabel;
    private int index;
    private JToolBar bar;
    private JButton menuButton;
    private ViewerSorter sorter;
    private JPopupMenu popupMenu;
    private JLabel importSuccessLabel;
    private JLabel importFailureLabel;
    private JXBusyLabel importLabel;
    private JTextField searchField;

    private void handleSelectionDisplay(boolean userDisplay) {
        int n = this.popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.popupMenu.getComponent(i);
            if (!(c instanceof GroupItem)) continue;
            GroupItem item = (GroupItem)c;
            item.setDisplay(userDisplay);
        }
        int mode = 1;
        if (!userDisplay) {
            mode = 0;
        }
        this.controller.setDisplayMode(mode);
    }

    private void handleAllGroupsSelection(boolean select) {
        int n = this.popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            GroupItem item;
            Component c = this.popupMenu.getComponent(i);
            if (!(c instanceof GroupItem) || (item = (GroupItem)c).getGroup() == null) continue;
            item.setMenuSelected(select, false);
            if (!select) continue;
            item.selectUsers(false, true);
        }
        this.handleSelection();
    }

    private void handleAllUsersSelection(boolean select) {
        int n = this.popupMenu.getComponentCount();
        for (int i = 0; i < n; ++i) {
            GroupItem item;
            Component c = this.popupMenu.getComponent(i);
            if (!(c instanceof GroupItem) || (item = (GroupItem)c).getGroup() == null) continue;
            item.setMenuSelected(true, false);
            item.selectUsers(true, select);
        }
        this.handleSelection();
    }

    private void handleSelection() {
        int n = this.popupMenu.getComponentCount();
        int count = 0;
        int total = 0;
        SelectableMenu allGroups = null;
        for (int i = 0; i < n; ++i) {
            Component c = this.popupMenu.getComponent(i);
            if (!(c instanceof GroupItem)) continue;
            GroupItem item = (GroupItem)c;
            if (item.getGroup() != null) {
                ++total;
                boolean b = !item.isMenuSelected();
                List<ExperimenterData> users = item.getSeletectedUsers();
                if (n == 1) {
                    if (b) {
                        users = new ArrayList<ExperimenterData>();
                    }
                    b = false;
                }
                if (!b) {
                    ++count;
                }
                this.controller.setSelection(item.getGroup(), users, b);
                continue;
            }
            if (!GroupItem.ALL_GROUPS.equals(item.getText())) continue;
            allGroups = item;
        }
        if (allGroups != null) {
            allGroups.setMenuSelected(total == count, false);
        }
    }

    private void search() {
        TreeViewerAgent.getRegistry().getEventBus().post(new SearchEvent(this.searchField.getText()));
    }

    private JPanel formatHeader(String text) {
        JPanel title = new JPanel();
        title.setLayout(new FlowLayout(0));
        title.add(UIUtilities.setTextFont(text));
        title.setBackground(UIUtilities.BACKGROUND_COLOUR_EVEN);
        return title;
    }

    private boolean createGroupMenu(GroupItem groupItem, int size) {
        DataMenuItem item;
        int level;
        long loggedUserID = this.model.getUserDetails().getId();
        GroupData group = groupItem.getGroup();
        Browser browser = this.model.getBrowser(0);
        TreeImageDisplay refNode = null;
        ArrayList<Long> users = new ArrayList<Long>();
        if (group != null && size > 0) {
            ExperimenterVisitor visitor = new ExperimenterVisitor(browser, group.getId());
            browser.accept(visitor);
            List<TreeImageDisplay> nodes = visitor.getNodes();
            if (nodes.size() == 1) {
                refNode = nodes.get(0);
            }
            visitor = new ExperimenterVisitor(browser, -1L, -1L);
            if (refNode != null) {
                refNode.accept(visitor);
            } else if (size == 1) {
                browser.accept(visitor);
            }
            nodes = visitor.getNodes();
            if (CollectionUtils.isNotEmpty(nodes)) {
                for (TreeImageDisplay n : nodes) {
                    if (!(n.getUserObject() instanceof ExperimenterData)) continue;
                    users.add(((ExperimenterData)n.getUserObject()).getId());
                }
                if (size == 1) {
                    groupItem.setMenuSelected(true, false);
                }
            }
        }
        ArrayList<DataMenuItem> items = new ArrayList<DataMenuItem>();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        List l = null;
        if (group != null) {
            l = this.sorter.sort(group.getLeaders());
        }
        boolean view = true;
        if (group != null && (level = group.getPermissions().getPermissionsLevel()) == 0) {
            view = this.model.isAdministrator() || this.model.isGroupOwner(group);
        }
        ArrayList<DataMenuItem> list = new ArrayList<DataMenuItem>();
        String v = (String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.everyone.label");
        if (v == null || v.trim().length() == 0) {
            v = DataMenuItem.ALL_USERS_TEXT;
        }
        Boolean enabled = Boolean.parseBoolean((String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.everyone.enabled"));
        boolean b = false;
        if (enabled != null) {
            b = enabled;
        }
        DataMenuItem allUser = new DataMenuItem((Object)v, b);
        allUser.setRefString(DataMenuItem.ALL_USERS_TEXT);
        allUser.addPropertyChangeListener(groupItem);
        items.add(allUser);
        if (view) {
            p.add(allUser);
        }
        int count = 0;
        int total = 0;
        enabled = Boolean.parseBoolean((String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.leaders.enabled"));
        b = false;
        if (enabled != null) {
            b = enabled;
        }
        if (CollectionUtils.isNotEmpty((Collection)l) && b) {
            total += l.size();
            for (ExperimenterData exp : l) {
                if (!view && exp.getId() != loggedUserID) continue;
                if (exp.getId() == loggedUserID) {
                    b = true;
                }
                item = new DataMenuItem((Object)exp, b);
                item.setChecked(users.contains(exp.getId()));
                if (item.isChecked()) {
                    ++count;
                }
                item.addPropertyChangeListener(groupItem);
                items.add(item);
                list.add(item);
            }
            if (list.size() > 0) {
                v = (String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.leaders.label");
                if (v == null || v.trim().length() == 0) {
                    v = "Group owners";
                }
                p.add(this.formatHeader(v));
                for (DataMenuItem dmi : list) {
                    p.add(dmi);
                }
                list.clear();
            }
        }
        if (group != null) {
            l = this.sorter.sort(group.getMembersOnly());
        }
        enabled = Boolean.parseBoolean((String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.colleagues.enabled"));
        b = false;
        if (enabled != null) {
            b = enabled;
        }
        if (CollectionUtils.isNotEmpty((Collection)l) && b) {
            total += l.size();
            for (ExperimenterData exp : l) {
                if (!view && exp.getId() != loggedUserID) continue;
                if (exp.getId() == loggedUserID) {
                    b = true;
                }
                item = new DataMenuItem((Object)exp, b);
                item.setChecked(users.contains(exp.getId()));
                if (item.isChecked()) {
                    ++count;
                }
                item.addPropertyChangeListener(groupItem);
                items.add(item);
                list.add(item);
            }
            if (list.size() > 0) {
                v = (String)TreeViewerAgent.getRegistry().lookup("omero.client.ui.menu.dropdown.colleagues.label");
                if (v == null || v.trim().length() == 0) {
                    v = "Members";
                }
                p.add(this.formatHeader(v));
                for (DataMenuItem dmi : list) {
                    p.add(dmi);
                }
            }
        }
        allUser.setChecked(total != 0 && total == count);
        allUser.addPropertyChangeListener(groupItem);
        JScrollPane pane = new JScrollPane(p);
        Dimension d = p.getPreferredSize();
        int max = 500;
        if (d.height > max) {
            Insets insets = pane.getInsets();
            pane.setPreferredSize(new Dimension(d.width + insets.left + insets.right + 20, max));
        }
        groupItem.add(pane);
        groupItem.setUsersItem(items);
        groupItem.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (GroupItem.USER_SELECTION_PROPERTY.equals(name)) {
                    ToolBar.this.handleSelection();
                } else if (GroupItem.ALL_GROUPS_SELECTION_PROPERTY.equals(name)) {
                    ToolBar.this.handleAllGroupsSelection(true);
                } else if (GroupItem.ALL_GROUPS_DESELECTION_PROPERTY.equals(name)) {
                    ToolBar.this.handleAllGroupsSelection(false);
                } else if (GroupItem.ALL_USERS_SELECTION_PROPERTY.equals(name)) {
                    ToolBar.this.handleAllUsersSelection((Boolean)evt.getNewValue());
                }
            }
        });
        return groupItem.isMenuSelected();
    }

    private void createGroupsAndUsersMenu(Component source, Point p) {
        GroupItem item;
        if (!source.isEnabled()) {
            return;
        }
        Collection groups = this.model.getGroups();
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return;
        }
        this.popupMenu.removeAll();
        List sortedGroups = this.sorter.sort(groups);
        Browser browser = this.model.getBrowser(0);
        ExperimenterVisitor visitor = new ExperimenterVisitor(browser, -1L);
        browser.accept(visitor);
        List<TreeImageDisplay> nodes = visitor.getNodes();
        Iterator<TreeImageDisplay> k = nodes.iterator();
        ArrayList<Long> groupIds = new ArrayList<Long>();
        while (k.hasNext()) {
            long id = k.next().getUserObjectId();
            if (id < 0L) continue;
            groupIds.add(id);
        }
        Iterator i = sortedGroups.iterator();
        int size = sortedGroups.size();
        long userID = this.model.getExperimenter().getId();
        final SelectableMenuItem data = new SelectableMenuItem(this.model.getDisplayMode() == 1, DataMenuItem.USERS_TEXT, true);
        data.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (SelectableMenuItem.SELECTION_PROPERTY.equals(name)) {
                    ToolBar.this.handleSelectionDisplay(data.isChecked());
                }
            }
        });
        this.popupMenu.add(data);
        this.popupMenu.add(new JSeparator());
        SelectableMenu allGroup = null;
        if (size > 1) {
            item = new GroupItem(false);
            item.setUserID(userID);
            this.createGroupMenu(item, 0);
            this.popupMenu.add(item);
            this.popupMenu.add(new JSeparator());
            allGroup = item;
        }
        int count = 0;
        while (i.hasNext()) {
            GroupData group = (GroupData)i.next();
            boolean b = groupIds.contains(group.getId());
            item = new GroupItem(group, b, size > 1);
            item.setUserID(userID);
            boolean selected = this.createGroupMenu(item, size);
            this.popupMenu.add(item);
            if (!selected) continue;
            ++count;
        }
        if (allGroup != null) {
            allGroup.setMenuSelected(count == sortedGroups.size(), false);
        }
        this.popupMenu.show(source, p.x, p.y);
    }

    private void initMenuItem(JMenuItem item) {
        item.setBorder(null);
        item.setFont((Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Labels"));
    }

    private JComponent createManagementBar() {
        this.bar = new JToolBar();
        this.bar.setFloatable(false);
        this.bar.setRollover(true);
        this.bar.setBorder(null);
        JToggleButton button = new JToggleButton(this.controller.getAction(TreeViewerControl.INSPECTOR));
        button.setSelected(true);
        this.bar.add(button);
        button = new JToggleButton(this.controller.getAction(TreeViewerControl.METADATA));
        button.setSelected(true);
        this.bar.add(button);
        JButton b = new JButton(this.controller.getAction(TreeViewerControl.BROWSE));
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.bar.add(b);
        boolean ij = false;
        switch (TreeViewerAgent.runAsPlugin()) {
            case 1: 
            case 3: {
                ij = true;
                b = UIUtilities.formatButtonFromAction(this.controller.getAction(TreeViewerControl.VIEW));
                UIUtilities.unifiedButtonLookAndFeel(b);
                b.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        ToolBar.this.controller.showMenu(9, (JComponent)e.getSource(), e.getPoint());
                    }
                });
                this.bar.add(b);
                break;
            }
            default: {
                b = new JButton(this.controller.getAction(TreeViewerControl.VIEW));
                UIUtilities.unifiedButtonLookAndFeel(b);
                this.bar.add(b);
            }
        }
        this.bar.add(b);
        this.bar.add(new JSeparator(1));
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        List<JComponent> l = tb.getToolBarEntries(201);
        if (l != null) {
            for (JComponent comp : l) {
                UIUtilities.unifiedButtonLookAndFeel(comp);
                this.bar.add(comp);
            }
            this.bar.add(new JSeparator(1));
        }
        this.fullScreen = new JToggleButton(this.controller.getAction(TreeViewerControl.FULLSCREEN));
        this.fullScreen.setSelected(this.model.isFullScreen());
        if (TreeViewerAgent.isUploadScript()) {
            b = new JButton(this.controller.getAction(TreeViewerControl.UPLOAD_SCRIPT));
            UIUtilities.unifiedButtonLookAndFeel(b);
            this.bar.add(b);
        }
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.AVAILABLE_SCRIPTS);
        b = new JButton(a);
        Icon icon = b.getIcon();
        Dimension d = new Dimension(16, 16);
        if (icon != null) {
            d = new Dimension(icon.getIconWidth(), icon.getIconHeight());
        }
        this.busyLabel = new JXBusyLabel(d);
        this.busyLabel.setVisible(true);
        b.addMouseListener((RunScriptAction)a);
        UIUtilities.unifiedButtonLookAndFeel(b);
        this.scriptButton = b;
        this.bar.add(b);
        this.index = this.bar.getComponentCount() - 1;
        this.bar.add(new JSeparator(1));
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ToolBar.this.createGroupsAndUsersMenu((Component)me.getSource(), me.getPoint());
            }
        };
        a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
        IconManager icons = IconManager.getInstance();
        this.menuButton = new JButton(icons.getIcon(17));
        this.menuButton.setVisible(true);
        this.menuButton.setText(GROUP_DISPLAY_TEXT);
        this.menuButton.setHorizontalTextPosition(2);
        this.menuButton.addMouseListener(adapter);
        this.bar.add(this.menuButton);
        this.setPermissions();
        if (ij) {
            a = this.controller.getAction(TreeViewerControl.SAVE_TO_OMERO);
            b = new JButton(a);
            this.bar.add(Box.createHorizontalStrut(5));
            this.bar.add(b);
        }
        return this.bar;
    }

    private JToolBar createSearchBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(true);
        bar.setBorder(null);
        bar.add(new JSeparator(1));
        bar.add(new JToggleButton(this.controller.getAction(TreeViewerControl.SEARCH)));
        return bar;
    }

    private void buildGUI() {
        JPanel bars = new JPanel();
        JPanel outerPanel = new JPanel();
        bars.setBorder(null);
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.createManagementBar());
        if (!"JXTaskPane".equals(this.view.getLayoutType())) {
            bars.add(this.createSearchBar());
        }
        outerPanel.setBorder(null);
        outerPanel.setLayout(new BoxLayout(outerPanel, 0));
        outerPanel.add(bars);
        outerPanel.add(Box.createRigidArea(HBOX));
        outerPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 0));
        this.add(UIUtilities.buildComponentPanel(outerPanel));
        this.add(UIUtilities.buildComponentPanelRight(this.buildRightPane()));
    }

    private JPanel buildRightPane() {
        JPanel p = new JPanel();
        p.setBorder(null);
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.searchField);
        p.add(Box.createHorizontalStrut(50));
        p.add(this.importFailureLabel);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.importSuccessLabel);
        p.add(Box.createHorizontalStrut(5));
        p.add((Component)this.importLabel);
        return p;
    }

    private void formatLabel(JLabel label) {
        label.setHorizontalTextPosition(10);
        label.setAlignmentX(4.0f);
        label.setVisible(false);
    }

    private void initialize() {
        IconManager icons = IconManager.getInstance();
        this.importFailureLabel = new JLabel(icons.getIcon(26));
        this.formatLabel(this.importFailureLabel);
        this.importSuccessLabel = new JLabel(icons.getIcon(185));
        this.formatLabel(this.importSuccessLabel);
        Dimension d = new Dimension(16, 16);
        this.importLabel = new JXBusyLabel(d);
        this.importLabel.setToolTipText(IMPORT_TOOLTIP);
        this.importLabel.setVisible(false);
        this.importLabel.setBusy(false);
        this.sorter = new ViewerSorter();
        this.sorter.setCaseSensitive(true);
        this.popupMenu = new ScrollablePopupMenu();
        this.searchField = new FancyTextField(SEARCHFIELD_TEXT, 12);
        this.searchField.addPropertyChangeListener("SUBMIT_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ToolBar.this.search();
            }
        });
    }

    ToolBar(TreeViewerControl controller, TreeViewerModel model, TreeViewerWin view) {
        if (controller == null) {
            throw new NullPointerException("No Controller.");
        }
        if (model == null) {
            throw new NullPointerException("No Model.");
        }
        if (view == null) {
            throw new NullPointerException("No View.");
        }
        this.model = model;
        this.controller = controller;
        this.view = view;
        this.initialize();
        this.buildGUI();
    }

    void showManagementMenu(Component c, Point p) {
        if (p == null) {
            return;
        }
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        ManagePopupMenu managePopupMenu = new ManagePopupMenu(this.controller);
        managePopupMenu.show(c, p.x, p.y);
    }

    void showPersonalMenu(Component c, Point p) {
        if (p == null) {
            return;
        }
        if (c == null) {
            throw new IllegalArgumentException("No component.");
        }
        this.personalMenu = new JPopupMenu();
        this.personalMenu.setBorder(BorderFactory.createBevelBorder(0));
        List<JMenuItem> l = this.createMenuItem(false);
        Iterator<JMenuItem> i = l.iterator();
        while (i.hasNext()) {
            this.personalMenu.add(i.next());
        }
        this.personalMenu.show(c, p.x, p.y);
    }

    private List<JMenuItem> createMenuItem(boolean add) {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        List<GroupSelectionAction> l = this.controller.getUserGroupAction(add);
        Iterator<GroupSelectionAction> i = l.iterator();
        if (add) {
            Browser browser = this.model.getSelectedBrowser();
            ArrayList<Long> ids = new ArrayList<Long>();
            if (browser != null) {
                ExperimenterVisitor v = new ExperimenterVisitor(browser, -1L);
                browser.accept(v, 1);
                List<TreeImageDisplay> nodes = v.getNodes();
                for (TreeImageDisplay node : nodes) {
                    ids.add(((GroupData)node.getUserObject()).getId());
                }
            }
            while (i.hasNext()) {
                GroupSelectionAction a = i.next();
                JMenuItem item = new JMenuItem(a);
                if (ids.size() > 0) {
                    item.setEnabled(!ids.contains(a.getGroupId()));
                } else {
                    item.setEnabled(true);
                }
                this.initMenuItem(item);
                items.add(item);
            }
        } else {
            ButtonGroup buttonGroup = new ButtonGroup();
            long id = this.model.getSelectedGroupId();
            while (i.hasNext()) {
                GroupSelectionAction a = i.next();
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
                item.setEnabled(true);
                item.setSelected(a.isSameGroup(id));
                this.initMenuItem(item);
                buttonGroup.add(item);
                items.add(item);
            }
        }
        return items;
    }

    void showAvailableScriptsMenu(Component c, Point p) {
        if (p == null) {
            p = new Point(0, 0);
        }
        if (c == null || !((Component)c).isShowing()) {
            c = this.scriptButton.isShowing() ? this.scriptButton : (this.busyLabel.isShowing() ? this.busyLabel : this.bar);
        }
        IconManager icons = IconManager.getInstance();
        Collection<ScriptObject> scripts = this.model.getAvailableScripts();
        if (CollectionUtils.isEmpty(scripts)) {
            return;
        }
        if (this.scriptsMenu == null) {
            String[] values;
            String sep;
            String path;
            String value;
            this.scriptsMenu = new JPopupMenu();
            JMenuItem refresh = new JMenuItem(icons.getIcon(10));
            refresh.setText("Reload Scripts");
            refresh.setToolTipText("Reloads the existing scripts.");
            refresh.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ToolBar.this.model.setAvailableScripts(null);
                    ToolBar.this.scriptsMenu = null;
                    Point p = e.getPoint();
                    if (e.getSource() != ToolBar.this.scriptButton) {
                        p = null;
                    }
                    ToolBar.this.controller.reloadAvailableScripts(p, (Component)e.getSource());
                }
            });
            this.scriptsMenu.add(refresh);
            this.scriptsMenu.add(new JSeparator());
            HashMap<Object, JMenu> menus = new HashMap<Object, JMenu>();
            ImageIcon icon = icons.getIcon(158);
            ImageIcon largeIcon = icons.getIcon(159);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScriptMenuItem item = (ScriptMenuItem)e.getSource();
                    ToolBar.this.controller.handleScriptSelection(item.getScript());
                }
            };
            Object name = "";
            String refString = null;
            int count = 0;
            for (ScriptObject so : scripts) {
                value = "";
                path = so.getPath();
                if (path != null && path.length() > 1) {
                    sep = FilenameUtils.getPrefix((String)path);
                    if (path.startsWith(sep)) {
                        path = path.substring(1, path.length());
                    }
                    if ((values = UIUtilities.splitString(path)) != null && values.length > 0) {
                        value = values[0];
                    }
                }
                if (refString == null) {
                    refString = value;
                    ++count;
                    continue;
                }
                if (!refString.equals(value)) continue;
                ++count;
            }
            int index = 0;
            if (scripts.size() == count) {
                ++index;
            }
            Iterator<ScriptObject> i = scripts.iterator();
            ArrayList<JMenuItem> topMenus = new ArrayList<JMenuItem>();
            JMenu ref = null;
            while (i.hasNext()) {
                ScriptObject so;
                so = i.next();
                path = so.getPath();
                if (path != null) {
                    sep = FilenameUtils.getPrefix((String)path);
                    if (path.startsWith(sep)) {
                        path = path.substring(1, path.length());
                    }
                    if ((values = UIUtilities.splitString(path)) != null) {
                        for (int j = index; j < values.length; ++j) {
                            JMenu v;
                            value = values[j];
                            String text = (String)name + value;
                            if (menus.containsKey(text)) {
                                v = (JMenu)menus.get(text);
                            } else {
                                value = value.replace("_", " ");
                                v = new JMenu(value);
                            }
                            if (ref == null) {
                                topMenus.add(v);
                            } else {
                                ref.add(v);
                            }
                            ref = v;
                            name = (String)name + values[j];
                            menus.put(name, v);
                        }
                    }
                }
                ScriptMenuItem item = new ScriptMenuItem(so);
                item.addActionListener(listener);
                if (ref != null) {
                    ref.add(item);
                } else {
                    topMenus.add(item);
                }
                name = "";
                ref = null;
                if (so.getIcon() != null) continue;
                so.setIcon(icon);
                so.setIconLarge(largeIcon);
            }
            Iterator j = topMenus.iterator();
            while (j.hasNext()) {
                this.scriptsMenu.add((JMenuItem)j.next());
            }
        }
        this.scriptsMenu.show((Component)c, p.x, p.y);
    }

    void showCreateMenu(Component c, Point p, int index) {
        if (c == null) {
            return;
        }
        if (p == null) {
            return;
        }
        PopupMenu menu = new PopupMenu(this.controller, this.model, index);
        menu.show(c, p.x, p.y);
    }

    void setFullScreenSelected(boolean selected) {
        this.fullScreen.setSelected(selected);
    }

    void setScriptsLoadingStatus(boolean loading) {
        SwingUtilities.invokeLater(() -> {
            this.bar.remove(this.index);
            this.busyLabel.setBusy(loading);
            if (loading) {
                this.bar.add((Component)this.busyLabel, this.index);
            } else {
                this.bar.add((Component)this.scriptButton, this.index);
            }
            this.validate();
            this.repaint();
        });
    }

    void setPermissions() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser != null && browser.getBrowserType() == 6) {
            this.menuButton.setEnabled(false);
            return;
        }
        this.menuButton.setEnabled(true);
    }

    void onImport() {
        SwingUtilities.invokeLater(() -> {
            StringBuffer buffer;
            this.importFailureLabel.setText("");
            this.importFailureLabel.setVisible(false);
            this.importSuccessLabel.setText("");
            this.importSuccessLabel.setVisible(false);
            this.importLabel.setBusy(this.model.isImporting());
            this.importLabel.setVisible(this.model.isImporting());
            int n = this.model.getImportFailureCount();
            if (n > 0) {
                buffer = new StringBuffer();
                buffer.append(n);
                buffer.append(FAILED_TEXT);
                this.importFailureLabel.setText(buffer.toString());
                this.importFailureLabel.setVisible(true);
            }
            if ((n = this.model.getImportSuccessCount()) > 0) {
                buffer = new StringBuffer();
                buffer.append(n);
                buffer.append(IMPORTED_TEXT);
                this.importSuccessLabel.setText(buffer.toString());
                this.importSuccessLabel.setVisible(true);
            }
            this.repaint();
        });
    }

    void clearMenus() {
        this.scriptsMenu = null;
    }
}

