/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import loci.formats.FormatException;
import loci.formats.UnsupportedCompressionException;
import ome.conditions.ResourceError;
import omero.ChecksumValidationException;

public class ImportException
extends Exception {
    public static final String FILE_NOT_VALID_TEXT = "File Not Valid";
    public static final String UNKNOWN_FORMAT_TEXT = "Unknown format";
    public static final String MISSING_LIBRARY_TEXT = "Missing library to decode the file.";
    private static final String NETWORK_NAME_TEXT = "The specified network name is no longer available";
    private static final String SPACE_TEXT = "No space left on device";
    public static int COMPRESSION = 0;
    public static int MISSING_LIBRARY = 1;
    public static int FILE_ON_TAPE = 2;
    public static int NO_SPACE = 3;
    public static int CHECKSUM_MISMATCH = 4;
    public static int NOT_VALID = 5;
    public static int UNKNOWN_FORMAT = 6;
    private int status;

    public static String getImportFailureMessage(Throwable t) {
        Throwable cause = t.getCause();
        if (cause instanceof FormatException) {
            String message = cause.getMessage();
            cause.printStackTrace();
            if (message == null) {
                return null;
            }
            if (message.contains("ome-xml.jar")) {
                return "Missing ome-xml.jar required to read OME-TIFF files";
            }
            String[] s = message.split(":");
            if (s.length > 0) {
                return s[0];
            }
        } else if (!(cause instanceof IOException) && cause instanceof ChecksumValidationException) {
            return ((ChecksumValidationException)cause).getMessage();
        }
        return null;
    }

    public ImportException(String message) {
        this(message, null);
        if (FILE_NOT_VALID_TEXT.equals(message)) {
            this.status = NOT_VALID;
        } else if (UNKNOWN_FORMAT_TEXT.equals(message)) {
            this.status = UNKNOWN_FORMAT;
        } else if (MISSING_LIBRARY_TEXT.equals(message)) {
            this.status = MISSING_LIBRARY;
        }
    }

    public ImportException(Throwable cause) {
        this(ImportException.getImportFailureMessage(cause), cause);
    }

    public ImportException(String message, Throwable cause) {
        super(message, cause);
        this.status = FILE_NOT_VALID_TEXT.equals(message) ? NOT_VALID : (UNKNOWN_FORMAT_TEXT.equals(message) ? UNKNOWN_FORMAT : (MISSING_LIBRARY_TEXT.equals(message) ? MISSING_LIBRARY : -1));
    }

    public int getStatus() {
        Throwable cause = this.getCause();
        if (cause == null) {
            return this.status;
        }
        if (cause instanceof UnsupportedCompressionException) {
            return COMPRESSION;
        }
        if (cause instanceof FormatException) {
            String message = cause.getMessage();
            if (message != null && message.contains(MISSING_LIBRARY_TEXT.toLowerCase())) {
                return MISSING_LIBRARY;
            }
        } else if (cause instanceof IOException) {
            String message = cause.getMessage();
            if (message != null && message.contains(NETWORK_NAME_TEXT)) {
                return FILE_ON_TAPE;
            }
        } else if (cause.getCause() instanceof IOException) {
            String message = cause.getCause().getMessage();
            if (message != null && message.contains(NETWORK_NAME_TEXT)) {
                return FILE_ON_TAPE;
            }
        } else if (cause instanceof ResourceError) {
            String message = cause.getMessage();
            if (message != null && message.contains(SPACE_TEXT)) {
                return NO_SPACE;
            }
        } else if (cause instanceof ChecksumValidationException) {
            return CHECKSUM_MISMATCH;
        }
        return this.status;
    }

    @Override
    public String toString() {
        Throwable cause = this.getCause();
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            cause.printStackTrace(pw);
            return sw.toString();
        }
        return super.toString();
    }
}

