/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.data.OmeroMetadataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.svc.SvcRegistry;
import org.openmicroscopy.shoola.svc.communicator.Communicator;
import org.openmicroscopy.shoola.svc.communicator.CommunicatorDescriptor;
import org.openmicroscopy.shoola.util.file.IOUtil;
import org.openmicroscopy.shoola.util.file.ImportErrorObject;
import org.openmicroscopy.shoola.util.ui.FileTableNode;
import org.openmicroscopy.shoola.util.ui.MessengerDetails;

public class FileUploader
extends BatchCallTree {
    private MessengerDetails details;
    private Object uploadedFile;
    private String tokenURL;
    private String processURL;
    private String appName;
    private int timeout;
    private String version;

    private void uploadFile(ImportErrorObject object) {
        try {
            CommunicatorDescriptor desc = new CommunicatorDescriptor(1, this.tokenURL, -1);
            Communicator c = SvcRegistry.getCommunicator(desc);
            StringBuilder token = new StringBuilder();
            Exception e = object.getException();
            String es = "";
            if (e != null) {
                es = e.toString();
            }
            if (this.details.isExceptionOnly()) {
                c.submitError("", this.details.getEmail(), this.details.getComment(), this.details.getExtra(), es, this.appName, this.version, token);
            } else {
                File f = object.getFile();
                String[] usedFiles = null;
                if (f != null) {
                    usedFiles = object.getUsedFiles();
                }
                long id = object.getLogFileID();
                OmeroMetadataService svc = this.context.getMetadataService();
                SecurityContext ctx = new SecurityContext(object.getSecurityContext());
                File directory = null;
                boolean b = false;
                if (usedFiles != null && f != null) {
                    if (usedFiles.length > 1) {
                        b = true;
                    }
                    if (usedFiles.length == 1) {
                        boolean bl = b = !f.getAbsolutePath().equals(usedFiles[0]);
                    }
                }
                if (b || id > 0L) {
                    directory = Files.createTempDirectory("ome_", new FileAttribute[0]).toFile();
                    if (f != null) {
                        directory = new File(directory.getParentFile(), FilenameUtils.removeExtension((String)f.getName()));
                        FileUtils.copyFileToDirectory((File)f, (File)directory, (boolean)true);
                    }
                    if (f != null) {
                        usedFiles = object.getUsedFiles();
                    }
                    if (usedFiles != null) {
                        for (int i = 0; i < usedFiles.length; ++i) {
                            FileUtils.copyFileToDirectory((File)new File(usedFiles[i]), (File)directory, (boolean)true);
                        }
                    }
                    if (id > 0L) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("importLog_");
                        buf.append(id);
                        buf.append(".log");
                        File log = new File(directory, buf.toString());
                        try {
                            svc.downloadFile(ctx, log, id);
                        }
                        catch (Exception ex) {
                            LogMessage msg = new LogMessage();
                            msg.print("Loading of Import log");
                            msg.print((Throwable)e);
                            this.context.getLogger().error((Object)this, msg);
                        }
                    }
                    f = IOUtil.zipDirectory(directory, false);
                }
                c.submitFilesError("", this.details.getEmail(), this.details.getComment(), this.details.getExtra(), es, this.appName, this.version, null, null, token);
                desc = new CommunicatorDescriptor(1, this.processURL, this.timeout);
                c = SvcRegistry.getCommunicator(desc);
                c.submitFile(token.toString(), f, object.getReaderType(), new StringBuilder());
                if (directory != null) {
                    FileUtils.deleteDirectory((File)directory);
                    f.delete();
                }
            }
            this.uploadedFile = object;
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print("Submit to QA");
            msg.print((Throwable)e);
            this.context.getLogger().error((Object)this, msg);
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.uploadedFile;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    @Override
    protected void buildTree() {
        List l = (List)this.details.getObjectToSubmit();
        String description = "Uploading files to QA system.";
        for (FileTableNode node : l) {
            node.setStatus(true);
            final ImportErrorObject f = node.getFailure();
            this.add(new BatchCall(description){

                @Override
                public void doCall() {
                    FileUploader.this.uploadFile(f);
                }
            });
        }
    }

    public FileUploader(MessengerDetails details) {
        if (details == null) {
            throw new IllegalArgumentException("No files to submit.");
        }
        this.details = details;
        this.tokenURL = (String)this.context.lookup("/services/DEBUGGER/hostnameToken");
        this.processURL = (String)this.context.lookup("/services/DEBUGGER/hostnameProcessing");
        this.appName = (String)this.context.lookup("/services/DEBUGGER/applicationNameBug");
        this.timeout = (Integer)this.context.lookup("/services/DEBUGGER/postTimeout");
        Object v = this.context.lookup("Version");
        this.version = "";
        if (v != null && v instanceof String) {
            this.version = (String)v;
        }
    }
}

