/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.ArrayList;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.OpenActivityParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.OpenObjectLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OpenObjectActivity
extends ActivityComponent {
    private static final String DESCRIPTION_STARTING = "Opening in ";
    private static final String DESCRIPTION_CREATED = "Object ready to be opened";
    private static final String DESCRIPTION_CANCEL = "Opening cancelled";
    private OpenActivityParam parameters;

    public OpenObjectActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, OpenActivityParam parameters) {
        super(viewer, registry, ctx);
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        this.parameters = parameters;
        this.initialize(DESCRIPTION_STARTING + parameters.getLabel(), parameters.getIcon());
    }

    @Override
    protected UserNotifierLoader createLoader() {
        Boolean value = (Boolean)this.registry.lookup("/services/OpenWith/Original");
        boolean originalImage = false;
        if (value != null) {
            originalImage = value;
        }
        this.loader = new OpenObjectLoader(this.viewer, this.registry, this.ctx, this.parameters.getObject(), this.parameters.getFolderPath(), originalImage, this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        String name;
        File f = (File)this.result;
        String path = f.getAbsolutePath();
        ApplicationData data = this.parameters.getApplication();
        if (data != null && (name = data.getApplicationName()) != null && ((name = name.toLowerCase()).contains("fiji") || name.contains("imagej"))) {
            path = null;
            ArrayList<String> args = new ArrayList<String>();
            args.add("-eval");
            args.add("run('Bio-Formats Importer','open=[" + UIUtilities.replaceWindowsPathSeparator(f.getAbsolutePath()) + "]')");
            data.setCommandLineArguments(args);
        }
        this.viewer.openApplication(this.parameters.getApplication(), path);
        this.type.setText(DESCRIPTION_CREATED);
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

