/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi;

import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import omero.gateway.model.FolderData;
import omero.gateway.model.ImageData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ShapeSettingsData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.enums.UnitsLength;
import org.jhotdraw.draw.ArrowTip;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.exception.NoSuchROIException;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.openmicroscopy.shoola.util.roi.exception.ROICreationException;
import org.openmicroscopy.shoola.util.roi.figures.MeasureArrowFigure;
import org.openmicroscopy.shoola.util.roi.figures.MeasureLineFigure;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.io.ServerROIStrategy;
import org.openmicroscopy.shoola.util.roi.io.XMLFileIOStrategy;
import org.openmicroscopy.shoola.util.roi.model.ROI;
import org.openmicroscopy.shoola.util.roi.model.ROICollection;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationship;
import org.openmicroscopy.shoola.util.roi.model.ROIShapeRelationshipList;
import org.openmicroscopy.shoola.util.roi.model.ShapeList;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;
import org.openmicroscopy.shoola.util.roi.model.util.MeasurementUnits;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;

public class ROIComponent
extends Component {
    public static final int ANNOTATE = 0;
    public static final int DELETE = 1;
    public static final int DELETE_MINE = 2;
    public static final int DELETE_OTHERS = 3;
    public static final int ALL = 4;
    public static final int EDIT = 5;
    private ROICollection roiCollection = new ROICollection();
    private XMLFileIOStrategy ioStrategy;
    private ServerROIStrategy serverStrategy;
    private MeasurementUnits units = new MeasurementUnits((Length)new LengthI(1.0, UnitsLength.PIXEL), (Length)new LengthI(1.0, UnitsLength.PIXEL), (Length)new LengthI(1.0, UnitsLength.PIXEL));
    private Map<Long, List<ROI>> roiResult = new LinkedHashMap<Long, List<ROI>>();

    private void setFigureAttributes(ROIFigure fig) {
        AttributeKeys.FONT_SIZE.set((Figure)fig, (Object)new Double(12.0));
        AttributeKeys.TEXT_COLOR.set((Figure)fig, (Object)ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        AttributeKeys.STROKE_WIDTH.set((Figure)fig, (Object)1.0);
        MeasurementAttributes.SHOWID.set((Figure)fig, (Object)false);
        MeasurementAttributes.SHOWMEASUREMENT.set((Figure)fig, (Object)(fig instanceof MeasureLineFigure));
        MeasurementAttributes.MEASUREMENTTEXT_COLOUR.set((Figure)fig, (Object)ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        DrawingAttributes.SHOWTEXT.set((Figure)fig, (Object)false);
        AttributeKeys.FILL_COLOR.set((Figure)fig, (Object)ShapeSettingsData.DEFAULT_FILL_COLOUR);
        AttributeKeys.STROKE_COLOR.set((Figure)fig, (Object)ShapeSettingsData.DEFAULT_STROKE_COLOUR);
        MeasurementAttributes.START_DECORATION.set((Figure)fig, null);
        MeasurementAttributes.END_DECORATION.set((Figure)fig, (Object)(fig instanceof MeasureArrowFigure ? new ArrowTip() : null));
    }

    private void setShapeAnnotations(ROIShape shape) {
    }

    public void reset() {
        if (this.ioStrategy != null) {
            this.ioStrategy.reset();
        }
    }

    void removeROI(ROIFigure figure) throws NoSuchROIException {
        if (figure == null) {
            return;
        }
        long id = figure.getROI().getID();
        Coord3D coord = figure.getROIShape().getCoord3D();
        this.deleteShape(id, coord);
    }

    ROI createROI(ROIFigure figure, Coord3D currentPlane) throws ROICreationException, NoSuchROIException {
        ROI roi = this.createROI();
        ROIShape newShape = new ROIShape(roi, currentPlane, figure, figure.getBounds());
        this.addShape(roi.getID(), currentPlane, newShape);
        return roi;
    }

    public void setPixelSizes(Length x, Length y, Length z) {
        this.units.setPixelSizes(x, y, z);
    }

    public ROI addROI(ROIFigure figure, Coord3D currentPlane, boolean addAttribs) throws ROICreationException, NoSuchROIException {
        if (figure == null) {
            throw new NullPointerException("Figure param null.");
        }
        figure.setMeasurementUnits(this.units);
        if (addAttribs) {
            this.setFigureAttributes(figure);
        }
        ROI roi = null;
        roi = this.createROI(figure, currentPlane);
        if (roi == null) {
            throw new ROICreationException("Unable to create ROI.");
        }
        ROIShape shape = figure.getROIShape();
        this.setShapeAnnotations(shape);
        return roi;
    }

    public void saveROI(OutputStream output) throws ParsingException {
        if (output == null) {
            throw new NullPointerException("No input stream specified.");
        }
        if (this.ioStrategy == null) {
            this.ioStrategy = new XMLFileIOStrategy();
        }
        this.ioStrategy.write(output, this);
    }

    public List<ROIData> saveROI(ImageData image, int index, long userID) throws Exception {
        if (this.serverStrategy == null) {
            this.serverStrategy = new ServerROIStrategy();
        }
        return this.serverStrategy.write(this, image, index, userID);
    }

    public List<ROI> loadROI(InputStream input) throws NoSuchROIException, ParsingException, ROICreationException {
        if (input == null) {
            throw new NullPointerException("No input stream specified.");
        }
        if (this.ioStrategy == null) {
            this.ioStrategy = new XMLFileIOStrategy();
        }
        return this.ioStrategy.read(input, this);
    }

    public List<ROI> loadROI(long fileID, Collection rois, long userID) throws NoSuchROIException, ROICreationException {
        if (rois == null) {
            throw new NullPointerException("No rois to transform.");
        }
        if (this.serverStrategy == null) {
            this.serverStrategy = new ServerROIStrategy();
        }
        List<ROI> l = this.serverStrategy.read(rois, this, userID);
        if (fileID > 0L) {
            this.roiResult.put(fileID, l);
        }
        return l;
    }

    public List<ROI> getROIList(long fileID) {
        return this.roiResult.get(fileID);
    }

    public long getNextID() {
        return this.roiCollection.getNextID();
    }

    public ROI createROI(long id) throws ROICreationException {
        return this.roiCollection.createROI(id, true, true, true, true, Collections.EMPTY_LIST);
    }

    public ROI createROI(long id, boolean clientSideObject, boolean editable, boolean deletable, boolean annotatable, Collection<FolderData> folders) throws ROICreationException {
        return this.roiCollection.createROI(id, clientSideObject, editable, deletable, annotatable, folders);
    }

    public ROI createROI() throws ROICreationException {
        return this.roiCollection.createROI();
    }

    public ROI cloneROI(long id) throws ROICreationException, NoSuchROIException {
        ROI newROI = this.roiCollection.createROI();
        newROI.setAnnotations(this.roiCollection.getROI(id).getAnnotation());
        return newROI;
    }

    public TreeMap<Long, ROI> getROIMap() {
        return this.roiCollection.getROIMap();
    }

    public ROI getROI(long id) throws NoSuchROIException {
        return this.roiCollection.getROI(id);
    }

    public boolean containsROI(long id) {
        return this.roiCollection.containsROI(id);
    }

    public ROIShape getShape(long id, Coord3D coord) throws NoSuchROIException {
        return this.roiCollection.getShape(id, coord);
    }

    public boolean containsShape(long id, Coord3D coord) {
        if (!this.containsROI(id)) {
            return false;
        }
        try {
            ROI roi = this.getROI(id);
            return roi.containsShape(coord);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ShapeList getShapeList(Coord3D coord) throws NoSuchROIException {
        return this.roiCollection.getShapeList(coord);
    }

    public void deleteROI(long id) throws NoSuchROIException {
        this.roiCollection.deleteROI(id);
    }

    public void deleteShape(long id, Coord3D coord) throws NoSuchROIException {
        this.roiCollection.deleteShape(id, coord);
    }

    public void addShape(long id, Coord3D coord, ROIShape shape) throws ROICreationException, NoSuchROIException {
        this.roiCollection.addShape(id, coord, shape);
    }

    public List<ROIShape> propagateShape(long id, Coord3D selectedShape, Coord3D start, Coord3D end) throws ROICreationException, NoSuchROIException {
        return this.roiCollection.propagateShape(id, selectedShape, start, end);
    }

    public void deleteShape(long id, Coord3D start, Coord3D end) throws NoSuchROIException {
        this.roiCollection.deleteShape(id, start, end);
    }

    public void addROIRelationship(ROIRelationship relationship) {
        this.roiCollection.addROIRelationship(relationship);
    }

    public void addROIShapeRelationship(ROIShapeRelationship relationship) {
        this.roiCollection.addROIShapeRelationship(relationship);
    }

    public void removeROIRelationship(long relationship) {
        this.roiCollection.removeROIRelationship(relationship);
    }

    public void removeROIShapeRelationship(long relationship) {
        this.roiCollection.removeROIShapeRelationship(relationship);
    }

    public boolean containsROIRelationship(long relationship) {
        return this.roiCollection.containsROIRelationship(relationship);
    }

    public boolean containsROIShapeRelationship(long relationship) {
        return this.roiCollection.containsROIShapeRelationship(relationship);
    }

    public ROIRelationshipList getROIRelationshipList(long roiID) {
        return this.roiCollection.getROIRelationshipList(roiID);
    }

    public ROIShapeRelationshipList getROIShapeRelationshipList(long roiID) {
        return this.roiCollection.getROIShapeRelationshipList(roiID);
    }

    public MeasurementUnits getMeasurementUnits() {
        return this.units;
    }
}

