/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;

class FSFolderModel
extends DataBrowserModel {
    FSFolderModel(SecurityContext ctx, Object parent, Collection<DataObject> files) {
        super(ctx);
        if (files == null) {
            throw new IllegalArgumentException("No files.");
        }
        this.parent = parent;
        ArrayList<DataObject> toTransform = new ArrayList<DataObject>();
        Iterator<DataObject> i = files.iterator();
        this.numberOfImages = 0;
        while (i.hasNext()) {
            DataObject o = i.next();
            if (!(o instanceof ImageData)) continue;
            toTransform.add(o);
            ++this.numberOfImages;
        }
        Set visTrees = DataBrowserTranslator.transformFSFolder(toTransform);
        this.browser = BrowserFactory.createBrowser(visTrees);
    }

    @Override
    protected List<DataBrowserLoader> createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<DataObject> imgs = new ArrayList<DataObject>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                DataObject data;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((data = (DataObject)node.getHierarchyObject()).getId()) || loaded.contains(data.getId())) continue;
                imgs.add(data);
                loaded.add(data.getId());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                DataObject data = (DataObject)node.getHierarchyObject();
                long id = data.getId();
                if (id > 0L) {
                    if (loaded.contains(id)) continue;
                    imgs.add(data);
                    loaded.add(id);
                    ++this.imagesLoaded;
                    continue;
                }
                if (!(data instanceof ImageData)) continue;
                imgs.add(data);
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return null;
    }

    @Override
    protected int getType() {
        return 9;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

