/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.actions.ViewerAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MovieAction
extends ViewerAction {
    private static final String NAME = "Movie...";
    private static final String DESCRIPTION = "Bring up the movie player.";

    @Override
    protected void onTabSelection() {
        if (this.model.isBigImage()) {
            this.setEnabled(false);
            return;
        }
        if (this.model.getSelectedIndex() == 2) {
            this.setEnabled(false);
        } else if (this.model.isPlayingMovie()) {
            this.setEnabled(false);
        } else {
            int max = Math.max(this.model.getMaxZ(), this.model.getRealT());
            this.setEnabled(max > 1);
        }
    }

    @Override
    protected void onStateChange(ChangeEvent e) {
        switch (this.model.getState()) {
            case 8: {
                this.setEnabled(false);
                break;
            }
            case 6: {
                this.onTabSelection();
            }
        }
    }

    public MovieAction(ImViewer model) {
        super(model, NAME);
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(3));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.model.isPlayingMovie()) {
            this.model.playMovie(true, true, -1);
        }
    }
}

