/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.graphutils;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.statistics.HistogramDataset;
import org.jfree.data.xy.XYDataset;
import org.openmicroscopy.shoola.util.ui.graphutils.ChartObject;
import org.openmicroscopy.shoola.util.ui.graphutils.HistogramBarRenderer;

public class HistogramPlot
extends ChartObject {
    private List<double[]> data;
    private HistogramDataset dataset;

    private void initialize() {
        this.data = new ArrayList<double[]>();
        this.dataset = new HistogramDataset();
    }

    public HistogramPlot() {
        super("");
        this.initialize();
    }

    public HistogramPlot(String title, List<String> newLegends, List<double[]> newData, List<Color> newColours, int bins) {
        super(title);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() && newLegends.size() != newColours.size() || newLegends.size() == 0 || bins < 1) {
            throw new IllegalArgumentException("Mismatch between argument length");
        }
        this.initialize();
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), bins);
        }
        this.setDefaultAxis();
    }

    public HistogramPlot(String title, List<String> newLegends, List<double[]> newData, List<Color> newColours, int bins, double minValue, double maxValue) {
        super(title);
        this.initialize();
        this.setDefaultAxis();
        this.domainAxis.setRange(minValue, maxValue);
        if (newLegends == null || newData == null || newColours == null || newLegends.size() != newData.size() || newLegends.size() != newColours.size()) {
            return;
        }
        for (int i = 0; i < newLegends.size(); ++i) {
            this.addSeries(newLegends.get(i), newData.get(i), newColours.get(i), bins);
        }
    }

    public int addSeries(String legend, double[] newData, Color color, int bins) {
        if (legend == null || newData == null || color == null || bins < 1) {
            throw new IllegalArgumentException("Illegal argument in addSeries.");
        }
        this.legends.add(legend);
        this.data.add(newData);
        this.colours.add(color);
        this.dataset.addSeries((Comparable)((Object)legend), newData, bins);
        return this.dataset.getSeriesCount();
    }

    public Map<Double, Double> getYValues(int threshold) {
        LinkedHashMap<Double, Double> map = new LinkedHashMap<Double, Double>();
        for (int i = 0; i < this.dataset.getSeriesCount(); ++i) {
            int n = this.dataset.getItemCount(i);
            for (int j = 0; j < n; ++j) {
                double y = this.dataset.getEndYValue(i, j);
                if (!(y > (double)threshold)) continue;
                map.put(this.dataset.getEndXValue(i, j), y);
            }
        }
        return map;
    }

    @Override
    void createChart() {
        HistogramBarRenderer renderer = new HistogramBarRenderer(this.colours);
        for (int i = 0; i < this.colours.size(); ++i) {
            renderer.setSeriesPaint(i, (Paint)this.colours.get(i));
        }
        XYPlot plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)this.domainAxis, (ValueAxis)this.rangeAxis, (XYItemRenderer)renderer);
        if (this.backgroundImage != null) {
            plot.setRangeGridlinesVisible(false);
            plot.setDomainGridlinesVisible(false);
            plot.setBackgroundImage(this.backgroundImage);
        }
        this.chart = new JFreeChart(this.title, (Plot)plot);
    }
}

