/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Thumbnail;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ThumbnailCanvas;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ImageNode
extends ImageDisplay {
    public static final String CLASSIFY_NODE_PROPERTY = "classifyNode";
    public static final String PIN_THUMBNAIL_PROPERTY = "pinThumbnail";
    private static final String LEFT = " (";
    private static final String RIGHT = ")";
    private Thumbnail thumbnail;
    private ThumbnailCanvas canvas;

    @Override
    protected void doAccept(ImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    void pinThumbnail() {
        this.firePropertyChange(PIN_THUMBNAIL_PROPERTY, null, this);
    }

    public ImageNode(String title, Object hierarchyObject, Thumbnail t) {
        this(title, hierarchyObject, t, 1);
    }

    public ImageNode(String title, Object hierarchyObject, Thumbnail t, int titleBar) {
        super(title, "", hierarchyObject);
        String s = UIUtilities.formatString(title, -1);
        this.setTitle(this.getPartialName(title + LEFT + this.getFormattedAcquisitionTime() + RIGHT));
        List<String> l = null;
        if (hierarchyObject instanceof ImageData || hierarchyObject instanceof WellSampleData) {
            l = EditorUtil.formatObjectTooltip((DataObject)hierarchyObject);
        }
        if (l == null || l.size() == 0) {
            this.setToolTipText(s);
        } else {
            ArrayList<String> ll = new ArrayList<String>();
            ll.add(s);
            ll.addAll(l);
            this.setToolTipText(UIUtilities.formatToolTipText(ll));
        }
        this.setNodeDecoration();
        this.thumbnail = t;
        if (t != null) {
            this.canvas = new ThumbnailCanvas(this);
            this.getInternalDesktop().add((Component)this.canvas, (Object)0);
            this.setCanvasSize(t.getWidth(), t.getHeight());
            this.setCanvasToolTip(this.getToolTipText());
            if (hierarchyObject instanceof ImageData) {
                String imageName = ((ImageData)hierarchyObject).getName();
                this.setName("image node for " + imageName);
                this.canvas.setName("thumbnail for " + imageName);
            }
        }
        this.setTitleBarType(titleBar);
    }

    @Override
    public void addListenerToComponents(Object listener) {
        if (listener == null) {
            return;
        }
        if (listener instanceof MouseListener) {
            this.getTitleBar().addMouseListener((MouseListener)listener);
            if (this.canvas != null) {
                this.canvas.addMouseListener((MouseListener)listener);
            }
        } else if (listener instanceof KeyListener) {
            this.getTitleBar().addKeyListener((KeyListener)listener);
            if (this.canvas != null) {
                this.canvas.addKeyListener((KeyListener)listener);
            }
        }
    }

    @Override
    public void addChildDisplay(ImageDisplay child) {
        throw new IllegalArgumentException("Can't add a child to an ImageNode.");
    }

    @Override
    public boolean containsImages() {
        return false;
    }

    public Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    public Timestamp getAcquisitionTime() {
        ImageData img;
        Object uo = this.getHierarchyObject();
        Timestamp t = null;
        if (uo instanceof ImageData) {
            t = ((ImageData)uo).getAcquisitionDate();
        } else if (uo instanceof WellSampleData && (img = ((WellSampleData)uo).getImage()) != null) {
            t = img.getAcquisitionDate();
        }
        if (t == null) {
            t = new Timestamp(new Date().getTime());
        }
        return t;
    }

    public String getFormattedAcquisitionTime() {
        return DateFormat.getDateInstance().format(this.getAcquisitionTime());
    }

    public void setCanvasSize(int w, int h) {
        if (this.canvas != null) {
            this.canvas.setBounds(0, 0, w, h);
        }
        this.getInternalDesktop().setSize(w, h);
        this.getInternalDesktop().setPreferredSize(new Dimension(w, h));
    }

    public void setCanvasToolTip(String text) {
        if (this.canvas != null) {
            this.canvas.setToolTipText(text);
        }
    }

    public ImageNode copy() {
        ImageNode img = new ImageNode(this.getTitle(), this.getHierarchyObject(), this.getThumbnail());
        if (this.canvas != null) {
            img.setCanvasSize(this.canvas.getWidth(), this.canvas.getHeight());
        }
        return img;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.setResizable(false);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.setResizable(false);
    }
}

