/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.model.units.Unit;
import ome.units.quantity.Length;
import ome.xml.model.Dichroic;
import ome.xml.model.Filter;
import ome.xml.model.enums.FilterType;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class FilterConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        labelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPane.add(label);
        IconManager icons = IconManager.getInstance();
        JButton applyBtn = new JButton(icons.getIcon(73));
        applyBtn.setToolTipText("Apply table selection");
        applyBtn.setAlignmentX(1.0f);
        labelPane.add(applyBtn);
        return labelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Filter f) {
        this.tagMap = new LinkedHashMap();
        if (f != null) {
            try {
                this.tagMap.put("ID", this.convertID(f.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(f.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(f.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
            try {
                this.tagMap.put("FilterType", this.convertType(f.getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("FilterType", this.convertType(null, true));
            }
            try {
                this.tagMap.put("Filterwheel", this.convertFilterwheel(f.getFilterWheel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Filterwheel", this.convertFilterwheel(null, true));
            }
            try {
                this.tagMap.put("CutIn", this.convertTransRange_In(f.getTransmittanceRange().getCutIn(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("CutIn", this.convertTransRange_In(null, true));
            }
            try {
                this.tagMap.put("CutOut", this.convertTransRange_Out(f.getTransmittanceRange().getCutOut(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("CutOut", this.convertTransRange_Out(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            this.tagMap.put("FilterType", this.convertType(null, true));
            this.tagMap.put("Filterwheel", this.convertFilterwheel(null, true));
            this.tagMap.put("CutIn", this.convertTransRange_In(null, true));
            this.tagMap.put("CutOut", this.convertTransRange_Out(null, true));
        }
        return this.tagMap;
    }

    public LinkedHashMap<String, TagData> convertData(Dichroic d) {
        this.tagMap = new LinkedHashMap();
        if (d != null) {
            try {
                this.tagMap.put("Model", this.convertModel(d.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(d.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
        } else {
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Filter", "ID", value, prop, "TextField");
    }

    private TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Filter", "Model", value, prop, "TextField");
    }

    private TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Filter", "Manufacturer", value, prop, "TextField");
    }

    private TagData convertType(FilterType value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Filter", "FilterType", val, prop, "ComboBox", OMEValueConverter.getNames(FilterType.class));
    }

    private TagData convertFilterwheel(String value, boolean prop) {
        return new TagData("OME:Filter", "Filterwheel", value, prop, "TextField");
    }

    private TagData convertTransRange_In(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        return new TagData("OME:Filter", "CutIn", (Unit)val, ome.model.units.Length.class, prop, "TextField");
    }

    private TagData convertTransRange_Out(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        return new TagData("OME:Filter", "CutOut", (Unit)val, ome.model.units.Length.class, prop, "TextField");
    }
}

