/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.Font;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.metadata.editor.AcquisitionDataUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.util.DataComponent;
import org.openmicroscopy.shoola.util.ui.JLabelButton;
import org.openmicroscopy.shoola.util.ui.OMETextArea;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DichroicComponent
extends JPanel
implements PropertyChangeListener {
    private Map<String, DataComponent> fields;
    private JLabelButton unset;
    private boolean unsetShown;
    private AcquisitionDataUI parent;
    private EditorModel model;

    private void initComponents() {
        this.fields = new LinkedHashMap<String, DataComponent>();
        this.unset = null;
        this.unsetShown = false;
    }

    private void displayUnsetFields() {
        this.unsetShown = !this.unsetShown;
        String s = "Show unset fields";
        if (this.unsetShown) {
            s = "Hide unset fields";
        }
        this.unset.setText(s);
        this.parent.layoutFields(this, this.unset, this.fields, this.unsetShown);
    }

    private void transformDichroicSource(Map<String, Object> details) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        int sizeLabel = font.getSize() - 2;
        List notSet = (List)details.get("NotSet");
        details.remove("NotSet");
        if (notSet.size() > 0 && this.unset == null) {
            this.unset = this.parent.formatUnsetFieldsControl();
            this.unset.addPropertyChangeListener(this);
        }
        Set<Map.Entry<String, Object>> entrySet = details.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            boolean set = !notSet.contains(key);
            Object value = entry.getValue();
            label = UIUtilities.setTextFont(key, 1, sizeLabel);
            label.setBackground(UIUtilities.BACKGROUND_COLOR);
            JComponent area = UIUtilities.createComponent(OMETextArea.class, null);
            if (value == null || value.equals("")) {
                value = "None";
            }
            ((OMETextArea)area).setEditable(false);
            ((OMETextArea)area).setText((String)value);
            ((OMETextArea)area).setEditedColor(UIUtilities.EDITED_COLOR);
            area.setEnabled(!set);
            DataComponent comp = new DataComponent(label, area);
            comp.setEnabled(false);
            comp.setSetField(!notSet.contains(key));
            this.fields.put(key, comp);
        }
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createTitledBorder("Dichroic"));
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
    }

    DichroicComponent(AcquisitionDataUI parent, EditorModel model) {
        this.parent = parent;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void displayDichroic(Map<String, Object> details) {
        this.fields.clear();
        this.transformDichroicSource(details);
        this.parent.layoutFields(this, this.unset, this.fields, this.unsetShown);
        this.parent.attachListener(this.fields);
    }

    boolean hasDataToSave() {
        return this.parent.hasDataToSave(this.fields);
    }

    void prepareDataToSave() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selected".equals(name)) {
            this.displayUnsetFields();
        }
    }
}

