/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor.maptable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTable;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MapTableCellRenderer
implements TableCellRenderer {
    public static final Color GREY = new Color(200, 200, 200);
    public static final Color LIGHT_GREY = new Color(230, 230, 230);
    public static final Color LIGHTER_GREY = new Color(238, 238, 238);
    private static final Font ITALIC = new JLabel().getFont().deriveFont(2);
    private static final Font DEFAULT_FONT = new JLabel().getFont();
    private static final Color DEFAULT_FONT_COLOR = new JLabel().getForeground();
    private TableCellRenderer original;

    public MapTableCellRenderer(TableCellRenderer original) {
        this.original = original;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color oddColor;
        JLabel l = (JLabel)this.original.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (row == table.getRowCount() - 1 && ("Add Key".equals(value) || "Add Value".equals(value))) {
            l.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
            l.setFont(ITALIC);
        } else {
            l.setForeground(DEFAULT_FONT_COLOR);
            l.setFont(DEFAULT_FONT);
        }
        boolean editable = ((MapTable)table).canEdit();
        Color selColor = editable ? UIUtilities.SELECTED_BACKGROUND_COLOUR : GREY;
        Color evenColor = editable ? UIUtilities.BACKGROUND_COLOUR_EVEN : LIGHT_GREY;
        Color color = oddColor = editable ? UIUtilities.BACKGROUND_COLOUR_ODD : LIGHTER_GREY;
        if (isSelected) {
            l.setBackground(selColor);
        } else {
            l.setBackground(row % 2 == 0 ? evenColor : oddColor);
        }
        return l;
    }
}

