/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.util.PasswordDialog;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PasswordResetAction
extends TreeViewerAction {
    private static final String NAME = "Reset Password...";
    private static final String DESCRIPTION = "Resets the password of the selected users.";

    @Override
    protected void onBrowserStateChange(Browser browser) {
        if (browser == null) {
            return;
        }
        switch (browser.getState()) {
            case 11: 
            case 12: 
            case 13: {
                this.setEnabled(false);
                break;
            }
            default: {
                if (browser.getBrowserType() != 6) {
                    this.setEnabled(false);
                    break;
                }
                this.onDisplayChange(browser.getLastSelectedDisplay());
            }
        }
    }

    @Override
    protected void onDisplayChange(TreeImageDisplay selectedDisplay) {
        if (!TreeViewerAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        if (!TreeViewerAgent.isAdministrator()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null || selectedDisplay == null) {
            this.setEnabled(false);
            return;
        }
        if (browser.getBrowserType() != 6) {
            this.setEnabled(false);
            return;
        }
        TreeImageDisplay[] nodes = browser.getSelectedDisplays();
        if (nodes.length > 1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(selectedDisplay.getUserObject() instanceof ExperimenterData);
        }
    }

    public PasswordResetAction(TreeViewer model) {
        super(model);
        this.name = NAME;
        IconManager icons = IconManager.getInstance();
        this.putValue("SmallIcon", icons.getIcon(122));
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PasswordDialog d = new PasswordDialog(this.model.getUI());
        d.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("resetPassword".equals(evt.getPropertyName())) {
                    String value = (String)evt.getNewValue();
                    PasswordResetAction.this.model.resetPassword(value);
                }
            }
        });
        UIUtilities.centerAndShow(d);
    }
}

