/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallFeedbackEvent;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class FilesLoader
extends UserNotifierLoader {
    private CallHandle handle;
    private Map<FileAnnotationData, File> files;
    private List<File> results;

    @Override
    protected void onException(String message, Throwable ex) {
        this.activity.notifyError("Unable to download the file", message, ex);
    }

    FilesLoader(UserNotifier viewer, Registry reg, SecurityContext ctx, Map<FileAnnotationData, File> files, ActivityComponent activity) {
        super(viewer, reg, ctx, activity);
        if (files == null || files.size() == 0) {
            throw new IllegalArgumentException("No files to download");
        }
        this.files = files;
        this.results = new ArrayList<File>();
    }

    @Override
    public void load() {
        this.handle = this.mhView.loadFiles(this.ctx, true, this.files, this);
    }

    @Override
    public void cancel() {
        if (this.handle != null) {
            this.handle.cancel();
        }
        Iterator<File> i = this.files.values().iterator();
        while (i.hasNext()) {
            i.next().delete();
        }
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    @Override
    public void update(DSCallFeedbackEvent fe) {
        Map m = (Map)fe.getPartialResult();
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                FileAnnotationData fa = (FileAnnotationData)entry.getKey();
                this.results.add((File)entry.getValue());
            }
            if (this.results.size() == this.files.size() && this.activity != null) {
                this.activity.endActivity(this.results);
            }
        }
    }

    @Override
    public void handleNullResult() {
    }

    @Override
    public void handleResult(Object result) {
        if (result == null) {
            this.onException("No result returned.", null);
        } else if (this.activity != null) {
            this.activity.endActivity(result);
        }
    }
}

