/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;
import org.openmicroscopy.shoola.util.roi.model.util.Coord3D;

public class StackIterator
implements Iterable<ArrayList<ROIShape>>,
Iterator<ArrayList<ROIShape>> {
    private TreeMap<Coord3D, ROIShape> stack;
    private int currentT;
    private int minT;
    private int maxT;
    private int minZ;
    private int maxZ;

    public StackIterator(TreeMap<Coord3D, ROIShape> stack) {
        this.stack = stack;
        Coord3D minCoord = stack.firstKey();
        Coord3D maxCoord = stack.lastKey();
        this.minZ = minCoord.getZSection();
        this.maxZ = maxCoord.getZSection();
        this.minT = minCoord.getTimePoint();
        this.maxT = maxCoord.getTimePoint();
        this.currentT = this.minT;
    }

    @Override
    public Iterator<ArrayList<ROIShape>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.currentT <= this.maxT;
    }

    @Override
    public ArrayList<ROIShape> next() {
        Coord3D start = new Coord3D(this.minZ, this.currentT);
        Coord3D end = new Coord3D(this.maxZ, this.currentT);
        ArrayList<ROIShape> zStack = new ArrayList<ROIShape>();
        if (start.equals(end)) {
            zStack.add(this.stack.get(start));
        } else {
            SortedMap<Coord3D, ROIShape> subStack = this.stack.subMap(start, end);
            Iterator<ROIShape> s = subStack.values().iterator();
            while (s.hasNext()) {
                zStack.add(s.next());
            }
        }
        ++this.currentT;
        return zStack;
    }

    @Override
    public void remove() {
    }
}

