/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import ome.conditions.InternalException;
import ome.system.PreferenceContext;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBPatchCheck {
    public static final Logger log = LoggerFactory.getLogger(DBPatchCheck.class);
    final SqlAction sql;
    final PreferenceContext prefs;
    private static final String line = "***************************************************************************************\n";
    private static final String see = "See https://docs.openmicroscopy.org/latest/omero/sysadmins/server-upgrade.html\n";
    private static final String no_table = DBPatchCheck.mk("Error connecting to database table dbpatch. You may need to bootstrap.\n");
    private static final String wrong_version = DBPatchCheck.mk("DB version (%s) does not match the configured value (%s). Please apply a db upgrade.\n");

    public DBPatchCheck(SqlAction sql, PreferenceContext prefs) {
        this.sql = sql;
        this.prefs = prefs;
    }

    private static String mk(String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(line);
        sb.append(msg);
        sb.append(see);
        sb.append(line);
        return sb.toString();
    }

    public void start() throws Exception {
        String[] results = new String[3];
        try {
            results[0] = this.sql.dbVersion();
            results[1] = this.prefs.getProperty("omero.db.version");
            results[2] = this.prefs.getProperty("omero.db.patch");
        }
        catch (Exception e) {
            log.error(no_table, (Throwable)e);
            InternalException ie = new InternalException(no_table);
            throw ie;
        }
        String patch = results[0];
        String version = results[1];
        String dbpatch = results[2];
        String omero = version + "__" + dbpatch;
        if (patch == null || !patch.equals(omero)) {
            String str = String.format(wrong_version, patch, omero);
            log.error(str);
            InternalException ie = new InternalException(str);
            throw ie;
        }
        log.info(String.format("Verified database patch: %s", patch));
    }
}

