/*
 * Decompiled with CFR 0.152.
 */
package ome.services.util;

import java.io.File;
import ome.services.util.ReadOnlyStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;

public class ServerDirectoryCheck
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger(ServerDirectoryCheck.class);
    private final String omeroDataDir;
    private final String omeroManagedDir;
    private final ReadOnlyStatus readOnly;

    public ServerDirectoryCheck(String omeroDataDir, String omeroManagedDir, ReadOnlyStatus readOnly) {
        this.omeroDataDir = omeroDataDir;
        this.omeroManagedDir = omeroManagedDir;
        this.readOnly = readOnly;
    }

    @Override
    public void run() {
        this.checkDirectory(this.omeroDataDir + File.separator + "FullText");
        this.checkDirectory(this.omeroManagedDir);
    }

    private void checkDirectory(String directoryName) {
        File directory = new File(directoryName);
        if (directory.listFiles() == null) {
            if (this.readOnly.isReadOnlyRepo()) {
                throw new BeanCreationException("required directory " + directory + " cannot be read but repository is read-only");
            }
            directory.mkdirs();
            log.info("Created " + directory);
        }
    }
}

