/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageTools;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class BMPReader
extends FormatReader {
    public static final String BMP_MAGIC_STRING = "BM";
    private static final int RAW = 0;
    private static final int RLE_8 = 1;
    private static final int RLE_4 = 2;
    private static final int RGB_MASK = 3;
    private int bpp;
    private byte[][] palette;
    private int compression;
    private long global;
    private boolean invertY = false;

    public BMPReader() {
        super("Windows Bitmap", "bmp");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)2, (boolean)false)) {
            return false;
        }
        return stream.readString(2).startsWith(BMP_MAGIC_STRING);
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.palette;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int effectiveC;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.compression != 0 && this.in.length() < (long)FormatTools.getPlaneSize((IFormatReader)this)) {
            throw new UnsupportedCompressionException(this.compression + " not supported");
        }
        long rowsToSkip = this.invertY ? (long)y : (long)(this.getSizeY() - (h + y));
        int rowLength = this.getSizeX() * (this.isIndexed() ? 1 : this.getSizeC()) * this.bpp / 8;
        this.in.seek(this.global + rowsToSkip * (long)rowLength);
        int pad = rowLength * this.bpp / 8 % 2;
        pad = pad == 0 ? rowLength * this.bpp / 8 % 4 : (pad *= this.getSizeC());
        int planeSize = this.getSizeX() * this.getSizeC() * h;
        planeSize = this.bpp >= 8 ? (planeSize *= this.bpp / 8) : (planeSize /= 8 / this.bpp);
        if ((long)(planeSize += pad * h) + this.in.getFilePointer() + rowsToSkip * (long)pad > this.in.length()) {
            if ((long)((planeSize -= pad * h) + this.getSizeY()) + this.in.getFilePointer() <= this.in.length()) {
                pad = 1;
                planeSize += h;
            } else {
                pad = 0;
            }
        }
        this.in.skipBytes(rowsToSkip * (long)pad);
        int n = effectiveC = this.palette != null && this.palette[0].length > 0 ? 1 : this.getSizeC();
        if (this.compression == 0) {
            for (int row = h - 1; row >= 0; --row) {
                int rowIndex = this.invertY ? h - 1 - row : row;
                this.in.skipBits(x * this.bpp * effectiveC);
                for (int i = 0; i < w * effectiveC; ++i) {
                    if (this.bpp <= 8) {
                        buf[rowIndex * w * effectiveC + i] = (byte)(this.in.readBits(this.bpp) & 0xFF);
                        continue;
                    }
                    for (int b = 0; b < this.bpp / 8; ++b) {
                        buf[this.bpp / 8 * (rowIndex * w * effectiveC + i) + b] = (byte)(this.in.readBits(8) & 0xFF);
                    }
                }
                if (row <= 0) continue;
                int nBits = (this.getSizeX() - w - x) * this.bpp * effectiveC + pad * 8;
                if (this.in.getFilePointer() + (long)(nBits / 8) < this.in.length()) {
                    this.in.skipBits(nBits);
                    continue;
                }
                break;
            }
        } else if (this.compression == 1 || this.compression == 2) {
            boolean endOfFile = false;
            int index = 0;
            byte[] plane = new byte[this.getSizeX() * this.getSizeY() * this.getRGBChannelCount()];
            while (!endOfFile) {
                int i;
                int firstByte = this.in.readBits(this.bpp) & 0xFF;
                int secondByte = this.in.readBits(this.bpp) & 0xFF;
                if (firstByte == 0) {
                    byte absoluteByte;
                    if (secondByte == 1) {
                        endOfFile = true;
                        continue;
                    }
                    if (secondByte == 2) {
                        byte xDelta = (byte)(this.in.readBits(this.bpp) & 0xFF);
                        byte yDelta = (byte)(this.in.readBits(this.bpp) & 0xFF);
                        index += yDelta * rowLength + xDelta;
                        continue;
                    }
                    if (secondByte <= 2) continue;
                    if (this.compression == 1) {
                        for (i = 0; i < secondByte; ++i) {
                            plane[index] = absoluteByte = (byte)(this.in.readBits(this.bpp) & 0xFF);
                            ++index;
                        }
                        if (secondByte % 2 != 1) continue;
                        this.in.skipBytes(1);
                        continue;
                    }
                    if (this.compression != 2) continue;
                    for (i = 0; i < secondByte; i += 2) {
                        absoluteByte = (byte)(this.in.readBits(this.bpp) & 0xFF);
                        byte firstNibble = (byte)(absoluteByte & 0xF);
                        byte secondNibble = (byte)((byte)(absoluteByte >> 4) & 0xF);
                        plane[index] = firstNibble;
                        ++index;
                        if (i + 1 >= secondByte) continue;
                        plane[index] = secondNibble;
                        ++index;
                    }
                    if (secondByte % 4 != 2) continue;
                    this.in.skipBytes(1);
                    continue;
                }
                if (this.compression == 1) {
                    for (i = 0; i < firstByte; ++i) {
                        plane[index] = secondByte;
                        ++index;
                    }
                    continue;
                }
                if (this.compression != 2) continue;
                byte firstNibble = (byte)(secondByte & 0xF);
                byte secondNibble = (byte)((byte)(secondByte >> 4) & 0xF);
                for (int i2 = 0; i2 < firstByte; ++i2) {
                    plane[index] = i2 % 2 == 0 ? firstNibble : secondNibble;
                    ++index;
                }
            }
            try (RandomAccessInputStream s = new RandomAccessInputStream(plane);){
                this.readPlane(s, x, y, w, h, buf);
            }
        }
        if (this.getRGBChannelCount() > 1) {
            ImageTools.bgrToRgb(buf, this.isInterleaved(), 1, this.getRGBChannelCount());
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = 0;
            this.bpp = 0;
            this.global = 0L;
            this.palette = null;
            this.invertY = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        LOGGER.info("Reading bitmap header");
        this.in.order(true);
        this.addGlobalMeta("Magic identifier", this.in.readString(2));
        this.addGlobalMeta("File size (in bytes)", this.in.readInt());
        this.in.skipBytes(4);
        this.global = this.in.readInt();
        this.in.skipBytes(4);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        if (this.getSizeX() < 1) {
            LOGGER.trace("Invalid width: {}; using the absolute value", (Object)this.getSizeX());
            m.sizeX = Math.abs(this.getSizeX());
        }
        if (this.getSizeY() < 1) {
            LOGGER.trace("Invalid height: {}; using the absolute value", (Object)this.getSizeY());
            m.sizeY = Math.abs(this.getSizeY());
            this.invertY = true;
        }
        this.addGlobalMeta("Color planes", this.in.readShort());
        this.bpp = this.in.readShort();
        this.compression = this.in.readInt();
        this.in.skipBytes(4);
        int pixelSizeX = this.in.readInt();
        int pixelSizeY = this.in.readInt();
        int nColors = this.in.readInt();
        if (nColors == 0 && this.bpp != 32 && this.bpp != 24) {
            nColors = this.bpp < 8 ? 1 << this.bpp : 256;
        }
        this.in.skipBytes(4);
        if (nColors != 0 && this.bpp == 8) {
            this.palette = new byte[3][256];
            for (int i = 0; i < nColors; ++i) {
                for (int j = this.palette.length - 1; j >= 0; --j) {
                    this.palette[j][i] = this.in.readByte();
                }
                this.in.skipBytes(1);
            }
        } else if (nColors != 0) {
            this.in.skipBytes(nColors * 4);
        }
        LOGGER.info("Populating metadata");
        int n = m.sizeC = this.bpp != 24 ? 1 : 3;
        if (this.bpp == 32) {
            m.sizeC = 4;
        }
        if (this.bpp > 8) {
            this.bpp /= this.getSizeC();
        }
        switch (this.bpp) {
            case 16: {
                m.pixelType = 3;
                break;
            }
            case 32: {
                m.pixelType = 5;
                break;
            }
            default: {
                m.pixelType = 1;
            }
        }
        m.rgb = this.getSizeC() > 1;
        m.littleEndian = true;
        m.interleaved = true;
        m.imageCount = 1;
        m.sizeZ = 1;
        m.sizeT = 1;
        m.dimensionOrder = "XYCTZ";
        m.metadataComplete = true;
        boolean bl = m.indexed = this.palette != null;
        if (this.isIndexed()) {
            m.sizeC = 1;
            m.rgb = false;
        }
        m.falseColor = false;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.addGlobalMeta("Indexed color", this.palette != null);
            this.addGlobalMeta("Image width", this.getSizeX());
            this.addGlobalMeta("Image height", this.getSizeY());
            this.addGlobalMeta("Bits per pixel", this.bpp);
            String comp = "invalid";
            switch (this.compression) {
                case 0: {
                    comp = "None";
                    break;
                }
                case 1: {
                    comp = "8 bit run length encoding";
                    break;
                }
                case 2: {
                    comp = "4 bit run length encoding";
                    break;
                }
                case 3: {
                    comp = "RGB bitmap with mask";
                }
            }
            this.addGlobalMeta("Compression type", comp);
            this.addGlobalMeta("X resolution", pixelSizeX);
            this.addGlobalMeta("Y resolution", pixelSizeY);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            double correctedX = pixelSizeX == 0 ? 0.0 : 1000000.0 / (double)pixelSizeX;
            double correctedY = pixelSizeY == 0 ? 0.0 : 1000000.0 / (double)pixelSizeY;
            Length sizeX = FormatTools.getPhysicalSizeX((Double)correctedX);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)correctedY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

