/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import loci.common.CBZip2InputStream;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.unit.Unit;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PrimitiveNumber;
import org.apache.commons.lang3.ArrayUtils;

public class KLBReader
extends FormatReader {
    private static final int KLB_DATA_DIMS = 5;
    private static final int KLB_METADATA_SIZE = 256;
    private static final int KLB_DEFAULT_HEADER_VERSION = 2;
    private static final int UINT8_TYPE = 0;
    private static final int UINT16_TYPE = 1;
    private static final int UINT32_TYPE = 2;
    private static final int UINT64_TYPE = 3;
    private static final int INT8_TYPE = 4;
    private static final int INT16_TYPE = 5;
    private static final int INT32_TYPE = 6;
    private static final int INT64_TYPE = 7;
    private static final int FLOAT32_TYPE = 8;
    private static final int FLOAT64_TYPE = 9;
    private static final int COMPRESSION_NONE = 0;
    private static final int COMPRESSION_BZIP2 = 1;
    private static final int COMPRESSION_ZLIB = 2;
    private MetadataStore store;
    private int compressionType = 0;
    private double numBlocks = 1.0;
    private int[] dims_blockSize = new int[5];
    private int[] dims_xyzct = new int[5];
    private long[] blockOffsets;
    private long headerSize;
    private int blocksPerPlane;
    private long offsetFilePointer;
    private int headerVersion;
    private LinkedHashMap<String, String[][]> filelist = new LinkedHashMap();
    private ArrayList<Integer> channels = new ArrayList();
    private static final String DEFAULT_SERIES = "Default";
    public static final String CHANNEL_PREFIX = "_CHN";
    public static final String TIME_PREFIX = ".TM";
    public static final String TIME_SUFFIX = "_timeFused";
    public static final String PROJECTION_PREFIX = "fusedStack_";
    public static final String PROJECTION_SUFFIX = "Projection";
    public static final Set<String> SERIES_PREFIXES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("xy", "xz", "yz")));

    public KLBReader() {
        super("KLB", "klb");
        this.suffixSufficient = true;
        this.domains = new String[]{"Unknown"};
        this.setGroupFiles(true);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.in.close();
        int[] currentCoords = this.getZCTCoords(no);
        int currentSeries = this.getSeries();
        Set<String> keys = this.filelist.keySet();
        String fileName = this.filelist.get(keys.toArray()[currentSeries])[currentCoords[2]][currentCoords[1]];
        this.in = new RandomAccessInputStream(fileName);
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.reCalculateBlockOffsets(no);
        int xBlockOffset = x % this.dims_blockSize[0];
        int yBlockOffset = y % this.dims_blockSize[1];
        int xBlockRemainder = this.dims_blockSize[0] - xBlockOffset;
        int yBlockRemainder = this.dims_blockSize[1] - yBlockOffset;
        int xNumBlocks = 1 + (int)Math.ceil((float)(w - xBlockRemainder) / (float)this.dims_blockSize[0]);
        int yNumBlocks = 1 + (int)Math.ceil((float)(h - yBlockRemainder) / (float)this.dims_blockSize[1]);
        int blocksPerImageRow = (int)Math.ceil((float)this.getSizeX() / (float)this.dims_blockSize[0]);
        int xBlockStartIndex = 0;
        if (x > 0) {
            xBlockStartIndex = x / this.dims_blockSize[0];
        }
        int yBlockStartIndex = 0;
        if (y > 0) {
            yBlockStartIndex = y / this.dims_blockSize[1];
        }
        int bytesPerPixel = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int[] dimsBlock = new int[5];
        int[] coordBlock = new int[5];
        int[] blockSizeAux = new int[5];
        for (int ii = 0; ii < 5; ++ii) {
            dimsBlock[ii] = (int)Math.ceil((float)this.dims_xyzct[ii] / (float)this.dims_blockSize[ii]);
        }
        long compressedBlockSize = this.blockOffsets[1] - this.blockOffsets[0];
        int outputOffset = 0;
        for (int yy = 0; yy < yNumBlocks; ++yy) {
            for (int xx = 0; xx < xNumBlocks; ++xx) {
                int ii;
                int blockId = (yBlockStartIndex + yy) * blocksPerImageRow + xBlockStartIndex + xx;
                for (ii = 0; ii < 5; ++ii) {
                    if (ii == 1) {
                        coordBlock[1] = blockId / dimsBlock[0];
                    } else {
                        coordBlock[ii] = blockId % dimsBlock[ii];
                    }
                    int n = ii;
                    coordBlock[n] = coordBlock[n] * this.dims_blockSize[ii];
                }
                blockSizeAux[0] = Math.min(this.dims_blockSize[0], x + w - coordBlock[0]);
                blockSizeAux[0] = Math.min(blockSizeAux[0], coordBlock[0] + this.dims_blockSize[0] - x);
                blockSizeAux[1] = Math.min(this.dims_blockSize[1], y + h - coordBlock[1]);
                blockSizeAux[1] = Math.min(blockSizeAux[1], coordBlock[1] + this.dims_blockSize[1] - y);
                for (ii = 2; ii < 5; ++ii) {
                    blockSizeAux[ii] = Math.min(this.dims_blockSize[ii], this.dims_xyzct[ii] - coordBlock[ii]);
                }
                int blockSizeBytes = bytesPerPixel;
                for (int ii2 = 0; ii2 < 5; ++ii2) {
                    if (ii2 == 0 && coordBlock[ii2] + blockSizeAux[ii2] >= this.dims_xyzct[ii2]) {
                        blockSizeBytes *= blockSizeAux[0];
                        continue;
                    }
                    blockSizeBytes *= this.dims_blockSize[ii2];
                }
                compressedBlockSize = this.blockOffsets[blockId + 1] - this.blockOffsets[blockId];
                long offset = this.blockOffsets[blockId];
                this.in.seek(this.headerSize + offset);
                byte[] block = new byte[(int)compressedBlockSize];
                this.in.read(block);
                if (this.compressionType == 1) {
                    byte[] tempPixels = block;
                    block = new byte[tempPixels.length - 2];
                    System.arraycopy(tempPixels, 2, block, 0, block.length);
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(block);
                        CBZip2InputStream bzip = new CBZip2InputStream(bais);
                        block = new byte[blockSizeBytes];
                        bzip.read(block, 0, block.length);
                        tempPixels = null;
                        bais.close();
                        bzip.close();
                        bais = null;
                        bzip = null;
                    }
                    catch (IOException e) {
                        LOGGER.error("IOException while decompressing block {}", (Object)xx);
                        throw e;
                    }
                } else if (this.compressionType == 2) {
                    CodecOptions options = new CodecOptions();
                    block = new ZlibCodec().decompress(block, options);
                }
                try {
                    int imageRowSize = w * bytesPerPixel;
                    int blockRowSize = blockSizeAux[0] * bytesPerPixel;
                    int fullBlockRowSize = this.dims_blockSize[0] * bytesPerPixel;
                    int actualBlockWidth = Math.min(this.dims_blockSize[0], this.getSizeX() - coordBlock[0]);
                    int actualBlockHeight = Math.min(this.dims_blockSize[1], this.getSizeY() - coordBlock[1]);
                    int actualBlockPlaneSize = bytesPerPixel * actualBlockHeight * actualBlockWidth;
                    outputOffset = imageRowSize * (coordBlock[1] - y) + (coordBlock[0] - x) * bytesPerPixel;
                    if (coordBlock[0] < x && blockSizeAux[0] != this.dims_blockSize[0]) {
                        outputOffset += (this.dims_blockSize[0] - blockSizeAux[0]) * bytesPerPixel;
                    }
                    if (coordBlock[1] < y && blockSizeAux[1] != this.dims_blockSize[1]) {
                        outputOffset = (coordBlock[0] - x) * bytesPerPixel;
                    }
                    if (coordBlock[1] < y && coordBlock[0] < x && blockSizeAux[1] != this.dims_blockSize[1] && blockSizeAux[0] != this.dims_blockSize[0]) {
                        outputOffset = 0;
                    }
                    int inputOffset = currentCoords[0] % this.dims_blockSize[2] * actualBlockPlaneSize;
                    if (coordBlock[0] < x && coordBlock[1] < y && blockSizeAux[1] != this.dims_blockSize[1] && blockSizeAux[0] != this.dims_blockSize[0]) {
                        inputOffset += (this.dims_blockSize[0] * (y - coordBlock[1]) + (x - coordBlock[0])) * bytesPerPixel;
                    } else if (coordBlock[0] < x && blockSizeAux[0] != this.dims_blockSize[0]) {
                        inputOffset += (x - coordBlock[0]) * bytesPerPixel;
                    } else if (coordBlock[1] < y && blockSizeAux[1] != this.dims_blockSize[1] && coordBlock[0] + blockSizeAux[0] == this.dims_xyzct[0]) {
                        inputOffset += blockSizeAux[0] * (y - coordBlock[1]) * bytesPerPixel;
                    } else if (coordBlock[1] < y && blockSizeAux[1] != this.dims_blockSize[1]) {
                        inputOffset += this.dims_blockSize[0] * (y - coordBlock[1]) * bytesPerPixel;
                    }
                    inputOffset += coordBlock[3] % this.dims_blockSize[3] * blockRowSize * blockSizeAux[1] * blockSizeAux[2];
                    inputOffset += coordBlock[4] % this.dims_blockSize[4] * blockRowSize * blockSizeAux[1] * blockSizeAux[2] * blockSizeAux[3];
                    if (coordBlock[0] + blockSizeAux[0] == this.dims_xyzct[0]) {
                        fullBlockRowSize = blockRowSize;
                    }
                    for (int numRows = 0; numRows < blockSizeAux[1]; ++numRows) {
                        int destPos = outputOffset + numRows * imageRowSize;
                        if (destPos + blockRowSize > buf.length) continue;
                        System.arraycopy(block, inputOffset + numRows * fullBlockRowSize, buf, destPos, blockRowSize);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new FormatException("Exception caught while copying decompressed block data to output buffer : " + e);
                }
            }
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        String basePrefix;
        super.initFile(id);
        this.store = this.makeFilterMetadata();
        this.in = new RandomAccessInputStream(id);
        int sizeT = 0;
        int sizeC = 1;
        String parent = new Location(id).getAbsoluteFile().getParent();
        File folder = new File(parent);
        Object[] listOfFiles = folder.listFiles();
        if (this.isGroupFiles() && id.indexOf(CHANNEL_PREFIX) >= 0) {
            basePrefix = id.substring(id.lastIndexOf(File.separator) + 1, id.indexOf(CHANNEL_PREFIX));
            for (int i = 0; i < listOfFiles.length; ++i) {
                int channelNum;
                String fileName = listOfFiles[i].getName();
                if (!fileName.contains(basePrefix) || this.channels.contains(channelNum = DataTools.parseInteger(fileName.substring(fileName.indexOf(CHANNEL_PREFIX) + CHANNEL_PREFIX.length(), fileName.indexOf(46))).intValue())) continue;
                this.channels.add(channelNum);
            }
            if (this.channels.size() > 0) {
                sizeC = this.channels.size();
                Collections.sort(this.channels);
            }
            String topLevelFolder = new Location(parent).getAbsoluteFile().getParent();
            folder = new File(topLevelFolder);
            listOfFiles = folder.listFiles();
            basePrefix = parent.substring(parent.lastIndexOf(File.separator) + 1, parent.lastIndexOf(46));
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileName = ((File)listOfFiles[i]).getName();
                if (!fileName.startsWith(basePrefix)) continue;
                ++sizeT;
            }
        }
        if (this.isGroupFiles() && sizeT > 0) {
            this.filelist.put(DEFAULT_SERIES, new String[sizeT][sizeC]);
            basePrefix = parent.substring(parent.lastIndexOf(File.separator) + 1, parent.lastIndexOf(46));
            Arrays.sort(listOfFiles);
            for (int i = 0; i < listOfFiles.length; ++i) {
                String fileName = ((File)listOfFiles[i]).getName();
                if (!fileName.startsWith(basePrefix)) continue;
                String timepointString = fileName.substring(fileName.indexOf(TIME_PREFIX) + TIME_PREFIX.length(), fileName.indexOf(TIME_SUFFIX));
                int currentTimepoint = DataTools.parseInteger(timepointString);
                Object[] innerFileList = ((File)listOfFiles[i]).listFiles();
                Arrays.sort(innerFileList);
                for (int j = 0; j < innerFileList.length; ++j) {
                    String innerFileName = ((File)innerFileList[j]).getName();
                    if (!innerFileName.contains(PROJECTION_PREFIX.substring(0, PROJECTION_PREFIX.length() - 1))) continue;
                    String channelNumString = innerFileName.substring(innerFileName.indexOf(CHANNEL_PREFIX) + CHANNEL_PREFIX.length(), innerFileName.indexOf(46));
                    int currentChannelNum = DataTools.parseInteger(channelNumString);
                    int channelIndex = this.channels.indexOf(currentChannelNum);
                    if (innerFileName.indexOf(PROJECTION_PREFIX) >= 0) {
                        String projection = innerFileName.substring(innerFileName.indexOf(PROJECTION_PREFIX) + PROJECTION_PREFIX.length(), innerFileName.indexOf(PROJECTION_SUFFIX));
                        if (!SERIES_PREFIXES.contains(projection)) continue;
                        if (this.filelist.get(projection) == null) {
                            this.filelist.put(projection, new String[sizeT][sizeC]);
                            this.core.add(new CoreMetadata((IFormatReader)this, 0));
                        }
                        this.filelist.get((Object)projection)[currentTimepoint][channelIndex] = ((File)innerFileList[j]).getAbsolutePath();
                        if (currentTimepoint != 0 || channelIndex != 0) continue;
                        this.in.close();
                        this.in = new RandomAccessInputStream(((File)innerFileList[j]).getAbsolutePath());
                        ArrayList<String> stringsList = new ArrayList<String>(this.filelist.keySet());
                        this.readHeader((CoreMetadata)this.core.get(stringsList.indexOf(projection)));
                        continue;
                    }
                    this.filelist.get((Object)DEFAULT_SERIES)[currentTimepoint][channelIndex] = ((File)innerFileList[j]).getAbsolutePath();
                    if (currentTimepoint != 0 || channelIndex != 0) continue;
                    this.in.close();
                    this.in = new RandomAccessInputStream(((File)innerFileList[j]).getAbsolutePath());
                    this.readHeader((CoreMetadata)this.core.get(0));
                }
            }
        } else {
            String absolutePath;
            this.filelist.put(DEFAULT_SERIES, new String[1][1]);
            this.filelist.get((Object)DEFAULT_SERIES)[0][0] = absolutePath = new Location(id).getAbsolutePath();
            this.in.close();
            this.in = new RandomAccessInputStream(absolutePath);
            this.readHeader((CoreMetadata)this.core.get(0));
        }
        MetadataTools.populatePixels((MetadataStore)this.store, (IFormatReader)this);
    }

    private void readHeader(CoreMetadata coreMeta) throws IOException, FormatException {
        int i;
        this.headerVersion = this.in.readUnsignedByte();
        coreMeta.littleEndian = true;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.dims_xyzct[i2] = this.readUInt32();
        }
        coreMeta.dimensionOrder = "XYZCT";
        coreMeta.sizeX = this.dims_xyzct[0];
        coreMeta.sizeY = this.dims_xyzct[1];
        coreMeta.sizeZ = this.dims_xyzct[2];
        if (!this.isGroupFiles() && this.filelist.size() > 1) {
            coreMeta.sizeC = this.dims_xyzct[3];
            coreMeta.sizeT = this.dims_xyzct[4];
        } else {
            coreMeta.sizeT = this.filelist.get(DEFAULT_SERIES).length;
            coreMeta.sizeC = this.filelist.get(DEFAULT_SERIES)[0].length;
        }
        coreMeta.imageCount = coreMeta.sizeZ * coreMeta.sizeC * coreMeta.sizeT;
        PositiveFloat[] dims_pixelSize = new PositiveFloat[5];
        for (int i3 = 0; i3 < 5; ++i3) {
            dims_pixelSize[i3] = this.readFloat32();
        }
        this.store.setPixelsPhysicalSizeX(FormatTools.createLength((PrimitiveNumber)dims_pixelSize[0], (Unit)UNITS.MICROMETER), 0);
        this.store.setPixelsPhysicalSizeY(FormatTools.createLength((PrimitiveNumber)dims_pixelSize[1], (Unit)UNITS.MICROMETER), 0);
        this.store.setPixelsPhysicalSizeZ(FormatTools.createLength((PrimitiveNumber)dims_pixelSize[2], (Unit)UNITS.MICROMETER), 0);
        int dataType = this.in.readUnsignedByte();
        this.convertPixelType(coreMeta, dataType);
        this.compressionType = this.in.readUnsignedByte();
        byte[] user_metadata = new byte[256];
        this.in.read(user_metadata);
        for (i = 0; i < 5; ++i) {
            this.dims_blockSize[i] = this.readUInt32();
        }
        this.blocksPerPlane = (int)(Math.ceil((float)coreMeta.sizeX / (float)this.dims_blockSize[0]) * Math.ceil((float)coreMeta.sizeY / (float)this.dims_blockSize[1]));
        this.numBlocks = 1.0;
        for (i = 0; i < 5; ++i) {
            this.numBlocks *= Math.ceil((float)this.dims_xyzct[i] / (float)this.dims_blockSize[i]);
        }
        this.headerSize = (long)(62.0 + this.numBlocks * 8.0 + 256.0 + 1.0);
        this.blockOffsets = new long[this.blocksPerPlane];
        this.offsetFilePointer = this.in.getFilePointer();
        for (i = 0; i < this.blocksPerPlane; ++i) {
            this.blockOffsets[i] = this.readUInt64();
        }
    }

    public String[] getUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        String[] completeFileList = new String[this.getSizeT() * this.getSizeC() * this.filelist.size()];
        int index = 0;
        for (String seriesKey : this.filelist.keySet()) {
            String[][] seriesFiles = this.filelist.get(seriesKey);
            for (int timepoint = 0; timepoint < this.getSizeT(); ++timepoint) {
                for (int channel = 0; channel < this.getSizeC(); ++channel) {
                    completeFileList[index] = seriesFiles[timepoint][channel];
                    ++index;
                }
            }
        }
        return noPixels ? ArrayUtils.EMPTY_STRING_ARRAY : completeFileList;
    }

    private void reCalculateBlockOffsets(int no) throws IOException, FormatException {
        int i;
        LOGGER.debug("Beginning calulating offsets for plane : " + no);
        this.headerVersion = this.in.readUnsignedByte();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.dims_xyzct[i2] = this.readUInt32();
        }
        PositiveFloat[] dims_pixelSize = new PositiveFloat[5];
        for (int i3 = 0; i3 < 5; ++i3) {
            dims_pixelSize[i3] = this.readFloat32();
        }
        int dataType = this.in.readUnsignedByte();
        this.compressionType = this.in.readUnsignedByte();
        byte[] user_metadata = new byte[256];
        this.in.read(user_metadata);
        for (i = 0; i < 5; ++i) {
            this.dims_blockSize[i] = this.readUInt32();
        }
        this.blocksPerPlane = (int)(Math.ceil((float)this.getSizeX() / (float)this.dims_blockSize[0]) * Math.ceil((float)this.getSizeY() / (float)this.dims_blockSize[1]));
        this.numBlocks = 1.0;
        for (i = 0; i < 5; ++i) {
            this.numBlocks *= Math.ceil((float)this.dims_xyzct[i] / (float)this.dims_blockSize[i]);
        }
        this.headerSize = (long)(62.0 + this.numBlocks * 8.0 + 256.0 + 1.0);
        String order = ((CoreMetadata)this.core.get((int)this.getSeries())).dimensionOrder;
        int[] ztc = FormatTools.getZCTCoords((String)order, (int)this.getSizeZ(), (int)this.getSizeC(), (int)this.getSizeT(), (int)this.getImageCount(), (int)no);
        int requiredBlockNum = ztc[0] / this.dims_blockSize[2];
        long filePoointer = this.in.getFilePointer();
        this.blockOffsets = new long[this.blocksPerPlane + 1];
        this.in.seek(this.offsetFilePointer + (long)(requiredBlockNum * this.blocksPerPlane * 8));
        for (int i4 = 0; i4 < this.blocksPerPlane; ++i4) {
            this.blockOffsets[i4 + 1] = this.readUInt64();
        }
        if (requiredBlockNum > 0) {
            this.in.seek(this.offsetFilePointer + (long)(requiredBlockNum * this.blocksPerPlane * 8) - 8L);
            this.blockOffsets[0] = this.readUInt64();
        } else {
            this.blockOffsets[0] = 0L;
        }
        this.in.seek(filePoointer);
    }

    private void convertPixelType(CoreMetadata ms0, int pixelType) throws FormatException {
        switch (pixelType) {
            case 0: {
                ms0.pixelType = 1;
                break;
            }
            case 1: {
                ms0.pixelType = 3;
                break;
            }
            case 2: {
                ms0.pixelType = 5;
                break;
            }
            case 3: 
            case 7: {
                ms0.pixelType = 7;
                break;
            }
            case 4: {
                ms0.pixelType = 0;
                break;
            }
            case 5: {
                ms0.pixelType = 2;
                break;
            }
            case 6: {
                ms0.pixelType = 4;
                break;
            }
            case 8: 
            case 9: {
                ms0.pixelType = 6;
                break;
            }
            default: {
                throw new FormatException("Unknown pixel type: " + pixelType);
            }
        }
        ms0.interleaved = ms0.rgb;
    }

    private int readUInt32() throws IOException {
        byte[] b = new byte[4];
        this.in.read(b, 0, 4);
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        return bb.getInt();
    }

    private long readUInt64() throws IOException {
        byte[] b = new byte[8];
        this.in.read(b, 0, 8);
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        return bb.getLong();
    }

    private PositiveFloat readFloat32() throws IOException {
        byte[] b = new byte[4];
        this.in.read(b, 0, 4);
        ByteBuffer bb = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        return new PositiveFloat(Double.valueOf(bb.getFloat()));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 1;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.filelist.clear();
        Arrays.fill(this.dims_blockSize, 0);
        Arrays.fill(this.dims_xyzct, 0);
        this.blockOffsets = null;
        this.compressionType = 0;
        this.numBlocks = 1.0;
        this.headerSize = 0L;
        this.blocksPerPlane = 0;
        this.offsetFilePointer = 0L;
        this.headerVersion = 0;
    }
}

