/*
 * Decompiled with CFR 0.152.
 */
package ome.services.mail;

import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class MailUtil {
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    private static final long serialVersionUID = -1L;
    protected final String sender;
    protected final JavaMailSender mailSender;

    public MailUtil(String sender, JavaMailSender mailSender) {
        if (StringUtils.isBlank((String)sender)) {
            log.error("omero.mail.from is empty. Email notification won't be sent.");
        }
        this.sender = sender;
        this.mailSender = mailSender;
        log.info("JavaMail version is {}", (Object)InternetAddress.class.getPackage().getImplementationVersion());
    }

    public String getSender() {
        return this.sender;
    }

    public void sendEmail(final String from, final String to, final String topic, final String body, final boolean html, final List<String> ccrecipients, final List<String> bccrecipients) {
        MimeMessagePreparator preparator = new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MimeMessageHelper message = new MimeMessageHelper(mimeMessage);
                message.setText(body, html);
                message.setFrom(from);
                message.setSubject(topic);
                message.setTo(to);
                if (ccrecipients != null && !ccrecipients.isEmpty()) {
                    message.setCc(ccrecipients.toArray(new String[ccrecipients.size()]));
                }
                if (bccrecipients != null && !bccrecipients.isEmpty()) {
                    message.setCc(bccrecipients.toArray(new String[bccrecipients.size()]));
                }
            }
        };
        this.mailSender.send(preparator);
    }

    public void sendEmail(String to, String topic, String body, boolean html, List<String> ccrecipients, List<String> bccrecipients) {
        this.sendEmail(this.sender, to, topic, body, html, ccrecipients, bccrecipients);
    }

    public boolean validateEmail(String email) {
        boolean isValid = true;
        try {
            InternetAddress internetAddress = new InternetAddress(email);
            internetAddress.validate();
        }
        catch (AddressException e) {
            isValid = false;
        }
        return isValid;
    }
}

