/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions.stats;

import ome.services.sessions.stats.SessionStats;

public class DelegatingStats
implements SessionStats {
    private final SessionStats[] stats;

    public DelegatingStats() {
        this.stats = new SessionStats[0];
    }

    public DelegatingStats(SessionStats[] stats) {
        if (stats == null) {
            this.stats = new SessionStats[0];
        } else {
            this.stats = new SessionStats[stats.length];
            System.arraycopy(stats, 0, this.stats, 0, stats.length);
        }
    }

    protected SessionStats[] stats() {
        return this.stats;
    }

    @Override
    public void methodIn() {
        for (SessionStats stats : this.stats()) {
            stats.methodIn();
        }
    }

    @Override
    public long methodCount() {
        long count = 0L;
        for (SessionStats stats : this.stats()) {
            count = Math.max(count, stats.methodCount());
        }
        return count;
    }

    @Override
    public void methodOut() {
        for (SessionStats stats : this.stats()) {
            stats.methodOut();
        }
    }

    @Override
    public final void loadedObjects(int objects) {
        for (SessionStats stats : this.stats()) {
            stats.loadedObjects(objects);
        }
    }

    @Override
    public final void readBytes(int bytes) {
        for (SessionStats stats : this.stats()) {
            stats.readBytes(bytes);
        }
    }

    @Override
    public final void updatedObjects(int objects) {
        for (SessionStats stats : this.stats()) {
            stats.updatedObjects(objects);
        }
    }

    @Override
    public final void writtenBytes(int bytes) {
        for (SessionStats stats : this.stats()) {
            stats.writtenBytes(bytes);
        }
    }
}

