/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsPressure implements UnitEnum
{
    YOTTAPASCAL("YPa"),
    ZETTAPASCAL("ZPa"),
    EXAPASCAL("EPa"),
    PETAPASCAL("PPa"),
    TERAPASCAL("TPa"),
    GIGAPASCAL("GPa"),
    MEGAPASCAL("MPa"),
    KILOPASCAL("kPa"),
    HECTOPASCAL("hPa"),
    DECAPASCAL("daPa"),
    PASCAL("Pa"),
    DECIPASCAL("dPa"),
    CENTIPASCAL("cPa"),
    MILLIPASCAL("mPa"),
    MICROPASCAL("\u00b5Pa"),
    NANOPASCAL("nPa"),
    PICOPASCAL("pPa"),
    FEMTOPASCAL("fPa"),
    ATTOPASCAL("aPa"),
    ZEPTOPASCAL("zPa"),
    YOCTOPASCAL("yPa"),
    BAR("bar"),
    MEGABAR("Mbar"),
    KILOBAR("kbar"),
    DECIBAR("dbar"),
    CENTIBAR("cbar"),
    MILLIBAR("mbar"),
    ATMOSPHERE("atm"),
    PSI("psi"),
    TORR("Torr"),
    MILLITORR("mTorr"),
    MMHG("mm Hg");

    private static final Map<String, UnitsPressure> bySymbol;
    protected String symbol;

    private UnitsPressure(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsPressure bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsPressure>();
        for (UnitsPressure t : UnitsPressure.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

