/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer;

import ch.qos.logback.classic.Level;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import loci.formats.FormatTools;
import ome.formats.OMEROMetadataStoreClient;
import ome.formats.importer.targets.ImportTarget;
import ome.formats.importer.targets.TargetBuilder;
import ome.formats.importer.util.IniFileLoader;
import ome.system.UpgradeCheck;
import omero.model.Annotation;
import omero.model.NamedValue;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportConfig {
    private static final Logger log = LoggerFactory.getLogger(ImportConfig.class);
    private static final String DATASET_CLASS = "omero.model.Dataset";
    private static final String SCREEN_CLASS = "omero.model.Screen";
    public static final String SERVER_NAME_SEPARATOR = ",";
    public static final String READERS_KEY = "omero.import.readers";
    private final Preferences prefs;
    private final IniFileLoader ini;
    private final Properties props;
    private String omeroVersion = "Unknown";
    public final StrValue agent;
    public final StrValue hostname;
    public final StrValue username;
    public final StrValue password;
    public final IntValue port;
    public final LongValue savedProject;
    public final LongValue savedDataset;
    public final LongValue savedScreen;
    public final StrValue sessionKey;
    public final LongValue group;
    public final BoolValue doThumbnails;
    public final BoolValue noStatsInfo;
    public final StrValue email;
    public final StrValue userSpecifiedName;
    public final StrValue userSpecifiedDescription;
    @Deprecated
    public final StrValue targetClass;
    @Deprecated
    public final LongValue targetId;
    public final StrValue target;
    public final BoolValue debug;
    public final BoolValue contOnError;
    public final BoolValue sendReport;
    public final BoolValue sendFiles;
    public final BoolValue sendLogFile;
    public final IntValue parallelUpload;
    public final IntValue parallelFileset;
    public final StrValue qaBaseURL;
    public final BoolValue checkUpgrade;
    public final BoolValue useCustomImageNaming;
    @Deprecated
    public final BoolValue useFullPath;
    public final IntValue numOfDirectories;
    public final FileValue savedDirectory;
    public final StrValue readersPath;
    public final StrValue checksumAlgorithm;
    public final BoolValue encryptedConnection;
    public final BoolValue autoClose;
    public final IntValue keepAlive;
    public final AnnotationListValue annotations;
    public final DoubleArrayValue userPixels;
    public static final String DEFAULT_QABASEURL = "http://qa.openmicroscopy.org.uk/qa";

    private static Preferences prefs() {
        Preferences prefs = Preferences.userNodeForPackage(ImportConfig.class);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            log.error("Error flushing preferences");
        }
        return prefs;
    }

    public ImportConfig() {
        this(null);
    }

    public ImportConfig(File configFile) {
        this(ImportConfig.prefs(), new IniFileLoader(configFile), System.getProperties());
    }

    public ImportConfig(Preferences prefs, IniFileLoader ini, Properties props) {
        this.prefs = prefs;
        this.props = props;
        this.ini = ini;
        this.omeroVersion = ImportConfig.class.getPackage().getImplementationVersion();
        log.info("OMERO.blitz Version: " + this.omeroVersion);
        if (ini != null) {
            ini.updateFlexReaderServerMaps();
        }
        log.info("Bioformats " + this.getBioFormatsVersion());
        this.agent = new StrValue("agent", this, "importer");
        this.hostname = new StrValue("hostname", this, "omero.host");
        this.username = new StrValue("username", this, "omero.name");
        this.password = new StrValue("password", this, "omero.pass");
        this.port = new IntValue("port", this, 4064, "omero.port"){

            @Override
            public synchronized void load() {
                super.load();
                if (this._current.compareAndSet(null, (Integer)this._default)) {
                    log.debug("Replacing port load value with default");
                }
            }
        };
        this.sessionKey = new StrValue("session", this);
        this.group = new LongValue("group", this, null);
        this.doThumbnails = new BoolValue("doThumbnails", this, true);
        this.noStatsInfo = new BoolValue("noStatsInfo", this, false);
        this.email = new StrValue("email", this);
        this.qaBaseURL = new StrValue("qaBaseURL", this, DEFAULT_QABASEURL);
        this.checkUpgrade = new BoolValue("checkUpgrade", this, true);
        this.userSpecifiedName = new StrValue("userSpecifiedName", this);
        this.userSpecifiedDescription = new StrValue("userSpecifiedDescription", this);
        this.targetClass = new StrValue("targetClass", this);
        this.targetId = new LongValue("targetId", this, 0L);
        this.target = new StrValue("target", this);
        this.savedProject = new LongValue("savedProject", this, 0L);
        this.savedDataset = new LongValue("savedDataset", this, 0L);
        this.savedScreen = new LongValue("savedScreen", this, 0L);
        this.debug = new BoolValue("debug", this, false);
        this.contOnError = new BoolValue("contOnError", this, false);
        this.sendReport = new BoolValue("sendReport", this, false);
        this.sendFiles = new BoolValue("sendFiles", this, true);
        this.sendLogFile = new BoolValue("sendLogFile", this, true);
        this.parallelUpload = new IntValue("parallelUpload", this, 1);
        this.parallelFileset = new IntValue("parallelFileset", this, 1);
        this.useFullPath = new BoolValue("useFullPath", this, true);
        this.useCustomImageNaming = new BoolValue("overrideImageName", this, true);
        this.numOfDirectories = new IntValue("numOfDirectories", this, 0);
        this.savedDirectory = new FileValue("savedDirectory", this);
        this.encryptedConnection = new BoolValue("encryptedConnection", this, true);
        this.autoClose = new BoolValue("autoClose", this, false);
        this.keepAlive = new IntValue("keepAlive", this, 300);
        this.annotations = new AnnotationListValue("annotations", this, (List<Annotation>)new ArrayList<Annotation>());
        this.userPixels = new DoubleArrayValue("userPixels", this, null);
        this.readersPath = new StrValue("readersPath", this);
        this.checksumAlgorithm = new StrValue("checksumAlgorithm", this);
    }

    public String getBioFormatsVersion() {
        return String.format("version: %s revision: %s date: %s", FormatTools.VERSION, FormatTools.VCS_REVISION, FormatTools.DATE);
    }

    public String getOmeroVersion() {
        return this.omeroVersion;
    }

    public void fillVersionInfo(List<NamedValue> versionInfo) {
        HashMap<VersionInfo, String> properties = new HashMap<VersionInfo, String>();
        properties.put(VersionInfo.BIO_FORMATS_VERSION, this.getBioFormatsVersion());
        properties.put(VersionInfo.CLIENT_LANGUAGE_NAME, "Java");
        properties.put(VersionInfo.CLIENT_LANGUAGE_VENDOR, System.getProperty("java.vendor"));
        properties.put(VersionInfo.CLIENT_LANGUAGE_COMPILER, System.getProperty("java.compiler"));
        properties.put(VersionInfo.CLIENT_LANGUAGE_VERSION, System.getProperty("java.version"));
        properties.put(VersionInfo.LOCALE, Locale.getDefault().toString());
        properties.put(VersionInfo.OMERO_VERSION, this.getOmeroVersion());
        properties.put(VersionInfo.OS_NAME, System.getProperty("os.name"));
        properties.put(VersionInfo.OS_VERSION, System.getProperty("os.version"));
        properties.put(VersionInfo.OS_ARCHITECTURE, System.getProperty("os.arch"));
        for (Map.Entry property : properties.entrySet()) {
            if (!StringUtils.isNotEmpty((String)((String)property.getValue()))) continue;
            versionInfo.add(new NamedValue(((VersionInfo)((Object)property.getKey())).key, (String)property.getValue()));
        }
    }

    public void configureDebug(String levelString) {
        Level level = levelString == null ? Level.toLevel((int)this.ini.getDebugLevel()) : Level.toLevel((String)levelString);
        this.setLevel("ome.formats", level);
        this.setLevel("ome.services.blitz", level);
        this.setLevel("ome.system", level);
        this.setLevel("loci", level);
        this.setLevel("org.scijava.nativelib", level);
    }

    private void setLevel(String loggerName, Level level) {
        Logger logger = LoggerFactory.getLogger((String)loggerName);
        if (!(logger instanceof ch.qos.logback.classic.Logger)) {
            return;
        }
        ((ch.qos.logback.classic.Logger)logger).setLevel(level);
    }

    public OMEROMetadataStoreClient createStore() throws Exception {
        if (!this.canLogin()) {
            throw new RuntimeException("Can't create store. See canLogin()");
        }
        OMEROMetadataStoreClient client2 = new OMEROMetadataStoreClient();
        if (this.sessionKey.empty()) {
            client2.initialize((String)this.username.get(), (String)this.password.get(), (String)this.hostname.get(), (Integer)this.port.get(), (Long)this.group.get(), (Boolean)this.encryptedConnection.get(), (Integer)this.keepAlive.get());
        } else {
            client2.initialize((String)this.hostname.get(), (Integer)this.port.get(), (String)this.sessionKey.get(), (Boolean)this.encryptedConnection.get(), (Integer)this.keepAlive.get());
        }
        return client2;
    }

    public boolean isUpgradeNeeded() {
        ResourceBundle bundle = ResourceBundle.getBundle("omero-common");
        String url = bundle.getString("omero.upgrades.url");
        UpgradeCheck check = new UpgradeCheck(url, this.getVersionNumber(), (String)this.agent.get());
        check.run();
        return check.isUpgradeNeeded();
    }

    public boolean canLogin() {
        return (!this.username.empty() && !this.password.empty() || !this.sessionKey.empty()) && !this.hostname.empty();
    }

    public String getLogFile() {
        return this.ini.getLogFile();
    }

    public String getHomeUrl() {
        return this.ini.getHomeUrl();
    }

    public String getForumUrl() {
        return this.ini.getForumUrl();
    }

    public String getAppTitle() {
        return this.ini.getAppTitle();
    }

    public boolean getForceFileArchiveOn() {
        return this.ini.getForceFileArchiveOn();
    }

    public boolean getStaticDisableHistory() {
        return this.ini.getStaticDisableHistory();
    }

    public boolean getUserDisableHistory() {
        return this.ini.getUserDisableHistory();
    }

    public void setUserDisableHistory(boolean b) {
        this.ini.setUserDisableHistory(b);
    }

    public String getVersionNumber() {
        return this.omeroVersion;
    }

    public void setVersionNumber(String s) {
        this.omeroVersion = s;
    }

    public String getIniVersionNumber() {
        return this.ini.getVersionNumber();
    }

    public String getUserSettingsDirectory() {
        return this.ini.getUserSettingsDirectory();
    }

    public boolean getUseQuaqua() {
        return this.ini.getUseQuaqua();
    }

    public void setUseQuaqua(boolean b) {
        this.ini.setUseQuaqua(b);
    }

    public void setDebugLevel(int level) {
        this.ini.setDebugLevel(level);
    }

    public int getDebugLevel() {
        return this.ini.getDebugLevel();
    }

    public Rectangle getUIBounds() {
        return this.ini.getUIBounds();
    }

    public void setUIBounds(Rectangle bounds) {
        this.ini.setUIBounds(bounds);
    }

    public String getFeedbackUrl() {
        return this.qaBaseURL + "/upload_processing/";
    }

    public String getTokenUrl() {
        return this.qaBaseURL + "/initial/";
    }

    public String getUploaderUrl() {
        return this.qaBaseURL + "/upload_processing/";
    }

    @Deprecated
    public boolean getUserFullPath() {
        return this.ini.getUserFullPath();
    }

    @Deprecated
    public void setUserFullPath(boolean b) {
        this.ini.setUserFullPath(b);
    }

    public boolean getCustomImageNaming() {
        return this.ini.getCustomImageNaming();
    }

    public void setCustomImageNaming(boolean b) {
        this.ini.setCustomImageNaming(b);
    }

    public int getNumOfDirectories() {
        return this.ini.getNumOfDirectories();
    }

    public void setNumOfDirectories(int i) {
        this.ini.setNumOfDirectories(i);
    }

    protected <T> void prompt(Value<T> value, String prompt, boolean hide) {
        String v = value.toString();
        if (hide) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < v.length(); ++i) {
                sb.append("*");
            }
            v = sb.toString();
        }
        System.out.print(String.format("%s[%s]:", prompt, v));
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    String input;
                    if ((input = br.readLine()) == null || input.trim().equals("")) {
                        continue;
                    }
                    value.set(value.fromString(input));
                }
            }
            catch (IOException e) {
                log.error("IGNORING: ", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void requestFromUser() {
        if (this.hostname.empty()) {
            this.hostname.set(System.console().readLine("Hostname: ", new Object[0]));
        }
        if (this.sessionKey.empty()) {
            if (this.username.empty()) {
                this.username.set(System.console().readLine("Username: ", new Object[0]));
            }
            if (this.password.empty()) {
                this.password.set(new String(System.console().readPassword("Password: ", new Object[0])));
            }
        }
    }

    protected List<Value<?>> values() {
        ArrayList rv = new ArrayList();
        for (Field f : this.getClass().getFields()) {
            try {
                Object o = f.get(this);
                if (!(o instanceof Value)) continue;
                Value cv = (Value)o;
                rv.add(cv);
            }
            catch (Exception e) {
                log.debug("Error during field lookup: " + e);
            }
        }
        return rv;
    }

    public Map<String, String> map() {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (Value<?> cv : this.values()) {
            rv.put(cv.key, cv.toString());
        }
        return rv;
    }

    public void loadGui() {
        this.email.load();
    }

    public void saveGui() {
        this.email.store();
    }

    public void loadAll() {
        this.savedProject.load();
        this.savedDataset.load();
        this.savedScreen.load();
        this.useCustomImageNaming.load();
        this.useFullPath.load();
        this.numOfDirectories.load();
        this.savedDirectory.load();
        this.sendLogFile.load();
        this.sendFiles.load();
        this.sendReport.load();
        this.port.load();
    }

    public void saveAll() {
        this.savedProject.store();
        this.savedDataset.store();
        this.savedScreen.store();
        this.useCustomImageNaming.store();
        this.useFullPath.store();
        this.numOfDirectories.store();
        this.savedDirectory.store();
        this.sendLogFile.store();
        this.sendFiles.store();
        this.sendReport.store();
        try {
            this.prefs.flush();
            this.ini.flushPreferences();
        }
        catch (BackingStoreException e) {
            log.error(e.toString());
            throw new RuntimeException(e);
        }
    }

    public ImportTarget getTarget() {
        TargetBuilder builder = new TargetBuilder();
        if (this.target.get() != null) {
            ImportTarget t = builder.parse((String)this.target.get()).build();
            log.info("Using import target: {}", (Object)this.target);
            return t;
        }
        if (DATASET_CLASS.equals(this.targetClass.get())) {
            return builder.parse(String.format("%s:%s", DATASET_CLASS, this.targetId.get())).build();
        }
        if (SCREEN_CLASS.equals(this.targetClass.get())) {
            return builder.parse(String.format("%s:%s", SCREEN_CLASS, this.targetId.get())).build();
        }
        return null;
    }

    public static class FileValue
    extends Value<File> {
        public FileValue(String key, ImportConfig config) {
            super(key, config);
        }

        @Override
        protected File fromString(String arg0) {
            if (arg0 == null) {
                return null;
            }
            return new File(arg0);
        }

        @Override
        public File get() {
            File f = (File)super.get();
            if (f != null && f.exists()) {
                return f;
            }
            this.set(null);
            return null;
        }
    }

    public static class LongValue
    extends Value<Long> {
        public LongValue(String key, ImportConfig config, Long defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Long fromString(String arg0) {
            try {
                return Long.valueOf(arg0);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class IntValue
    extends Value<Integer> {
        public IntValue(String key, ImportConfig config, int defValue) {
            super(key, config, defValue);
        }

        public IntValue(String key, ImportConfig config, int defValue, String omeroKey) {
            super(key, config, defValue, omeroKey);
        }

        @Override
        protected Integer fromString(String arg0) {
            try {
                return Integer.valueOf(arg0);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    public static class BoolValue
    extends Value<Boolean> {
        public BoolValue(String key, ImportConfig config, boolean defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Boolean fromString(String arg0) {
            if (arg0 == null) {
                return null;
            }
            return Boolean.parseBoolean(arg0);
        }
    }

    public static class PassValue
    extends StrValue {
        public PassValue(String key, ImportConfig config) {
            super(key, config);
        }

        @Override
        public synchronized void store() {
            log.trace("Skipping password storage");
        }
    }

    public static class DoubleArrayValue
    extends Value<Double[]> {
        public DoubleArrayValue(String key, ImportConfig config, Double[] defValue) {
            super(key, config, defValue);
        }

        @Override
        protected Double[] fromString(String string) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static class AnnotationListValue
    extends Value<List<Annotation>> {
        public AnnotationListValue(String key, ImportConfig config, List<Annotation> defValue) {
            super(key, config, defValue);
        }

        @Override
        protected List<Annotation> fromString(String string) {
            throw new RuntimeException("Not implemented.");
        }
    }

    public static class StrValue
    extends Value<String> {
        public StrValue(String key, ImportConfig config) {
            super(key, config);
        }

        public StrValue(String key, ImportConfig config, String defValue) {
            super(key, config, defValue);
        }

        public StrValue(String key, ImportConfig config, String defValue, String omeroKey) {
            super(key, config, defValue, omeroKey);
        }

        @Override
        protected String fromString(String arg0) {
            return arg0;
        }

        @Override
        public boolean empty() {
            String s = (String)this.get();
            return s == null || s.length() == 0;
        }
    }

    public static abstract class Value<T> {
        final AtomicReference<T> _current = new AtomicReference();
        final String key;
        final String omeroKey;
        final Preferences prefs;
        final IniFileLoader ini;
        final Properties props;
        final T _default;
        Object which = null;

        Value(String key, ImportConfig config) {
            this(key, config, null, null);
        }

        Value(String key, ImportConfig config, T defValue) {
            this(key, config, defValue, null);
        }

        Value(String key, ImportConfig config, T defValue, String omeroKey) {
            this.key = key;
            this.omeroKey = omeroKey;
            this.ini = config.ini;
            this.prefs = config.prefs;
            this.props = config.props;
            this._default = defValue;
            this._current.set(null);
        }

        public T get() {
            if (this._current.get() == null) {
                return this._default;
            }
            return this._current.get();
        }

        public void set(T t) {
            this._current.set(t);
        }

        public String toString() {
            T t = this.get();
            if (t == null) {
                return "";
            }
            return t.toString();
        }

        public synchronized void store() {
            if (this.which instanceof Properties || this.which instanceof Preferences) {
                this.prefs.put(this.key, this.toString());
                log.debug("Saved " + this.key + " to " + this.prefs);
            } else if (this.which instanceof IniFileLoader) {
                log.debug("Saved " + this.key + " to " + this.ini);
            } else if (this.which == null && this.prefs != null) {
                this.prefs.put(this.key, this.toString());
                log.debug("Freshly saved " + this.key + " to " + this.prefs);
            } else {
                log.debug("WHICH:" + this.which);
            }
        }

        public synchronized void load() {
            if (this.empty() && this.props != null) {
                this.set(this.fromString(this.props.getProperty(this.key)));
                if (!this.empty()) {
                    this.which = this.props;
                    log.debug("Loaded " + this.key + " from " + this.props);
                    return;
                }
            }
            if (this.empty() && this.prefs != null) {
                this.set(this.fromString(this.prefs.get(this.key, "")));
                if (!this.empty()) {
                    this.which = this.prefs;
                    log.debug("Loaded " + this.key + " from " + this.prefs);
                    return;
                }
            }
            if (this.empty() && this.ini != null) {
                log.debug("Loaded " + this.key + " from " + this.ini);
            }
            if (this.empty()) {
                this.set(this._default);
                log.debug("Loaded " + this.key + " from default");
                this.which = null;
            }
        }

        public boolean empty() {
            return this.get() == null;
        }

        protected abstract T fromString(String var1);
    }

    public static enum VersionInfo {
        BIO_FORMATS_READER("bioformats.reader"),
        BIO_FORMATS_VERSION("bioformats.version"),
        CLIENT_LANGUAGE_NAME("client.language.name"),
        CLIENT_LANGUAGE_VENDOR("client.language.vendor"),
        CLIENT_LANGUAGE_COMPILER("client.language.compiler"),
        CLIENT_LANGUAGE_VERSION("client.language.version"),
        OMERO_VERSION("omero.version"),
        OS_NAME("os.name"),
        OS_VERSION("os.version"),
        OS_ARCHITECTURE("os.architecture"),
        LOCALE("locale");

        public final String key;

        private VersionInfo(String key) {
            this.key = key;
        }
    }
}

