/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMappingHints;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberByteifyerEnumFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

class HDF5CompoundMemberByteifyerEnumArrayFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerEnumArrayFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            return (clazz == HDF5EnumerationValueArray.class || clazz.isArray() && clazz.getComponentType().isEnum() || clazz == String[].class || clazz.isArray() && (Number.class.isAssignableFrom(clazz.getComponentType()) || clazz.getComponentType().isPrimitive() && clazz.getComponentType() != Boolean.TYPE)) && memberInfoOrNull.getType().getDataClass() == HDF5DataClass.ENUM;
        }
        return clazz == HDF5EnumerationValueArray.class || clazz.isArray() && clazz.getComponentType().isEnum();
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType compoundMemberInfoEnumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider) {
        HDF5EnumerationType enumTypeOrNull;
        String memberName = member.getMemberName();
        HDF5EnumerationType hDF5EnumerationType = enumTypeOrNull = member.tryGetEnumerationType() != null ? member.tryGetEnumerationType() : compoundMemberInfoEnumTypeOrNull;
        if (enumTypeOrNull == null) {
            if (fieldOrNull.getType().isArray() && fieldOrNull.getType().getComponentType().isEnum()) {
                Class<?> enumClass = fieldOrNull.getType().getComponentType();
                enumTypeOrNull = fileInfoProvider.getEnumType(ReflectionUtils.getEnumOptions(enumClass));
            } else {
                throw new HDF5JavaException("Enumeration type not known for member byteifyer.");
            }
        }
        int memberTypeLength = compoundMemberInfoOrNull != null ? compoundMemberInfoOrNull.getType().getNumberOfElements() : member.getMemberTypeLength();
        long storageTypeId = member.getStorageDataTypeId();
        long memberStorageTypeId = storageTypeId < 0L ? fileInfoProvider.getArrayTypeId(enumTypeOrNull.getStorageTypeId(), memberTypeLength) : storageTypeId;
        switch (accessType) {
            case FIELD: {
                if (fieldOrNull == null) {
                    throw new HDF5JavaException("No field for member " + memberName + ".");
                }
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memOffset, enumTypeOrNull, memberTypeLength, memberStorageTypeId, member.tryGetTypeVariant(), HDF5CompoundMemberByteifyerEnumFactory.getEnumReturnTypeFromField(fieldOrNull.getType()));
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memOffset, enumTypeOrNull, memberTypeLength, memberStorageTypeId, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memOffset, enumTypeOrNull, memberTypeLength, memberStorageTypeId, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memOffset, enumTypeOrNull, memberTypeLength, memberStorageTypeId, member.tryGetTypeVariant(), HDF5CompoundMappingHints.getEnumReturnType(member));
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, int memOffset, final HDF5EnumerationType enumType, final int memberTypeLength, final long memberStorageTypeId, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, enumType.getStorageForm().getStorageSize() * memberTypeLength, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return memberStorageTypeId;
            }

            @Override
            protected long getMemberNativeTypeId() {
                return -1L;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnumArray(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValueArray = HDF5CompoundMemberByteifyerEnumArrayFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, memberTypeLength, enumReturnType, field);
                field.set(obj, enumValueArray);
            }

            private HDF5EnumerationValueArray getEnumArray(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumArrayObj = field.get(obj);
                return HDF5CompoundMemberByteifyerEnumArrayFactory.getEnumArrayFromField(enumArrayObj, enumType, enumReturnType);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, int memOffset, final HDF5EnumerationType enumType, final int memberTypeLength, final long memberStorageTypeId, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize() * memberTypeLength, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return memberStorageTypeId;
            }

            @Override
            protected long getMemberNativeTypeId() {
                return -1L;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnumArray(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValueArray = HDF5CompoundMemberByteifyerEnumArrayFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, memberTypeLength, enumReturnType, null);
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, enumValueArray);
            }

            private HDF5EnumerationValueArray getEnumArray(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumArrayObj = HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                return HDF5CompoundMemberByteifyerEnumArrayFactory.guessEnumArray(enumArrayObj, enumType);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, int memOffset, final HDF5EnumerationType enumType, final int memberTypeLength, final long memberStorageTypeId, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize() * memberTypeLength, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return memberStorageTypeId;
            }

            @Override
            protected long getMemberNativeTypeId() {
                return -1L;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnumArray(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValueArray = HDF5CompoundMemberByteifyerEnumArrayFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, memberTypeLength, enumReturnType, null);
                HDF5CompoundByteifyerFactory.setList(obj, index, enumValueArray);
            }

            private HDF5EnumerationValueArray getEnumArray(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumArrayObj = HDF5CompoundByteifyerFactory.getList(obj, index);
                return HDF5CompoundMemberByteifyerEnumArrayFactory.guessEnumArray(enumArrayObj, enumType);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, int memOffset, final HDF5EnumerationType enumType, final int memberTypeLength, final long memberStorageTypeId, HDF5DataTypeVariant typeVariant, final HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        return new HDF5MemberByteifyer(null, memberName, enumType.getStorageForm().getStorageSize() * memberTypeLength, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return enumType.getStorageForm().getStorageSize();
            }

            @Override
            protected long getMemberStorageTypeId() {
                return memberStorageTypeId;
            }

            @Override
            protected long getMemberNativeTypeId() {
                return -1L;
            }

            @Override
            public byte[] byteify(long compoundDataTypeId, Object obj) throws IllegalAccessException {
                return this.getEnumArray(obj).toStorageForm();
            }

            @Override
            public void setFromByteArray(long compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                Object enumValueArray = HDF5CompoundMemberByteifyerEnumArrayFactory.getEnumValue(enumType, byteArr, arrayOffset + this.offsetInMemory, memberTypeLength, enumReturnType, null);
                HDF5CompoundByteifyerFactory.setArray(obj, index, enumValueArray);
            }

            private HDF5EnumerationValueArray getEnumArray(Object obj) throws IllegalAccessException, IllegalArgumentException {
                if (!$assertionsDisabled && obj == null) {
                    throw new AssertionError();
                }
                Object enumArrayObj = HDF5CompoundByteifyerFactory.getArray(obj, index);
                return HDF5CompoundMemberByteifyerEnumArrayFactory.guessEnumArray(enumArrayObj, enumType);
            }
        };
    }

    static HDF5EnumerationValueArray guessEnumArray(Object enumArrayObj, HDF5EnumerationType enumType) {
        if (enumArrayObj instanceof HDF5EnumerationValueArray) {
            return (HDF5EnumerationValueArray)enumArrayObj;
        }
        if (enumArrayObj instanceof int[]) {
            return new HDF5EnumerationValueArray(enumType, (int[])enumArrayObj);
        }
        if (enumArrayObj instanceof String[]) {
            return new HDF5EnumerationValueArray(enumType, (String[])enumArrayObj);
        }
        if (enumArrayObj.getClass().isArray() && enumArrayObj.getClass().getComponentType().isEnum()) {
            return new HDF5EnumerationValueArray(enumType, (Enum[])enumArrayObj);
        }
        String[] options = new String[Array.getLength(enumArrayObj)];
        int i = 0;
        while (i < options.length) {
            options[i] = Array.get(enumArrayObj, i).toString();
            ++i;
        }
        return new HDF5EnumerationValueArray(enumType, options);
    }

    static HDF5EnumerationValueArray getEnumArrayFromField(Object enumArrayObj, HDF5EnumerationType enumType, HDF5CompoundMappingHints.EnumReturnType enumReturnType) {
        switch (enumReturnType) {
            case HDF5ENUMERATIONVALUE: {
                return (HDF5EnumerationValueArray)enumArrayObj;
            }
            case STRING: {
                return new HDF5EnumerationValueArray(enumType, (String[])enumArrayObj);
            }
            case ORDINAL: {
                return new HDF5EnumerationValueArray(enumType, enumArrayObj);
            }
            case JAVAENUMERATION: {
                return new HDF5EnumerationValueArray(enumType, (Enum[])enumArrayObj);
            }
        }
        throw new Error("Unknown EnumReturnType " + (Object)((Object)enumReturnType));
    }

    static Object getEnumValue(HDF5EnumerationType enumType, byte[] byteArr, int arrayOffset, int length, HDF5CompoundMappingHints.EnumReturnType enumReturnType, Field fieldOrNull) {
        switch (enumReturnType) {
            case HDF5ENUMERATIONVALUE: {
                return HDF5EnumerationValueArray.fromStorageForm(enumType, byteArr, arrayOffset, length);
            }
            case STRING: {
                return HDF5EnumerationValueArray.fromStorageFormToStringArray(enumType, byteArr, arrayOffset, length);
            }
            case ORDINAL: {
                return HDF5EnumerationValueArray.fromStorageFormToIntArray(enumType, byteArr, arrayOffset, length);
            }
            case JAVAENUMERATION: {
                if (fieldOrNull == null) {
                    throw new HDF5JavaException("JAVAENUMERATIONTYPE only available with access type FIELD");
                }
                String[] values = HDF5EnumerationValueArray.fromStorageFormToStringArray(enumType, byteArr, arrayOffset, length);
                Class<?> enumClass = fieldOrNull.getType().getComponentType();
                Enum[] result = (Enum[])Array.newInstance(fieldOrNull.getType().getComponentType(), values.length);
                int i = 0;
                while (i < result.length) {
                    result[i] = HDF5CompoundMemberByteifyerEnumArrayFactory.getValue(enumClass, values[i]);
                    ++i;
                }
                return result;
            }
        }
        throw new Error("Unknown EnumReturnType " + (Object)((Object)enumReturnType));
    }

    private static Enum<?> getValue(Class<? extends Enum<?>> enumClass, String value) {
        return Enum.valueOf(enumClass.asSubclass(Enum.class), value);
    }
}

