/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.core.PlaneInfo;
import ome.model.display.ChannelBinding;
import ome.model.display.PlaneSlicingContext;
import ome.model.display.QuantumDef;
import ome.model.display.RenderingDef;
import ome.model.display.Thumbnail;
import ome.model.enums.AcquisitionMode;
import ome.model.enums.DimensionOrder;
import ome.model.enums.Family;
import ome.model.enums.PhotometricInterpretation;
import ome.model.enums.PixelsType;
import ome.model.enums.RenderingModel;
import ome.model.enums.UnitsLength;
import ome.model.enums.UnitsTime;
import ome.model.stats.StatsInfo;
import ome.model.units.Length;
import ome.model.units.Time;

public class ObjectFactory {
    public static OriginalFile createFile() {
        OriginalFile ofile = new OriginalFile();
        ofile.setName("testing");
        ofile.setPath("/dev/null");
        ofile.setHash("abc");
        ofile.setSize(1L);
        ofile.setMimetype("text/plain");
        return ofile;
    }

    public static Thumbnail createThumbnails(Pixels p) {
        Thumbnail t = new Thumbnail();
        t.setMimeType("txt");
        t.setSizeX(1);
        t.setSizeY(1);
        p.addThumbnail(t);
        return t;
    }

    public static Pixels createPixelGraph(Pixels example) {
        return ObjectFactory.createPixelGraphWithChannels(example, 1);
    }

    public static Channel createChannel(Channel example) {
        Channel ch = new Channel();
        LogicalChannel lc = new LogicalChannel();
        StatsInfo si = new StatsInfo();
        PhotometricInterpretation pi = new PhotometricInterpretation("RGB");
        lc.setPhotometricInterpretation(pi);
        si.setGlobalMax(0.0);
        si.setGlobalMin(0.0);
        ch.setStatsInfo(si);
        ch.setLogicalChannel(lc);
        return ch;
    }

    public static Pixels createPixelGraphWithChannels(Pixels example, int channelCount) {
        int w;
        Pixels p = new Pixels();
        PhotometricInterpretation pi = new PhotometricInterpretation();
        AcquisitionMode mode = new AcquisitionMode();
        PixelsType pt = new PixelsType();
        DimensionOrder dO = new DimensionOrder();
        Image i = new Image();
        Channel[] c = new Channel[channelCount];
        LogicalChannel[] lc = new LogicalChannel[channelCount];
        StatsInfo[] si = new StatsInfo[channelCount];
        PlaneInfo[] pl = new PlaneInfo[channelCount];
        for (w = 0; w < channelCount; ++w) {
            c[w] = new Channel();
            lc[w] = new LogicalChannel();
            si[w] = new StatsInfo();
            pl[w] = new PlaneInfo();
        }
        if (example != null) {
            p.setId(example.getId());
            p.setVersion(example.getVersion());
            pt.setId(example.getPixelsType().getId());
            pt.unload();
            dO.setId(example.getDimensionOrder().getId());
            dO.unload();
            i.setId(example.getImage().getId());
            i.unload();
            for (w = 0; w < channelCount; ++w) {
                c[w].setId(example.getChannel(w).getId());
                c[w].unload();
            }
            p.addPlaneInfo(example.iteratePlaneInfo().next());
            p.iteratePlaneInfo().next().unload();
        } else {
            mode.setValue("Wide-field");
            pi.setValue("RGB");
            pt.setValue("int8");
            pt.setBitSize(8);
            dO.setValue("XYZTC");
            for (w = 0; w < channelCount; ++w) {
                c[w].setPixels(p);
                lc[w].setPhotometricInterpretation(pi);
                si[w].setGlobalMax(0.0);
                si[w].setGlobalMin(0.0);
                c[w].setLogicalChannel(lc[w]);
                c[w].setStatsInfo(si[w]);
                pl[w].setTheC(w);
                pl[w].setTheZ(0);
                pl[w].setTheT(0);
                Time deltaT = new Time(0.0, UnitsTime.SECOND);
                pl[w].setDeltaT(deltaT);
                p.addPlaneInfo(pl[w]);
            }
            i.setName("test");
            i.addPixels(p);
        }
        Length mm1 = new Length(1.0, UnitsLength.MILLIMETER);
        p.setSizeX(1);
        p.setSizeY(1);
        p.setSizeZ(1);
        p.setSizeC(1);
        p.setSizeT(1);
        p.setPhysicalSizeX(mm1);
        p.setPhysicalSizeY(mm1);
        p.setPhysicalSizeZ(mm1);
        p.setSha1("09bc7b2dcc9a510f4ab3a40c47f7a4cb77954356");
        p.setPixelsType(pt);
        p.setDimensionOrder(dO);
        p.setImage(i);
        for (int w2 = 0; w2 < channelCount; ++w2) {
            p.addChannel(c[w2]);
        }
        return p;
    }

    public static ChannelBinding createChannelBinding() {
        Family family = new Family();
        family.setValue("linear");
        ChannelBinding binding = new ChannelBinding();
        binding.setActive(Boolean.FALSE);
        binding.setCoefficient(1.0);
        binding.setAlpha(1);
        binding.setBlue(1);
        binding.setGreen(1);
        binding.setRed(1);
        binding.setFamily(family);
        binding.setInputEnd(1.0);
        binding.setInputStart(1.0);
        binding.setNoiseReduction(Boolean.FALSE);
        return binding;
    }

    public static RenderingDef createRenderingDef() {
        RenderingModel model = new RenderingModel();
        model.setValue("rgb");
        QuantumDef qdef = new QuantumDef();
        qdef.setBitResolution(1);
        qdef.setCdEnd(1);
        qdef.setCdStart(1);
        RenderingDef def = new RenderingDef();
        def.setDefaultT(1);
        def.setDefaultZ(1);
        def.setModel(model);
        def.setPixels(ObjectFactory.createPixelGraph(null));
        def.setQuantization(qdef);
        return def;
    }

    public static PlaneSlicingContext createPlaneSlicingContext() {
        PlaneSlicingContext enhancement = new PlaneSlicingContext();
        enhancement.setConstant(Boolean.FALSE);
        enhancement.setLowerLimit(1);
        enhancement.setPlanePrevious(1);
        enhancement.setPlaneSelected(1);
        enhancement.setUpperLimit(1);
        return enhancement;
    }
}

