/*
 * Decompiled with CFR 0.152.
 */
package ome.util.search;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ome.util.search.InvalidQueryException;

public class LuceneQueryBuilder {
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    public static final String DATE_IMPORT = "details.creationEvent.time";
    public static final String DATE_ACQUISITION = "acquisitionDate";
    private static final List<String> WILD_CARDS = new ArrayList<String>();
    private static final List<String> NO_BREAK;

    public static String buildLuceneQuery(List<String> fields, Date from, Date to, String dateType, String input) throws InvalidQueryException {
        StringBuilder result = new StringBuilder();
        String basicQuery = LuceneQueryBuilder.buildLuceneQuery(fields, input);
        if (from == null && to == null) {
            return basicQuery;
        }
        if (basicQuery != null && basicQuery.trim().length() > 0) {
            result.append("(" + basicQuery + ")");
        } else {
            result.append(basicQuery);
        }
        String dateFrom = LuceneQueryBuilder.beginOfTime();
        String dateTo = LuceneQueryBuilder.tomorrow();
        if (from != null) {
            dateFrom = DATEFORMAT.format(from);
        }
        if (to != null) {
            dateTo = DATEFORMAT.format(LuceneQueryBuilder.addOneDay(to));
        }
        if (result.length() > 0) {
            result.append(" AND " + dateType + ":[" + dateFrom + " TO " + dateTo + "]");
        } else {
            result.append(dateType + ":[" + dateFrom + " TO " + dateTo + "]");
        }
        return result.toString();
    }

    public static String buildLuceneQuery(List<String> fields, String input) throws InvalidQueryException {
        StringBuilder result = new StringBuilder();
        input = LuceneQueryBuilder.replaceNonAlphaNummeric(input);
        List<String> terms = LuceneQueryBuilder.split(input);
        if (fields != null && !fields.isEmpty()) {
            terms = LuceneQueryBuilder.attachFields(fields, terms);
        }
        terms = LuceneQueryBuilder.assembleAndClauses(terms);
        for (String term : terms) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(term);
        }
        return result.toString().trim();
    }

    private static List<String> attachFields(List<String> fields, List<String> terms) {
        ArrayList<String> result = new ArrayList<String>();
        for (String term : terms) {
            if (term.equals("AND")) {
                result.add(term);
                continue;
            }
            if (term.indexOf(58) == -1) {
                String newTerm = "";
                for (String field : fields) {
                    if (newTerm.length() > 0) {
                        newTerm = newTerm + " ";
                    }
                    newTerm = newTerm + field + ":" + term;
                }
                result.add(newTerm);
                continue;
            }
            result.add(term);
        }
        return result;
    }

    private static String replaceNonAlphaNummeric(String s) {
        char[] result = new char[s.length()];
        boolean insideQuotes = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                insideQuotes = !insideQuotes;
                result[i] = c;
                continue;
            }
            result[i] = !insideQuotes && !Character.isLetterOrDigit(c) && !WILD_CARDS.contains("" + c) && !NO_BREAK.contains("" + c) ? 32 : c;
        }
        return new String(result);
    }

    private static boolean isWildcardOnly(String s) {
        return s.matches("[\\*\\?\\~]+");
    }

    private static List<String> assembleAndClauses(List<String> terms) throws InvalidQueryException {
        ArrayList<String> result = new ArrayList<String>();
        if (terms == null || terms.isEmpty()) {
            return Collections.emptyList();
        }
        if (terms.size() == 1) {
            if (terms.get(0).equals("AND")) {
                throw new InvalidQueryException("AND expression must be followed by a search term!");
            }
            return Collections.singletonList(terms.get(0));
        }
        ArrayList<String> andTerms = new ArrayList<String>();
        boolean withinAndTerm = false;
        for (int i = 0; i < terms.size(); ++i) {
            String term = terms.get(i);
            if (i < terms.size() - 1) {
                String next = terms.get(i + 1);
                if (next.equals("AND")) {
                    andTerms.add(term);
                    withinAndTerm = true;
                    ++i;
                    continue;
                }
                if (withinAndTerm) {
                    andTerms.add(term);
                    withinAndTerm = false;
                    continue;
                }
                if (!andTerms.isEmpty()) {
                    result.add(LuceneQueryBuilder.concatenateAndTerms(andTerms));
                    andTerms.clear();
                }
                result.add(term);
                continue;
            }
            if (withinAndTerm) {
                andTerms.add(term);
                withinAndTerm = false;
                continue;
            }
            if (!term.equals("AND")) {
                result.add(term);
                continue;
            }
            throw new InvalidQueryException("AND expression must be followed by a search term!");
        }
        if (!andTerms.isEmpty()) {
            result.add(LuceneQueryBuilder.concatenateAndTerms(andTerms));
        }
        return result;
    }

    private static String concatenateAndTerms(List<String> terms) {
        String result = "(";
        for (String t : terms) {
            if (result.length() > 1) {
                result = result + " AND ";
            }
            result = result + "(" + t + ")";
        }
        return result + ")";
    }

    private static List<String> split(String input) {
        String regex = "\"([^\"]*)\"|(\\S+)";
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(input);
        while (m.find()) {
            String s = m.group(1);
            if (s != null) {
                result.add("\"" + s.trim() + "\"");
                continue;
            }
            s = m.group(2);
            if (LuceneQueryBuilder.isWildcardOnly(s)) continue;
            result.add(s.trim());
        }
        return result;
    }

    private static String tomorrow() {
        return DATEFORMAT.format(LuceneQueryBuilder.addOneDay(new Date()));
    }

    private static String beginOfTime() {
        return DATEFORMAT.format(new Date(0L));
    }

    private static Date addOneDay(Date date) {
        Calendar tmp = Calendar.getInstance();
        tmp.setTime(date);
        tmp.add(5, 1);
        return tmp.getTime();
    }

    static {
        WILD_CARDS.add("*");
        WILD_CARDS.add("?");
        WILD_CARDS.add("~");
        NO_BREAK = new ArrayList<String>();
        NO_BREAK.add("_");
        NO_BREAK.add("-");
        NO_BREAK.add(":");
    }
}

