/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.meta.MetadataRetrieve;

public class V3DrawWriter
extends FormatWriter {
    private long pixelOffset = 43L;
    private long lastPlane = -1L;
    private RandomAccessOutputStream pixels;
    private String outputOrder = "XYZCT";

    public V3DrawWriter() {
        super("Vaa3d", new String[]{"v3draw"});
    }

    public void setOutputOrder(String outputOrder) {
        this.outputOrder = outputOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (!this.isFullPlane(x, y, w, h)) {
            throw new FormatException("V3DRawWriter does not support writing tiles");
        }
        String formatkey = "raw_image_stack_by_hpeng";
        byte[] v2 = new byte[2];
        byte[] v4 = new byte[4];
        int[] sz = new int[4];
        this.checkParams(no, buf, x, y, w, h);
        if (this.pixels == null) {
            this.pixels = new RandomAccessOutputStream(this.currentId);
        }
        String endianString = "L";
        MetadataRetrieve meta = this.getMetadataRetrieve();
        boolean bigendian = false;
        if (meta.getPixelsBigEndian(this.series) != null) {
            bigendian = meta.getPixelsBigEndian(this.series);
        } else if (meta.getPixelsBinDataCount(this.series) == 0) {
            bigendian = meta.getPixelsBinDataBigEndian(this.series, 0);
        }
        endianString = !bigendian ? "L" : "B";
        int rgbChannels = this.getSamplesPerPixel();
        String order = meta.getPixelsDimensionOrder(this.series).getValue();
        int sizeZ = (Integer)meta.getPixelsSizeZ(this.series).getValue();
        int sizeC = meta.getChannelCount(this.series);
        if (rgbChannels <= sizeC) {
            sizeC /= rgbChannels;
        }
        int sizeT = (Integer)meta.getPixelsSizeT(this.series).getValue();
        int planes = sizeZ * sizeC * sizeT;
        int[] coords = FormatTools.getZCTCoords((String)order, (int)sizeZ, (int)sizeC, (int)sizeT, (int)planes, (int)no);
        int realIndex = FormatTools.getIndex((String)this.outputOrder, (int)sizeZ, (int)sizeC, (int)sizeT, (int)planes, (int)coords[0], (int)coords[1], (int)coords[2]);
        int sizeX = (Integer)meta.getPixelsSizeX(this.series).getValue();
        int sizeY = (Integer)meta.getPixelsSizeY(this.series).getValue();
        int pixelType = FormatTools.pixelTypeFromString((String)meta.getPixelsType(this.series).toString());
        int bytesPerPixel = FormatTools.getBytesPerPixel((int)pixelType);
        long planeSize = sizeX * sizeY * bytesPerPixel * rgbChannels;
        sz[0] = sizeX;
        sz[1] = sizeY;
        sz[2] = sizeZ * sizeT;
        sz[3] = sizeC * rgbChannels;
        if (!this.initialized[this.series][realIndex]) {
            this.initialized[this.series][realIndex] = true;
        }
        try {
            if (this.lastPlane == -1L) {
                this.pixels.write("raw_image_stack_by_hpeng".getBytes("UTF-8"));
                this.pixels.write(endianString.getBytes("UTF-8"));
                DataTools.unpackBytes(bytesPerPixel, v2, 0, 2, !bigendian);
                this.pixels.write(v2);
                for (int d : sz) {
                    DataTools.unpackBytes(d, v4, 0, 4, !bigendian);
                    this.pixels.write(v4);
                }
                this.pixels.write(buf);
                LOGGER.info("*********   V3DrawWriter.java internal variables  *********");
                LOGGER.info("bytesPerPixel = " + bytesPerPixel);
                LOGGER.info("pixelType = " + pixelType);
                LOGGER.info("rgbChannels =" + rgbChannels);
                LOGGER.info("sizeC = " + sizeC);
                LOGGER.info("sizeZ = " + sizeZ);
                LOGGER.info("sizeT = " + sizeT);
                LOGGER.info("endian= " + endianString);
            } else {
                this.pixels.seek(planeSize * (long)realIndex + this.pixelOffset);
                this.pixels.write(buf);
            }
            this.lastPlane = realIndex;
        }
        finally {
            this.pixels.close();
            this.pixels = null;
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        return new int[]{1, 3, 6};
    }

    public void setId(String id) throws FormatException, IOException {
        super.setId(id);
    }

    public void close() throws IOException {
        super.close();
        this.pixelOffset = 43L;
        this.lastPlane = -1L;
        if (this.pixels != null) {
            this.pixels.close();
        }
        this.pixels = null;
    }
}

