/*
 * Decompiled with CFR 0.152.
 */
package ome.io.bioformats;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.RomioPixelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BfPixelsWrapper {
    private static final Logger log = LoggerFactory.getLogger(BfPixelsWrapper.class);
    private final IFormatReader reader;
    private final String path;

    public BfPixelsWrapper(String path, IFormatReader reader) throws IOException, FormatException {
        this.path = path;
        this.reader = reader;
        reader.setFlattenedResolutions(false);
        try {
            reader.setId(path);
        }
        catch (IOException | RuntimeException | FormatException e) {
            reader.close();
            throw e;
        }
    }

    public byte[] getMessageDigest() throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        int sizeT = this.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            try {
                int size = RomioPixelBuffer.safeLongToInteger(this.getTimepointSize());
                byte[] buffer = new byte[size];
                this.getTimepoint(t, buffer);
                md.update(ByteBuffer.wrap(buffer));
                continue;
            }
            catch (DimensionsOutOfBoundsException e) {
                throw new RuntimeException(e);
            }
        }
        return md.digest();
    }

    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int sizeZ = this.getSizeZ();
        int sizeC = this.getSizeC();
        int sizeT = this.getSizeT();
        if (x != null && (x > sizeX - 1 || x < 0)) {
            throw new DimensionsOutOfBoundsException("X '" + x + "' greater than sizeX '" + sizeX + "'.");
        }
        if (y != null && (y > sizeY - 1 || y < 0)) {
            throw new DimensionsOutOfBoundsException("Y '" + y + "' greater than sizeY '" + sizeY + "'.");
        }
        if (z != null && (z > sizeZ - 1 || z < 0)) {
            throw new DimensionsOutOfBoundsException("Z '" + z + "' greater than sizeZ '" + sizeZ + "'.");
        }
        if (c != null && (c > sizeC - 1 || c < 0)) {
            throw new DimensionsOutOfBoundsException("C '" + c + "' greater than sizeC '" + sizeC + "'.");
        }
        if (t != null && (t > sizeT - 1 || t < 0)) {
            throw new DimensionsOutOfBoundsException("T '" + t + "' greater than sizeT '" + sizeT + "'.");
        }
    }

    private void checkCubeBounds(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        if (offset.size() != 5 || size.size() != 5 || step.size() != 5) {
            throw new DimensionsOutOfBoundsException("Invalid List length: each list must contain 5 elements XYZCT");
        }
        this.checkBounds(offset.get(0), offset.get(1), offset.get(2), offset.get(3), offset.get(4));
        this.checkBounds(offset.get(0) + size.get(0) - 1, offset.get(1) + size.get(1) - 1, offset.get(2) + size.get(2) - 1, offset.get(3) + size.get(3) - 1, offset.get(4) + size.get(4) - 1);
        if (step.get(0) < 1 || step.get(1) < 1 || step.get(2) < 1 || step.get(3) < 1 || step.get(4) < 1) {
            throw new DimensionsOutOfBoundsException("Invalid step size: steps sizes must be 1 or greater");
        }
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public long getId() {
        return 0L;
    }

    public String getPath() {
        return this.path;
    }

    public int getSizeC() {
        return this.reader.getSizeC();
    }

    public int getSizeT() {
        return this.reader.getSizeT();
    }

    public int getSizeX() {
        return this.reader.getSizeX();
    }

    public int getSizeY() {
        return this.reader.getSizeY();
    }

    public int getSizeZ() {
        return this.reader.getSizeZ();
    }

    public int getByteWidth() {
        return FormatTools.getBytesPerPixel((int)this.reader.getPixelType());
    }

    public Integer getRowSize() {
        return this.getSizeX() * this.getByteWidth();
    }

    public Integer getColSize() {
        return this.getSizeY() * this.getByteWidth();
    }

    public Long getPlaneSize() {
        return (long)this.getSizeY() * (long)this.getRowSize().intValue();
    }

    public Long getStackSize() {
        return (long)this.getSizeZ() * this.getPlaneSize();
    }

    public Long getTimepointSize() {
        return (long)this.getSizeC() * this.getStackSize();
    }

    public Long getTotalSize() {
        return (long)this.getSizeT() * this.getTimepointSize();
    }

    public Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        this.checkCubeBounds(offset, size, step);
        int tStripes = (size.get(4) + step.get(4) - 1) / step.get(4);
        int cStripes = (size.get(3) + step.get(3) - 1) / step.get(3);
        int zStripes = (size.get(2) + step.get(2) - 1) / step.get(2);
        int yStripes = (size.get(1) + step.get(1) - 1) / step.get(1);
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        long tileRowSize = (long)this.getByteWidth() * (long)xStripes;
        long cubeSize = tileRowSize * (long)yStripes * (long)zStripes * (long)cStripes * (long)tStripes;
        return cubeSize;
    }

    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, y, z, c, t);
        return this.getPlaneOffset(z, c, t) + (long)(y * this.getRowSize());
    }

    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, z, c, t);
        return this.getStackOffset(c, t) + (long)z.intValue() * this.getPlaneSize();
    }

    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, c, t);
        return this.getTimepointOffset(t) + (long)c.intValue() * this.getStackSize();
    }

    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, null, t);
        return (long)t.intValue() * this.getTimepointSize();
    }

    public byte[] getCol(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(x, null, z, c, t);
        try {
            if (buffer.length != this.getColSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            int size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
            byte[] plane = new byte[size];
            this.getWholePlane(z, c, t, plane);
            for (int y = 0; y < this.reader.getSizeY(); ++y) {
                System.arraycopy(plane, y * this.getRowSize() + x * this.getByteWidth(), buffer, y * this.getByteWidth(), this.getByteWidth());
            }
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getPlane(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, z, c, t);
        try {
            if ((long)buffer.length != this.getPlaneSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            this.getWholePlane(z, c, t, buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getPlaneRegion(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        return null;
    }

    public byte[] getRegion(Integer size, Long offset, byte[] buffer) throws IOException {
        return null;
    }

    public byte[] getRow(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, y, z, c, t);
        try {
            if (buffer.length != this.getRowSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            int size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
            byte[] plane = new byte[size];
            this.getWholePlane(z, c, t, plane);
            System.arraycopy(plane, y * this.getRowSize(), buffer, 0, this.getRowSize());
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getStack(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, c, t);
        try {
            if ((long)buffer.length != this.getStackSize()) {
                throw new RuntimeException("Buffer size incorrect.");
            }
            int size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
            byte[] plane = new byte[size];
            int sizeZ = this.getSizeZ();
            for (int z = 0; z < sizeZ; ++z) {
                this.getWholePlane(z, c, t, plane);
                System.arraycopy(plane, 0, buffer, z * size, size);
            }
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getTimepoint(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, null, t);
        if ((long)buffer.length != this.getTimepointSize()) {
            throw new RuntimeException("Buffer size incorrect.");
        }
        int size = RomioPixelBuffer.safeLongToInteger(this.getStackSize());
        byte[] stack = new byte[size];
        int sizeC = this.getSizeC();
        for (int c = 0; c < sizeC; ++c) {
            this.getStack(c, t, stack);
            System.arraycopy(stack, 0, buffer, c * size, size);
        }
        return buffer;
    }

    public byte[] getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if ((long)buffer.length != this.getHypercubeSize(offset, size, step)) {
            throw new RuntimeException("Buffer size incorrect.");
        }
        try {
            this.getWholeHypercube(offset, size, step, buffer);
        }
        catch (FormatException e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public byte[] getTile(int z, int c, int t, int x, int y, int w, int h, byte[] buffer) throws FormatException, IOException {
        return this.reader.openBytes(this.reader.getIndex(z, c, t), buffer, x, y, w, h);
    }

    private byte[] getWholePlane(int z, int c, int t, byte[] plane) throws IOException, FormatException {
        if (this.reader.getRGBChannelCount() == 1) {
            int planeNumber = this.reader.getIndex(z, c, t);
            this.reader.openBytes(planeNumber, plane);
        } else {
            int size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
            byte[] fullPlane = new byte[size * this.reader.getRGBChannelCount()];
            int planeNumber = this.reader.getIndex(z, 0, t);
            this.reader.openBytes(planeNumber, fullPlane);
            if (this.reader.isInterleaved()) {
                for (int p = 0; p < size; p += this.getByteWidth()) {
                    System.arraycopy(fullPlane, c * this.getByteWidth() + p * this.reader.getRGBChannelCount(), plane, p, this.getByteWidth());
                }
            } else {
                System.arraycopy(fullPlane, c * size, plane, 0, size);
            }
        }
        return plane;
    }

    private byte[] getWholeHypercube(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] cube) throws IOException, FormatException {
        int cubeOffset = 0;
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        int tileRowSize = this.getByteWidth() * xStripes;
        int planeSize = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
        byte[] plane = new byte[planeSize];
        for (int t = offset.get(4).intValue(); t < size.get(4) + offset.get(4); t += step.get(4).intValue()) {
            for (int c = offset.get(3).intValue(); c < size.get(3) + offset.get(3); c += step.get(3).intValue()) {
                for (int z = offset.get(2).intValue(); z < size.get(2) + offset.get(2); z += step.get(2).intValue()) {
                    this.getWholePlane(z, c, t, plane);
                    int rowOffset = offset.get(1) * this.getRowSize();
                    if (step.get(0) == 1) {
                        int byteOffset = rowOffset + offset.get(0) * this.getByteWidth();
                        for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                            System.arraycopy(plane, byteOffset, cube, cubeOffset, tileRowSize);
                            cubeOffset += tileRowSize;
                            byteOffset += this.getRowSize() * step.get(1);
                        }
                        continue;
                    }
                    for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                        int byteOffset = offset.get(0) * this.getByteWidth();
                        for (int x = offset.get(0).intValue(); x < size.get(0) + offset.get(0); x += step.get(0).intValue()) {
                            System.arraycopy(plane, rowOffset + byteOffset, cube, cubeOffset, this.getByteWidth());
                            cubeOffset += this.getByteWidth();
                            byteOffset += step.get(0) * this.getByteWidth();
                        }
                        rowOffset += this.getRowSize() * step.get(1);
                    }
                }
            }
        }
        return cube;
    }

    public String getPixelsType() {
        return FormatTools.getPixelTypeString((int)this.reader.getPixelType());
    }

    public boolean isFloat() {
        return FormatTools.isFloatingPoint((int)this.reader.getPixelType());
    }

    public boolean isSigned() {
        return FormatTools.isSigned((int)this.reader.getPixelType());
    }

    public boolean isLittleEndian() {
        return this.reader.isLittleEndian();
    }

    public byte[] swapIfRequired(byte[] bytes) throws FormatException, IOException {
        if (this.getByteWidth() == 1) {
            return bytes;
        }
        boolean isLittleEndian = this.reader.isLittleEndian();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        if (isLittleEndian) {
            if (this.getByteWidth() == 2) {
                ShortBuffer buf = buffer.asShortBuffer();
                int length = buffer.limit() / 2;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((short)buf.get(i)));
                }
            } else if (this.getByteWidth() == 4) {
                IntBuffer buf = buffer.asIntBuffer();
                int length = buffer.limit() / 4;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((int)buf.get(i)));
                }
            } else if (this.getByteWidth() == 8) {
                LongBuffer buf = buffer.asLongBuffer();
                int length = buffer.limit() / 8;
                for (int i = 0; i < length; ++i) {
                    buf.put(i, DataTools.swap((long)buf.get(i)));
                }
            } else {
                throw new FormatException(String.format("Unsupported sample bit width: %d", this.getByteWidth()));
            }
        }
        bytes = buffer.array();
        return bytes;
    }
}

