/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import ome.formats.importer.IObservable;
import ome.formats.importer.IObserver;
import ome.formats.importer.ImportEvent;
import ome.formats.importer.cli.ImportOutput;
import omero.model.IObject;
import omero.model.Pixels;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingImportMonitor
implements IObserver {
    private static Logger log = LoggerFactory.getLogger(LoggingImportMonitor.class);
    private final ImportSummary importSummary = new ImportSummary();
    private ImportOutput importOutput = ImportOutput.ids;

    public ImportOutput setImportOutput(ImportOutput importOutput) {
        ImportOutput old = importOutput;
        if (importOutput == null) {
            this.importOutput = ImportOutput.ids;
        }
        this.importOutput = importOutput;
        return old;
    }

    @Override
    public synchronized void update(IObservable importLibrary, ImportEvent event) {
        if (event instanceof ImportEvent.IMPORT_DONE) {
            ImportEvent.IMPORT_DONE ev = (ImportEvent.IMPORT_DONE)event;
            log.info(event.toLog());
            switch (this.importOutput) {
                case yaml: {
                    this.importSummary.outputYamlResults(ev);
                    break;
                }
                case legacy: {
                    this.importSummary.outputGreppableResults(ev);
                    break;
                }
                default: {
                    this.importSummary.outputImageOrPlateIds(ev);
                }
            }
            this.importSummary.update(ev);
        } else if (event instanceof ImportEvent.IMPORT_SUMMARY) {
            ImportEvent.IMPORT_SUMMARY ev = (ImportEvent.IMPORT_SUMMARY)event;
            this.importSummary.setTime(ev.importTime);
            this.importSummary.setErrors(ev.errorCount);
            this.importSummary.report();
        } else if (event instanceof ImportEvent.FILESET_UPLOAD_PREPARATION) {
            log.info(event.toLog());
        } else if (event instanceof ImportEvent.FILESET_UPLOAD_START) {
            log.info(event.toLog());
        } else if (event instanceof ImportEvent.FILESET_UPLOAD_END) {
            log.info(event.toLog());
        } else if (event instanceof ImportEvent.FILE_UPLOAD_STARTED) {
            ImportEvent.FILE_UPLOAD_STARTED ev = (ImportEvent.FILE_UPLOAD_STARTED)event;
            log.info(event.toLog() + ": " + ev.filename);
        } else if (event instanceof ImportEvent.FILE_UPLOAD_COMPLETE) {
            ImportEvent.FILE_UPLOAD_COMPLETE ev = (ImportEvent.FILE_UPLOAD_COMPLETE)event;
            log.info(event.toLog() + ": " + ev.filename);
            this.importSummary.update(ev);
        } else if (event instanceof ImportEvent.PROGRESS_EVENT) {
            log.info(event.toLog());
        } else if (log.isDebugEnabled()) {
            log.debug(event.toLog());
        }
    }

    private class ImportSummary {
        private static final String PLATE_CLASS = "PlateI";
        private int createdFilesets;
        private int createdPlates;
        private int errors;
        private int importedImages;
        private int uploadedFiles;
        private long time;

        private ImportSummary() {
        }

        public void update(ImportEvent.IMPORT_DONE event) {
            this.importedImages += event.pixels.size();
            ++this.createdFilesets;
            for (IObject object : event.objects) {
                if (!PLATE_CLASS.equals(object.getClass().getSimpleName())) continue;
                ++this.createdPlates;
            }
        }

        public void update(ImportEvent.FILE_UPLOAD_COMPLETE event) {
            ++this.uploadedFiles;
        }

        public void setErrors(int errors) {
            this.errors = errors;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void report() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n==> Summary\n");
            sb.append(this.entityCountToString("file", this.uploadedFiles));
            sb.append(" uploaded, ");
            sb.append(this.entityCountToString("fileset", this.createdFilesets));
            if (this.createdPlates != 0) {
                sb.append(", ");
                sb.append(this.entityCountToString("plate", this.createdPlates));
            }
            sb.append(" created, ");
            sb.append(this.entityCountToString("image", this.importedImages));
            sb.append(" imported, ");
            sb.append(this.entityCountToString("error", this.errors));
            sb.append(String.format(" in %s\n", DurationFormatUtils.formatDurationHMS((long)this.time)));
            System.err.print(sb.toString());
        }

        private String entityCountToString(String name, int count) {
            return String.format("%d %s%s", count, name, count != 1 ? "s" : "");
        }

        private ListMultimap<String, Long> getObjectIdMap(ImportEvent.IMPORT_DONE ev) {
            ArrayListMultimap collect = ArrayListMultimap.create();
            for (IObject object : ev.objects) {
                if (object == null || object.getId() == null) continue;
                String kls = object.getClass().getSimpleName();
                if (kls.endsWith("I")) {
                    kls = kls.substring(0, kls.length() - 1);
                }
                collect.put((Object)kls, (Object)object.getId().getValue());
            }
            return collect;
        }

        void otherImportedObjects(long fid, ListMultimap<String, Long> collect, String exclude) {
            System.err.println("Other imported objects:");
            System.err.println("Fileset:" + fid);
            for (String kls : collect.keySet()) {
                if (exclude != null && kls.equals(exclude)) continue;
                List ids = collect.get((Object)kls);
                for (Long id : ids) {
                    System.err.println(String.format("%s:%d", kls, id));
                }
            }
        }

        void outputGreppableResults(ImportEvent.IMPORT_DONE ev) {
            System.err.println("Imported pixels:");
            for (Pixels p : ev.pixels) {
                System.out.println(p.getId().getValue());
            }
            ListMultimap<String, Long> collect = this.getObjectIdMap(ev);
            this.otherImportedObjects(ev.fileset.getId().getValue(), collect, null);
        }

        void outputYamlResults(ImportEvent.IMPORT_DONE ev) {
            System.err.println("Imported objects:");
            System.out.println("---");
            System.out.println("- Fileset: " + ev.fileset.getId().getValue());
            ListMultimap<String, Long> collect = this.getObjectIdMap(ev);
            for (String kls : collect.keySet()) {
                List ids = collect.get((Object)kls);
                System.out.println(String.format("  %s: [%s]", kls, Joiner.on((String)",").join((Iterable)ids)));
            }
        }

        void outputImageOrPlateIds(ImportEvent.IMPORT_DONE ev) {
            ListMultimap<String, Long> collect = this.getObjectIdMap(ev);
            String kls = collect.containsKey((Object)"Plate") ? "Plate" : "Image";
            List ids = collect.get((Object)kls);
            System.out.println(String.format("%s:%s", kls, Joiner.on((String)",").join((Iterable)ids)));
            this.otherImportedObjects(ev.fileset.getId().getValue(), collect, kls);
        }
    }
}

