/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.importer.exclusions;

import ome.formats.importer.exclusions.ClientPathExclusion;
import ome.formats.importer.exclusions.FileExclusion;
import ome.formats.importer.exclusions.FilenameExclusion;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactoryImpl;
import omero.model.ChecksumAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileExclusion
implements FileExclusion {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static FileExclusion createExclusion(String arg) {
        Logger tmp = LoggerFactory.getLogger(AbstractFileExclusion.class);
        tmp.debug("Loading file exclusion class {}", (Object)arg);
        try {
            return (FileExclusion)Exclusion.valueOf((String)arg).kls.newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> c = Class.forName(arg);
                return (FileExclusion)c.newInstance();
            }
            catch (Exception e) {
                tmp.error("Failed to load file exclusion class " + arg);
                throw new RuntimeException(e);
            }
        }
    }

    protected String checksum(String filename, ChecksumAlgorithm checksumAlgorithm) {
        ChecksumProviderFactoryImpl checksumProviderFactory = new ChecksumProviderFactoryImpl();
        ChecksumProvider cp = checksumProviderFactory.getProvider(ChecksumAlgorithmMapper.getChecksumType(checksumAlgorithm));
        cp.putFile(filename);
        return cp.checksumAsString();
    }

    public static enum Exclusion {
        filename(FilenameExclusion.class),
        clientpath(ClientPathExclusion.class);

        Class<?> kls;

        private Exclusion(Class<?> kls) {
            this.kls = kls;
        }
    }
}

