/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.Iterator;
import java.util.List;
import ome.formats.model.ChannelData;
import ome.formats.model.UnitsFactory;
import omero.RInt;
import omero.model.Channel;
import omero.model.Filter;
import omero.model.Laser;
import omero.model.Length;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.TransmittanceRange;

public class ColorsFactory {
    public static final int RED_INDEX = 0;
    public static final int GREEN_INDEX = 1;
    public static final int BLUE_INDEX = 2;
    public static final int ALPHA_INDEX = 3;
    static final int DEFAULT_ALPHA = 255;
    private static final int BLUE_MIN = 400;
    private static final int BLUE_TO_GREEN_MIN = 500;
    private static final int GREEN_TO_RED_MIN = 560;
    private static final int RED_MAX = 700;
    private static final int RANGE = 15;

    private static boolean rangeBlue(double wavelength) {
        return wavelength < 500.0;
    }

    private static boolean rangeGreen(double wavelength) {
        return wavelength >= 500.0 && wavelength < 560.0;
    }

    private static boolean rangeRed(double wavelength) {
        return wavelength >= 560.0;
    }

    private static Integer getValue(RInt value) {
        return value == null ? null : Integer.valueOf(value.getValue());
    }

    private static boolean isFilterHasEmissionData(Filter f) {
        if (f == null) {
            return false;
        }
        TransmittanceRange transmittance = f.getTransmittanceRange();
        if (transmittance == null) {
            return false;
        }
        return transmittance.getCutIn() != null;
    }

    private static boolean hasEmissionExcitationData(ChannelData channelData, boolean full) {
        Laser laser;
        LightSource src;
        Filter f;
        Iterator<Filter> i;
        LogicalChannel lc = channelData.getLogicalChannel();
        if (lc == null) {
            return false;
        }
        if (lc.getEmissionWave() != null) {
            return true;
        }
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(i.next())) continue;
                return true;
            }
        }
        if (channelData.getFilterSet() != null && ColorsFactory.isFilterHasEmissionData(f = channelData.getFilterSetEmissionFilter())) {
            return true;
        }
        if (!full) {
            return false;
        }
        if (channelData.getLightSource() != null && (src = channelData.getLightSource()) instanceof Laser && (laser = (Laser)src).getWavelength() != null) {
            return true;
        }
        if (lc.getExcitationWave() != null) {
            return true;
        }
        filters = channelData.getLightPathExcitationFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                if (!ColorsFactory.isFilterHasEmissionData(i.next())) continue;
                return true;
            }
        }
        return channelData.getFilterSet() != null && ColorsFactory.isFilterHasEmissionData(f = channelData.getFilterSetExcitationFilter());
    }

    static Length getValueFromFilter(Filter filter, boolean emission) {
        Length v;
        if (filter == null) {
            return null;
        }
        TransmittanceRange transmittance = filter.getTransmittanceRange();
        if (transmittance == null) {
            return null;
        }
        Length cutIn = transmittance.getCutIn();
        if (emission) {
            if (cutIn == null) {
                return null;
            }
            return UnitsFactory.makeLength(cutIn.getValue() + 15.0, cutIn.getUnit());
        }
        Length cutOut = transmittance.getCutOut();
        if (cutOut == null) {
            return null;
        }
        if (cutIn == null || cutIn.getValue() == 0.0) {
            cutIn = UnitsFactory.makeLength(cutOut.getValue() - 30.0, cutOut.getUnit());
        }
        if ((v = UnitsFactory.makeLength((cutIn.getValue() + cutOut.getValue()) / 2.0, cutIn.getUnit())).getValue() < 0.0) {
            return UnitsFactory.makeLength(0.0, UnitsFactory.TransmittanceRange_CutIn);
        }
        return v;
    }

    public static int[] getColor(ChannelData channelData) {
        int[] toReturn;
        LightSource ls;
        Iterator<Filter> i;
        Length valueWavelength;
        LogicalChannel lc = channelData.getLogicalChannel();
        Channel channel = channelData.getChannel();
        if (lc == null) {
            return null;
        }
        if (!ColorsFactory.hasEmissionExcitationData(channelData, true)) {
            Integer red = ColorsFactory.getValue(channel.getRed());
            Integer green = ColorsFactory.getValue(channel.getGreen());
            Integer blue = ColorsFactory.getValue(channel.getBlue());
            Integer alpha = ColorsFactory.getValue(channel.getAlpha());
            if (red != null && green != null && blue != null && alpha != null) {
                return new int[]{red, green, blue, alpha};
            }
        }
        if ((valueWavelength = lc.getEmissionWave()) != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        Length valueFilter = null;
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (valueFilter == null && i.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(i.next(), true);
            }
        }
        if (valueFilter == null) {
            valueFilter = ColorsFactory.getValueFromFilter(channelData.getFilterSetEmissionFilter(), true);
        }
        if (valueWavelength == null && valueFilter == null && channelData.getLightSource() != null && (ls = channelData.getLightSource()) instanceof Laser) {
            valueWavelength = ((Laser)ls).getWavelength();
        }
        if (valueWavelength != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        valueWavelength = lc.getExcitationWave();
        if (valueWavelength != null) {
            return ColorsFactory.determineColor(valueWavelength);
        }
        if (valueFilter == null && (filters = channelData.getLightPathExcitationFilters()) != null) {
            i = filters.iterator();
            while (valueFilter == null && i.hasNext()) {
                valueFilter = ColorsFactory.getValueFromFilter(i.next(), false);
            }
        }
        if (valueFilter == null) {
            valueFilter = ColorsFactory.getValueFromFilter(channelData.getFilterSetExcitationFilter(), false);
        }
        if ((toReturn = ColorsFactory.determineColor(valueFilter)) != null) {
            return toReturn;
        }
        switch (channelData.getChannelIndex()) {
            case 0: {
                return ColorsFactory.newRedColor();
            }
            case 1: {
                return ColorsFactory.newGreenColor();
            }
        }
        return ColorsFactory.newBlueColor();
    }

    public static int[] determineColor(Length value) {
        if (value == null) {
            return null;
        }
        if (ColorsFactory.rangeBlue(value.getValue())) {
            return ColorsFactory.newBlueColor();
        }
        if (ColorsFactory.rangeGreen(value.getValue())) {
            return ColorsFactory.newGreenColor();
        }
        if (ColorsFactory.rangeRed(value.getValue())) {
            return ColorsFactory.newRedColor();
        }
        return null;
    }

    public static boolean hasEmissionData(ChannelData channelData) {
        return ColorsFactory.hasEmissionExcitationData(channelData, false);
    }

    public static int[] newRedColor() {
        return new int[]{255, 0, 0, 255};
    }

    public static int[] newGreenColor() {
        return new int[]{0, 255, 0, 255};
    }

    public static int[] newBlueColor() {
        return new int[]{0, 0, 255, 255};
    }

    public static int[] newGreyColor() {
        return new int[]{128, 128, 128, 255};
    }

    public static int[] newWhiteColor() {
        return new int[]{255, 255, 255, 255};
    }
}

