/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.repo;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import loci.formats.FormatException;
import loci.formats.ReaderWrapper;
import ome.conditions.ValidationException;
import ome.io.nio.FileBuffer;
import ome.model.core.OriginalFile;
import ome.services.blitz.repo.path.FsFile;
import ome.services.blitz.repo.path.ServerFilePathTransformer;
import ome.services.blitz.util.ChecksumAlgorithmMapper;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumProviderFactory;
import ome.util.checksum.ChecksumType;
import omero.SecurityViolation;
import omero.model.ChecksumAlgorithm;
import org.apache.commons.io.FileUtils;

public class CheckedPath {
    private static final String SAME_DIR = ".";
    private static final String PARENT_DIR = "..";
    private static final ImmutableSet<String> SPECIAL_DIRS = ImmutableSet.of((Object)".", (Object)"..");
    public final FsFile fsFile;
    public boolean isRoot;
    private final File file;
    private String parentDir;
    private String baseName;
    private final String original;
    private final ChecksumProvider checksumProvider;
    protected Long id;
    protected String hash;
    protected String mime;

    private FsFile processSpecialDirectories(FsFile fsFile) throws omero.ValidationException {
        List<String> oldComponents = fsFile.getComponents();
        ArrayDeque<String> newComponents = new ArrayDeque<String>(oldComponents.size());
        for (String oldComponent : oldComponents) {
            if (PARENT_DIR.equals(oldComponent)) {
                if (newComponents.isEmpty()) {
                    throw new omero.ValidationException(null, null, "Path may not make references above root");
                }
                newComponents.removeLast();
                continue;
            }
            if (SAME_DIR.equals(oldComponent)) continue;
            newComponents.addLast(oldComponent);
        }
        return new FsFile(newComponents);
    }

    public CheckedPath(ServerFilePathTransformer serverPaths, String path, ChecksumProviderFactory checksumProviderFactory, ChecksumAlgorithm checksumAlgorithm) throws omero.ValidationException {
        this.original = path;
        if (checksumAlgorithm == null) {
            this.checksumProvider = null;
        } else {
            ChecksumType checksumType = ChecksumAlgorithmMapper.getChecksumType(checksumAlgorithm);
            if (checksumType == null) {
                throw new omero.ValidationException(null, null, "unknown checksum algorithm: " + checksumAlgorithm.getValue().getValue());
            }
            this.checksumProvider = checksumProviderFactory.getProvider(checksumType);
        }
        this.fsFile = this.processSpecialDirectories(new FsFile(path));
        if (!serverPaths.isLegalFsFile(this.fsFile)) {
            throw new omero.ValidationException(null, null, "Path contains illegal components");
        }
        this.file = serverPaths.getServerFileFromFsFile(this.fsFile);
        this.breakPath();
    }

    private CheckedPath(File filePath, FsFile fsFilePath) throws omero.ValidationException {
        this.original = filePath.getPath();
        this.fsFile = fsFilePath;
        this.file = filePath;
        this.checksumProvider = null;
        this.breakPath();
    }

    private void breakPath() throws omero.ValidationException {
        String fullPath = this.fsFile.toString();
        this.isRoot = "".equals(fullPath);
        int lastSeparator = fullPath.lastIndexOf(FsFile.separatorChar);
        if (lastSeparator < 0) {
            this.parentDir = "";
            this.baseName = fullPath;
        } else {
            this.parentDir = fullPath.substring(0, lastSeparator);
            this.baseName = fullPath.substring(lastSeparator + 1);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String hash() {
        if (this.hash == null && this.checksumProvider != null) {
            this.hash = this.checksumProvider.putFile(this.file.getPath()).checksumAsString();
        }
        return this.hash;
    }

    public String getMimetype() {
        if (this.mime == null) {
            this.mime = new MimetypesFileTypeMap().getContentType(this.file);
        }
        return this.mime;
    }

    public CheckedPath parent() throws omero.ValidationException {
        List<String> components = this.fsFile.getComponents();
        if (components.isEmpty()) {
            throw new omero.ValidationException(null, null, "May not obtain parent of repository root");
        }
        components = components.subList(0, components.size() - 1);
        return new CheckedPath(this.file.getParentFile(), new FsFile(components));
    }

    public CheckedPath child(String name) throws omero.ValidationException {
        if (name == null || "".equals(name)) {
            throw new omero.ValidationException(null, null, "null or empty name");
        }
        if (SPECIAL_DIRS.contains((Object)name)) {
            StringBuffer message = new StringBuffer();
            message.append("Only proper child name is allowed, not ");
            for (String dir : SPECIAL_DIRS) {
                message.append('\'');
                message.append(dir);
                message.append('\'');
                message.append(", ");
            }
            message.setLength(message.length() - 2);
            message.append('.');
            throw new omero.ValidationException(null, null, message.toString());
        }
        if (name.indexOf(FsFile.separatorChar) >= 0) {
            throw new omero.ValidationException(null, null, "No subpaths allowed. Path contains '" + FsFile.separatorChar + "'");
        }
        FsFile fullChild = FsFile.concatenate(this.fsFile, new FsFile(name));
        return new CheckedPath(new File(this.original, name), fullChild);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public CheckedPath mustExist() throws omero.ValidationException {
        if (!this.exists()) {
            throw new omero.ValidationException(null, null, this.original + " does not exist");
        }
        return this;
    }

    boolean renameTo(CheckedPath target) {
        return this.file.renameTo(target.file);
    }

    void moveToDir(CheckedPath target, boolean createDestDir) throws IOException {
        FileUtils.moveToDirectory((File)this.file, (File)target.file, (boolean)createDestDir);
    }

    boolean delete() {
        return FileUtils.deleteQuietly((File)this.file);
    }

    public CheckedPath mustEdit() throws SecurityViolation {
        if (!this.canEdit()) {
            throw new SecurityViolation(null, null, this.original + " is not editable.");
        }
        return this;
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canEdit() {
        return true;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    protected String getDirname() {
        return this.fsFile.toString() + FsFile.separatorChar;
    }

    protected String getName() {
        return this.baseName;
    }

    protected String getRelativePath() {
        return this.parentDir + FsFile.separatorChar;
    }

    protected String getFullFsPath() {
        return this.fsFile.toString();
    }

    public FileBuffer getFileBuffer(String mode) {
        return new FileBuffer(this.file.getPath(), mode);
    }

    public long size() {
        return this.file.length();
    }

    public boolean mkdir() {
        return this.file.mkdir();
    }

    public boolean setReadOnly() {
        return this.file.setReadOnly();
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public boolean markModified() {
        return this.file.setLastModified(System.currentTimeMillis());
    }

    public void bfSetId(ReaderWrapper reader) throws FormatException, IOException {
        reader.setId(this.file.getPath());
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.fsFile + ')';
    }

    public OriginalFile asOriginalFile(String mimetype) {
        OriginalFile ofile = new OriginalFile();
        ofile.setName(this.getName());
        ofile.setMimetype(mimetype);
        ofile.setPath(this.getRelativePath());
        boolean mimeDir = "Directory".equals(mimetype);
        boolean actualDir = this.file.isDirectory();
        if (this.file.exists()) {
            ofile.setMtime(new Timestamp(this.file.lastModified()));
            if (actualDir) {
                ofile.setMimetype("Directory");
                if (mimetype != null && !mimeDir && actualDir && !mimeDir) {
                    throw new ValidationException("File is a directory but mimetype is: " + mimetype);
                }
            } else {
                ofile.setHash(this.hash());
                ofile.setSize(Long.valueOf(this.file.length()));
            }
        }
        return ofile;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CheckedPath)) {
            return false;
        }
        return this.file.equals(((CheckedPath)object).file);
    }

    public int hashCode() {
        return this.file.hashCode() * 98;
    }
}

