/*
 * Decompiled with CFR 0.152.
 */
package ome.services.throttling;

import Ice.Current;
import java.lang.reflect.Method;
import ome.system.OmeroContext;
import omero.InternalException;
import omero.ServerError;
import omero.util.IceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    protected final Object cb;
    protected final boolean isVoid;
    protected final Current current;
    protected final Method response;
    protected final Method exception;

    public Task(Object callback, Current current, boolean isVoid) {
        this.current = current;
        this.isVoid = isVoid;
        this.cb = callback;
        if (callback != null) {
            this.response = this.getMethod(callback, "ice_response");
            this.exception = this.getMethod(callback, "ice_exception");
        } else {
            this.response = null;
            this.exception = null;
        }
    }

    public abstract void run(OmeroContext var1);

    protected void response(Object rv, OmeroContext ctx) {
        try {
            if (this.isVoid) {
                this.response.invoke(this.cb, new Object[0]);
            } else {
                this.response.invoke(this.cb, this.postProcess(rv));
            }
        }
        catch (Exception e) {
            InternalException ie = new InternalException();
            IceMapper.fillServerError(ie, e);
            ie.message = "Failed to invoke: " + this.toString();
            log.error(ie.message, (Throwable)e);
            this.exception((Throwable)((Object)ie), ctx);
        }
    }

    protected Object postProcess(Object rv) throws ServerError {
        return rv;
    }

    protected void exception(Throwable ex, OmeroContext ctx) {
        try {
            if (!(ex instanceof Exception)) {
                log.error("Throwable thrown!", ex);
            }
            IceMapper mapper = new IceMapper();
            ex = mapper.handleException(ex, ctx);
            this.exception.invoke(this.cb, ex);
        }
        catch (Exception e2) {
            String msg = "Failed to invoke exception()";
            log.error(msg, (Throwable)e2);
            throw new RuntimeException("Failed to invoke exception()", e2);
        }
    }

    Method getMethod(Object o, String methodName) {
        Class c = this.getPublicInterface(o.getClass());
        Method[] methods = c.getMethods();
        Method rv = null;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!methodName.equals(m.getName())) continue;
            if (rv != null) {
                throw new RuntimeException(methodName + " exists twice!");
            }
            rv = m;
        }
        return rv;
    }

    private Class getPublicInterface(Class c) {
        if (!c.getName().startsWith("AMD_")) {
            while (!c.equals(Object.class)) {
                Class<?>[] ifaces;
                for (Class<?> c2 : ifaces = c.getInterfaces()) {
                    if (!c2.getSimpleName().startsWith("AMD_")) continue;
                    return c2;
                }
                c = c.getSuperclass();
            }
            throw new RuntimeException("No public AMD_ interface found.");
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" (");
        sb.append(this.cb);
        sb.append(" )");
        return sb.toString();
    }
}

