/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import Ice.ObjectFactory;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import ome.model.ModelBased;
import ome.model.units.BigResult;
import ome.model.units.Conversion;
import ome.units.unit.Unit;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.handlers.UnitsTemperatureEnumHandler;
import omero.client;
import omero.model.Temperature;
import omero.model.enums.UnitsTemperature;

public class TemperatureI
extends Temperature
implements ModelBased {
    private static final long serialVersionUID = 1L;
    private static final Map<UnitsTemperature, Map<UnitsTemperature, Conversion>> conversions;
    private static final Map<UnitsTemperature, String> SYMBOLS;
    public static final ObjectFactory Factory;

    private static Map<UnitsTemperature, Conversion> createMapCELSIUS() {
        EnumMap<UnitsTemperature, Conversion> c = new EnumMap<UnitsTemperature, Conversion>(UnitsTemperature.class);
        c.put(UnitsTemperature.FAHRENHEIT, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)9L), Conversion.Int((long)5L)}), Conversion.Sym((String)"c")}), Conversion.Int((long)32L)}));
        c.put(UnitsTemperature.KELVIN, Conversion.Add((Conversion[])new Conversion[]{Conversion.Sym((String)"c"), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)5463L), Conversion.Int((long)20L)})}));
        c.put(UnitsTemperature.RANKINE, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)9L), Conversion.Int((long)5L)}), Conversion.Sym((String)"c")}), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)49167L), Conversion.Int((long)100L)})}));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsTemperature, Conversion> createMapFAHRENHEIT() {
        EnumMap<UnitsTemperature, Conversion> c = new EnumMap<UnitsTemperature, Conversion>(UnitsTemperature.class);
        c.put(UnitsTemperature.CELSIUS, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)5L), Conversion.Int((long)9L)}), Conversion.Sym((String)"f")}), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)-160L), Conversion.Int((long)9L)})}));
        c.put(UnitsTemperature.KELVIN, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)5L), Conversion.Int((long)9L)}), Conversion.Sym((String)"f")}), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)45967L), Conversion.Int((long)180L)})}));
        c.put(UnitsTemperature.RANKINE, Conversion.Add((Conversion[])new Conversion[]{Conversion.Sym((String)"f"), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)45967L), Conversion.Int((long)100L)})}));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsTemperature, Conversion> createMapKELVIN() {
        EnumMap<UnitsTemperature, Conversion> c = new EnumMap<UnitsTemperature, Conversion>(UnitsTemperature.class);
        c.put(UnitsTemperature.CELSIUS, Conversion.Add((Conversion[])new Conversion[]{Conversion.Sym((String)"k"), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)-5463L), Conversion.Int((long)20L)})}));
        c.put(UnitsTemperature.FAHRENHEIT, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)9L), Conversion.Int((long)5L)}), Conversion.Sym((String)"k")}), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)-45967L), Conversion.Int((long)100L)})}));
        c.put(UnitsTemperature.RANKINE, Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)9L), Conversion.Int((long)5L)}), Conversion.Sym((String)"k")}));
        return Collections.unmodifiableMap(c);
    }

    private static Map<UnitsTemperature, Conversion> createMapRANKINE() {
        EnumMap<UnitsTemperature, Conversion> c = new EnumMap<UnitsTemperature, Conversion>(UnitsTemperature.class);
        c.put(UnitsTemperature.CELSIUS, Conversion.Add((Conversion[])new Conversion[]{Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)5L), Conversion.Int((long)9L)}), Conversion.Sym((String)"r")}), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)-5463L), Conversion.Int((long)20L)})}));
        c.put(UnitsTemperature.FAHRENHEIT, Conversion.Add((Conversion[])new Conversion[]{Conversion.Sym((String)"r"), Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)-45967L), Conversion.Int((long)100L)})}));
        c.put(UnitsTemperature.KELVIN, Conversion.Mul((Conversion[])new Conversion[]{Conversion.Rat((Conversion[])new Conversion[]{Conversion.Int((long)5L), Conversion.Int((long)9L)}), Conversion.Sym((String)"r")}));
        return Collections.unmodifiableMap(c);
    }

    public static String lookupSymbol(UnitsTemperature unit) {
        return SYMBOLS.get(unit);
    }

    public static final ObjectFactory makeFactory(client client2) {
        return new ObjectFactory(){

            public Ice.Object create(String arg0) {
                return new TemperatureI();
            }

            public void destroy() {
            }
        };
    }

    public static ome.xml.model.enums.UnitsTemperature makeXMLUnit(String unit) {
        try {
            return ome.xml.model.enums.UnitsTemperature.fromString((String)unit);
        }
        catch (EnumerationException e) {
            throw new RuntimeException("Bad Temperature unit: " + unit, e);
        }
    }

    public static ome.units.quantity.Temperature makeXMLQuantity(double d, String unit) {
        Unit units = UnitsTemperatureEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsTemperature)TemperatureI.makeXMLUnit(unit));
        return new ome.units.quantity.Temperature((Number)d, units);
    }

    public static ome.units.quantity.Temperature convert(Temperature t) {
        if (t == null) {
            return null;
        }
        Double v = t.getValue();
        String u = ome.model.enums.UnitsTemperature.valueOf((String)t.getUnit().toString()).getSymbol();
        ome.xml.model.enums.UnitsTemperature units = TemperatureI.makeXMLUnit(u);
        Unit units2 = UnitsTemperatureEnumHandler.getBaseUnit((ome.xml.model.enums.UnitsTemperature)units);
        return new ome.units.quantity.Temperature((Number)v, units2);
    }

    public TemperatureI() {
    }

    public TemperatureI(double d, UnitsTemperature unit) {
        this.setUnit(unit);
        this.setValue(d);
    }

    public TemperatureI(double d, Unit<ome.units.quantity.Temperature> unit) {
        this(d, ome.model.enums.UnitsTemperature.bySymbol((String)unit.getSymbol()));
    }

    public TemperatureI(Temperature value, Unit<ome.units.quantity.Temperature> ul) throws BigResult {
        this(value, ome.model.enums.UnitsTemperature.bySymbol((String)ul.getSymbol()).toString());
    }

    public TemperatureI(double d, ome.model.enums.UnitsTemperature ul) {
        this(d, UnitsTemperature.valueOf(ul.toString()));
    }

    public TemperatureI(Temperature value, String target) throws BigResult {
        UnitsTemperature sourceUnit = value.getUnit();
        UnitsTemperature targetUnit = UnitsTemperature.valueOf(target);
        if (sourceUnit == null || targetUnit == null) {
            throw new IllegalArgumentException(String.format("conversion impossible from %s to %s", sourceUnit, targetUnit));
        }
        String source = value.getUnit().toString();
        if (target.equals(source)) {
            this.setValue(value.getValue());
            this.setUnit(value.getUnit());
        } else {
            BigDecimal big;
            double orig;
            Conversion conversion = conversions.get(sourceUnit).get(targetUnit);
            if (conversion == null) {
                throw new IllegalArgumentException(String.format("%f %s cannot be converted to %s", value.getValue(), value.getUnit(), target));
            }
            double converted = orig = value.getValue();
            if (Double.isFinite(orig) && !Double.isFinite(converted = (big = conversion.convert(orig)).doubleValue())) {
                throw new BigResult(big, "Failed to convert " + source + ":" + target);
            }
            this.setValue(converted);
            this.setUnit(targetUnit);
        }
    }

    public TemperatureI(Temperature value, UnitsTemperature target) throws BigResult {
        this(value, target.toString());
    }

    public TemperatureI(ome.units.quantity.Temperature value) {
        ome.model.enums.UnitsTemperature internal = ome.model.enums.UnitsTemperature.bySymbol((String)value.unit().getSymbol());
        UnitsTemperature ul = UnitsTemperature.valueOf(internal.toString());
        this.setValue(value.value().doubleValue());
        this.setUnit(ul);
    }

    @Override
    public double getValue(Current current) {
        return this.value;
    }

    @Override
    public void setValue(double value, Current current) {
        this.value = value;
    }

    @Override
    public UnitsTemperature getUnit(Current current) {
        return this.unit;
    }

    @Override
    public void setUnit(UnitsTemperature unit, Current current) {
        this.unit = unit;
    }

    @Override
    public String getSymbol(Current current) {
        return SYMBOLS.get(this.unit);
    }

    @Override
    public Temperature copy(Current ignore) {
        TemperatureI copy = new TemperatureI();
        copy.setValue(this.getValue());
        copy.setUnit(this.getUnit());
        return copy;
    }

    public void copyObject(Filterable model, ModelMapper mapper) {
        if (!(model instanceof ome.model.units.Temperature)) {
            throw new IllegalArgumentException("Temperature cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
        ome.model.units.Temperature t = (ome.model.units.Temperature)model;
        this.value = t.getValue();
        this.unit = UnitsTemperature.valueOf(t.getUnit().toString());
    }

    public Filterable fillObject(ReverseModelMapper mapper) {
        ome.model.enums.UnitsTemperature ut = ome.model.enums.UnitsTemperature.valueOf((String)this.getUnit().toString());
        ome.model.units.Temperature t = new ome.model.units.Temperature(this.getValue(), ut);
        return t;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Temperature(" + this.value + " " + this.unit + ")";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Temperature other = (Temperature)obj;
        if (this.unit != other.unit) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
    }

    static {
        EnumMap<UnitsTemperature, Map<UnitsTemperature, Conversion>> c = new EnumMap<UnitsTemperature, Map<UnitsTemperature, Conversion>>(UnitsTemperature.class);
        c.put(UnitsTemperature.CELSIUS, TemperatureI.createMapCELSIUS());
        c.put(UnitsTemperature.FAHRENHEIT, TemperatureI.createMapFAHRENHEIT());
        c.put(UnitsTemperature.KELVIN, TemperatureI.createMapKELVIN());
        c.put(UnitsTemperature.RANKINE, TemperatureI.createMapRANKINE());
        conversions = Collections.unmodifiableMap(c);
        HashMap<UnitsTemperature, String> s = new HashMap<UnitsTemperature, String>();
        s.put(UnitsTemperature.CELSIUS, "\u00b0C");
        s.put(UnitsTemperature.FAHRENHEIT, "\u00b0F");
        s.put(UnitsTemperature.KELVIN, "K");
        s.put(UnitsTemperature.RANKINE, "\u00b0R");
        SYMBOLS = s;
        Factory = TemperatureI.makeFactory(null);
    }
}

