/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import omero.api.ResolutionDescription;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.exception.DataSourceException;
import omero.gateway.facility.Facility;
import omero.gateway.model.PixelsData;
import omero.gateway.rnd.DataSink;
import omero.gateway.rnd.Plane2D;
import omero.romio.PlaneDef;
import org.apache.commons.collections.MapIterator;
import org.apache.commons.collections.map.MultiKeyMap;

public class RawDataFacility
extends Facility
implements AutoCloseable {
    private MultiKeyMap cache = new MultiKeyMap();

    RawDataFacility(Gateway gateway) {
        super(gateway);
    }

    public Map<Integer, int[]> getHistogram(SecurityContext ctx, PixelsData pixels, int[] channels, int z, int t) throws DSOutOfServiceException, DSAccessException {
        z = z >= 0 ? z : 0;
        t = t >= 0 ? t : 0;
        PlaneDef plane = new PlaneDef(0, 0, 0, z, t, null, -1);
        return this.getHistogram(ctx, pixels, channels, 256, true, plane);
    }

    public Map<Integer, int[]> getHistogram(SecurityContext ctx, PixelsData pixels, int[] channels, int binCount, boolean globalRange, PlaneDef plane) throws DSOutOfServiceException, DSAccessException {
        if (pixels == null) {
            return Collections.emptyMap();
        }
        try {
            if (plane == null) {
                plane = new PlaneDef(0, 0, 0, 0, 0, null, -1);
            }
            return this.getDataSink(ctx, pixels, this.gateway).getHistogram(channels, binCount, globalRange, plane);
        }
        catch (Exception e) {
            this.handleException(this, e, "Can't initiate DataSink to get histogram data.");
            return null;
        }
    }

    public Plane2D getPlane(SecurityContext ctx, PixelsData pixels, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        if (pixels == null) {
            return null;
        }
        try {
            DataSink ds = this.getDataSink(ctx, pixels, this.gateway);
            Plane2D plane = ds.getPlane(z, t, c);
            return plane;
        }
        catch (Exception e) {
            this.handleException(this, e, "Can't initiate DataSink for plane z=" + z + " t=" + t + " c=" + c);
            return null;
        }
    }

    public Plane2D getTile(SecurityContext ctx, PixelsData pixels, int z, int t, int c, int x, int y, int w, int h) throws DataSourceException {
        return this.getTile(ctx, pixels, z, t, c, x, y, w, h, -1);
    }

    public Plane2D getTile(SecurityContext ctx, PixelsData pixels, int z, int t, int c, int x, int y, int w, int h, int resolutionLevel) throws DataSourceException {
        if (pixels == null) {
            return null;
        }
        try {
            DataSink ds = this.getDataSink(ctx, pixels, this.gateway);
            int oldResLevel = -1;
            if (resolutionLevel >= 0) {
                oldResLevel = ds.setResolutionLevel(resolutionLevel);
            }
            Plane2D tile = ds.getTile(z, t, c, x, y, w, h);
            if (resolutionLevel >= 0) {
                ds.setResolutionLevel(oldResLevel);
            }
            return tile;
        }
        catch (DSOutOfServiceException e) {
            throw new DataSourceException("Can't initiate DataSink", e);
        }
    }

    public List<ResolutionDescription> getResolutionDescriptions(SecurityContext ctx, PixelsData pixels) throws DataSourceException {
        if (pixels == null) {
            return null;
        }
        try {
            return this.getDataSink(ctx, pixels, this.gateway).getResolutionDescriptions();
        }
        catch (DSOutOfServiceException e) {
            throw new DataSourceException("Can't initiate DataSink", e);
        }
    }

    private DataSink getDataSink(SecurityContext ctx, PixelsData pixels, Gateway gateway) throws DSOutOfServiceException {
        DataSink ds = (DataSink)this.cache.get((Object)ctx.getGroupID(), (Object)pixels.getId());
        if (ds == null) {
            ds = new DataSink(ctx, pixels, gateway);
            this.cache.put((Object)ctx.getGroupID(), (Object)pixels.getId(), (Object)ds);
        }
        return ds;
    }

    @Override
    public void close() {
        MapIterator it = this.cache.mapIterator();
        while (it.hasNext()) {
            it.next();
            ((DataSink)it.getValue()).close();
        }
        this.firePropertyChanged("PROP_FACILITY_CLOSED", null, this.getClass().getName());
        this.removePropertyChangeListener(null);
    }
}

