/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.units.BigResult;
import omero.RInt;
import omero.RString;
import omero.gateway.model.DataObject;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.SetMutator;
import omero.gateway.model.WellData;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Plate;
import omero.model.PlateAcquisition;
import omero.model.PlateI;
import omero.model.ScreenPlateLink;
import omero.model.Well;
import omero.model.enums.UnitsLength;
import omero.rtypes;

public class PlateData
extends DataObject {
    public static final int ASCENDING_NUMBER = 0;
    public static final int ASCENDING_LETTER = 1;
    public static final int DESCENDING_NUMBER = 2;
    public static final int DESCENDING_LETTER = 3;
    public static final String NAME = "ome.model.screen.Plate_name";
    public static final String DESCRIPTION = "ome.model.screen.Plate_description";
    public static final String WELLS = "ome.model.screen.Plate_wells";
    public static final String SCREEN_LINKS = "ome.model.screen.Plate_screenLinks";
    public static final String ANNOTATIONS = "ome.model.screen.Plate_annotationLinks";
    private static final String LETTER_CONVENTION = "letter";
    private static final String NUMBER_CONVENTION = "number";
    private Set<ScreenData> screens;
    private Set<PlateAcquisitionData> plateAcquisitions;

    private int getSequenceIndex(String value) {
        if (LETTER_CONVENTION.equals(value)) {
            return 1;
        }
        if (NUMBER_CONVENTION.equals(value)) {
            return 0;
        }
        return -1;
    }

    public PlateData() {
        this.setDirty(true);
        this.setValue(new PlateI());
    }

    public PlateData(Plate plate) {
        if (plate == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue(plate);
    }

    public Set<WellData> getWells() {
        HashSet<WellData> wells = new HashSet<WellData>();
        for (Well w : this.asPlate().copyWells()) {
            wells.add(new WellData(w));
        }
        return wells.isEmpty() ? null : wells;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name cannot be null.");
        }
        this.setDirty(true);
        this.asPlate().setName(rtypes.rstring(name));
    }

    public String getName() {
        RString n = this.asPlate().getName();
        if (n == null || n.getValue() == null) {
            throw new IllegalStateException("The name should never have bee null.");
        }
        return n.getValue();
    }

    public void setDescription(String description) {
        this.setDirty(true);
        this.asPlate().setDescription(rtypes.rstring(description));
    }

    public String getDescription() {
        RString d = this.asPlate().getDescription();
        return d == null ? null : d.getValue();
    }

    public Map<Long, Long> getAnnotationsCounts() {
        return this.asPlate().getAnnotationLinksCountPerOwner();
    }

    public Set<ScreenData> getScreens() {
        if (this.screens == null && this.asPlate().sizeOfScreenLinks() >= 0) {
            this.screens = new HashSet<ScreenData>();
            List<ScreenPlateLink> links = this.asPlate().copyScreenLinks();
            for (ScreenPlateLink link : links) {
                this.screens.add(new ScreenData(link.getParent()));
            }
        }
        return this.screens == null ? null : new HashSet<ScreenData>(this.screens);
    }

    public void setScreens(Set<ScreenData> value) {
        Set<ScreenData> currentValue = this.getScreens();
        SetMutator<ScreenData> m = new SetMutator<ScreenData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asPlate().unlinkScreen(m.nextDeletion().asScreen());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asPlate().linkScreen(m.nextAddition().asScreen());
        }
        this.screens = new HashSet<ScreenData>(m.result());
    }

    public int getColumnSequenceIndex() {
        RString value = this.asPlate().getColumnNamingConvention();
        if (value == null) {
            return 0;
        }
        String v = value.getValue();
        if (v == null) {
            return 0;
        }
        int index = this.getSequenceIndex(value.getValue().toLowerCase());
        if (index == -1) {
            return 0;
        }
        return index;
    }

    public int getRowSequenceIndex() {
        RString value = this.asPlate().getRowNamingConvention();
        if (value == null) {
            return 1;
        }
        String v = value.getValue();
        if (v == null) {
            return 1;
        }
        int index = this.getSequenceIndex(v.toLowerCase());
        if (index == -1) {
            return 1;
        }
        return index;
    }

    public int getDefaultSample() {
        RInt value = this.asPlate().getDefaultSample();
        if (value == null) {
            return 0;
        }
        return value.getValue();
    }

    public void setDefaultSample(int value) {
        if (value < 0) {
            value = 0;
        }
        this.asPlate().setDefaultSample(rtypes.rint(value));
    }

    public String getStatus() {
        RString value = this.asPlate().getStatus();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getExternalIdentifier() {
        RString value = this.asPlate().getExternalIdentifier();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public String getPlateType() {
        int value;
        Plate plate = this.asPlate();
        int c = 0;
        int r = 0;
        RInt v = plate.getColumns();
        if (v != null) {
            c = v.getValue();
        }
        if ((v = plate.getRows()) != null) {
            r = v.getValue();
        }
        if ((value = c * r) <= 0) {
            return "";
        }
        return value + "-Well Plate";
    }

    public Length getWellOriginX(UnitsLength unit) throws BigResult {
        Length value = this.asPlate().getWellOriginX();
        if (value == null) {
            return new LengthI(0.0, UnitsLength.REFERENCEFRAME);
        }
        return unit == null ? value : new LengthI(value, unit);
    }

    public Length getWellOriginY(UnitsLength unit) throws BigResult {
        Length value = this.asPlate().getWellOriginY();
        if (value == null) {
            return new LengthI(0.0, UnitsLength.REFERENCEFRAME);
        }
        return unit == null ? value : new LengthI(value, unit);
    }

    public Set<PlateAcquisitionData> getPlateAcquisitions() {
        if (this.plateAcquisitions == null && this.asPlate().sizeOfPlateAcquisitions() >= 0) {
            this.plateAcquisitions = new HashSet<PlateAcquisitionData>();
            List<PlateAcquisition> links = this.asPlate().copyPlateAcquisitions();
            for (PlateAcquisition link : links) {
                this.plateAcquisitions.add(new PlateAcquisitionData(link));
            }
        }
        return this.plateAcquisitions == null ? null : new HashSet<PlateAcquisitionData>(this.plateAcquisitions);
    }

    public void setPlateAcquisition(Set<PlateAcquisitionData> value) {
        Set<PlateAcquisitionData> currentValue = this.getPlateAcquisitions();
        SetMutator<PlateAcquisitionData> m = new SetMutator<PlateAcquisitionData>(currentValue, value);
        while (m.moreDeletions()) {
            this.setDirty(true);
            this.asPlate().removePlateAcquisition((PlateAcquisition)m.nextDeletion().asIObject());
        }
        while (m.moreAdditions()) {
            this.setDirty(true);
            this.asPlate().addPlateAcquisition((PlateAcquisition)m.nextAddition().asIObject());
        }
        this.plateAcquisitions = new HashSet<PlateAcquisitionData>(m.result());
    }

    public void setExternalIdentifier(String value) {
        if (value != null && value.trim().length() != 0) {
            this.asPlate().setExternalIdentifier(rtypes.rstring(value));
        }
    }

    public void setStatus(String value) {
        if (value != null && value.trim().length() != 0) {
            this.asPlate().setStatus(rtypes.rstring(value));
        }
    }
}

