/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import omero.RString;
import omero.model.IObject;
import omero.rtypes;
import org.apache.commons.beanutils.PropertyUtils;

public class Utils {
    public static String getFolderAsContainerName(File file) {
        if (file.isFile()) {
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                return null;
            }
            return parentFile.getName();
        }
        return file.getName();
    }

    public static String getDisplayedFileName(String fullPath, Integer number) {
        if (fullPath == null) {
            return fullPath;
        }
        if (number == null || number < 0) {
            return fullPath;
        }
        String[] l = Utils.splitString(fullPath);
        String extension = null;
        if (fullPath.endsWith("\\")) {
            extension = "\\";
        } else if (fullPath.endsWith("/")) {
            extension = "/";
        }
        String start = null;
        if (fullPath.startsWith("\\")) {
            start = "\\";
        } else if (fullPath.startsWith("/")) {
            start = "/";
        }
        String sep = Utils.getStringSeparator(fullPath);
        if (sep == null) {
            sep = "";
        }
        Object text = "";
        int folder = -1;
        if (number != null && number >= 0) {
            folder = number;
        }
        if (folder == -1) {
            return null;
        }
        if (l != null && l.length > 1) {
            int n = 0;
            if (folder < l.length) {
                n = l.length - folder - 2;
            }
            if (n < 0) {
                n = 0;
            }
            int m = l.length - 1;
            for (int i = l.length - 1; i > n; --i) {
                text = i == m ? l[i] : l[i] + sep + (String)text;
            }
            if (n == 0 && start != null) {
                text = start + (String)text;
            }
            if (extension != null) {
                text = (String)text + extension;
            }
            return text;
        }
        return null;
    }

    public static String[] splitString(String originalName) {
        String[] l = null;
        if (originalName == null) {
            return l;
        }
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
        } else if (Pattern.compile("\\\\").matcher(originalName).find()) {
            l = originalName.split("\\\\", 0);
        }
        return l;
    }

    public static String getStringSeparator(String originalName) {
        if (originalName == null) {
            return null;
        }
        String[] l = null;
        if (Pattern.compile("/").matcher(originalName).find()) {
            l = originalName.split("/", 0);
            if (l.length > 0) {
                return "/";
            }
        } else if (Pattern.compile("\\\\").matcher(originalName).find() && (l = originalName.split("\\\\", 0)).length > 0) {
            return "\\";
        }
        return null;
    }

    private static void assertEnumType(Class<? extends IObject> enumClass) {
        if ("omero.model".equals(enumClass.getPackage().getName())) {
            for (PropertyDescriptor descriptor : PropertyUtils.getPropertyDescriptors(enumClass)) {
                if (!"value".equals(descriptor.getName()) || descriptor.getPropertyType() != RString.class) continue;
                return;
            }
        }
        throw new IllegalArgumentException("requires OMERO.blitz API enumeration type, not " + enumClass.getName());
    }

    public static <E extends IObject, I extends E> List<E> toEnum(Class<E> enumClass, Class<I> instanceClass, Collection<String> enumValues) throws ReflectiveOperationException {
        Utils.assertEnumType(enumClass);
        ArrayList<IObject> enumInstances = new ArrayList<IObject>(enumValues.size());
        for (String enumValue : enumValues) {
            IObject enumInstance = (IObject)instanceClass.newInstance();
            PropertyUtils.setProperty((Object)enumInstance, (String)"value", (Object)rtypes.rstring(enumValue));
            enumInstances.add(enumInstance);
        }
        return enumInstances;
    }

    public static <E extends IObject> List<String> fromEnum(Collection<E> enumInstances) throws ReflectiveOperationException {
        ArrayList<String> enumValues = new ArrayList<String>(enumInstances.size());
        for (IObject enumInstance : enumInstances) {
            Utils.assertEnumType(enumInstance.getClass());
            RString enumValue = (RString)PropertyUtils.getProperty((Object)enumInstance, (String)"value");
            enumValues.add(enumValue.getValue());
        }
        return enumValues;
    }

    public static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }
}

